/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import protostream.com.squareup.protoparser.AutoValue_ExtendElement;
import protostream.com.squareup.protoparser.FieldElement;
import protostream.com.squareup.protoparser.MessageElement;
import protostream.com.squareup.protoparser.Utils;

public abstract class ExtendElement {
    public static Builder builder() {
        return new Builder();
    }

    ExtendElement() {
    }

    public abstract String name();

    public abstract String qualifiedName();

    public abstract String documentation();

    public abstract List<FieldElement> fields();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("extend ").append(this.name()).append(" {");
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Utils.appendIndented(builder, field.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Builder {
        private String name;
        private String qualifiedName;
        private String documentation = "";
        private final List<FieldElement> fields = new ArrayList<FieldElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            if (this.qualifiedName == null) {
                this.qualifiedName = name;
            }
            return this;
        }

        public Builder qualifiedName(String qualifiedName) {
            this.qualifiedName = Utils.checkNotNull(qualifiedName, "qualifiedName");
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addField(FieldElement field) {
            this.fields.add(Utils.checkNotNull(field, "field"));
            return this;
        }

        public Builder addFields(Collection<FieldElement> fields) {
            for (FieldElement field : Utils.checkNotNull(fields, "fields")) {
                this.addField(field);
            }
            return this;
        }

        public ExtendElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.qualifiedName, "qualifiedName");
            MessageElement.validateFieldTagUniqueness(this.qualifiedName, this.fields, Collections.emptyList());
            return new AutoValue_ExtendElement(this.name, this.qualifiedName, this.documentation, Utils.immutableCopyOf(this.fields));
        }
    }
}

