/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.connections;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.storage.hotRod.common.AutogeneratedHotRodDescriptors;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.common.HotRodVersionUtils;
import org.keycloak.models.map.storage.hotRod.connections.DefaultHotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProviderFactory;
import org.keycloak.models.map.storage.hotRod.locking.HotRodLocksUtils;
import org.keycloak.models.map.storage.hotRod.transaction.HotRodTransactionManagerLookup;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class DefaultHotRodConnectionProviderFactory
implements HotRodConnectionProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "default";
    public static final String SCRIPT_CACHE = "___script_cache";
    public static final String HOT_ROD_LOCKS_CACHE_NAME = "locks";
    private static final String HOT_ROD_INIT_LOCK_NAME = "HOT_ROD_INIT_LOCK";
    private static final Logger LOG = Logger.getLogger(DefaultHotRodConnectionProviderFactory.class);
    private Config.Scope config;
    private volatile RemoteCacheManager remoteCacheManager;
    private TransactionManagerLookup transactionManagerLookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HotRodConnectionProvider create(KeycloakSession session) {
        if (this.remoteCacheManager == null) {
            DefaultHotRodConnectionProviderFactory defaultHotRodConnectionProviderFactory = this;
            synchronized (defaultHotRodConnectionProviderFactory) {
                if (this.remoteCacheManager == null) {
                    this.lazyInit(session);
                }
            }
        }
        return new DefaultHotRodConnectionProvider(this.remoteCacheManager);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.close();
            this.remoteCacheManager = null;
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyInit(KeycloakSession session) {
        LOG.debugf("Initializing HotRod client connection to Infinispan server.", new Object[0]);
        this.transactionManagerLookup = new HotRodTransactionManagerLookup(session);
        ConfigurationBuilder remoteBuilder = new ConfigurationBuilder();
        remoteBuilder.addServer().host(this.config.get("host", "localhost")).port(this.config.getInt("port", Integer.valueOf(11222)).intValue()).clientIntelligence(ClientIntelligence.HASH_DISTRIBUTION_AWARE).marshaller((Marshaller)new ProtoStreamMarshaller());
        if (this.config.getBoolean("enableSecurity", Boolean.valueOf(true)).booleanValue()) {
            remoteBuilder.security().authentication().saslMechanism("SCRAM-SHA-512").username(this.config.get("username", "admin")).password(this.config.get("password", "admin")).realm(this.config.get("realm", PROVIDER_ID));
        }
        LOG.debugf("Configuring remote caches.", new Object[0]);
        this.configureRemoteCaches(remoteBuilder);
        remoteBuilder.addContextInitializer((SerializationContextInitializer)CommonPrimitivesProtoSchemaInitializer.INSTANCE);
        AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getProtoSchema).forEach(arg_0 -> ((ConfigurationBuilder)remoteBuilder).addContextInitializer(arg_0));
        this.configureLocking(remoteBuilder);
        this.remoteCacheManager = new RemoteCacheManager(remoteBuilder.build());
        RemoteCache locksCache = this.remoteCacheManager.getCache(HOT_ROD_LOCKS_CACHE_NAME);
        try {
            HotRodLocksUtils.repeatPutIfAbsent((RemoteCache<String, String>)locksCache, HOT_ROD_INIT_LOCK_NAME, Duration.ofMillis(900L), 50);
            Set remoteCaches = AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).collect(Collectors.toSet());
            LOG.debugf("Uploading proto schema to Infinispan server.", new Object[0]);
            this.registerSchemata();
            String reindexCaches = this.config.get("reindexCaches", null);
            RemoteCacheManagerAdmin administration = this.remoteCacheManager.administration();
            if (reindexCaches != null && reindexCaches.equals("all")) {
                LOG.infof("Reindexing all caches. This can take a long time to complete. While the rebuild operation is in progress, queries might return fewer results.", new Object[0]);
                remoteCaches.stream().peek(arg_0 -> ((RemoteCacheManager)this.remoteCacheManager).getCache(arg_0)).forEach(arg_0 -> ((RemoteCacheManagerAdmin)administration).reindexCache(arg_0));
            } else if (reindexCaches != null && !reindexCaches.isEmpty()) {
                Arrays.stream(reindexCaches.split(",")).map(String::trim).filter(e -> !e.isEmpty()).filter(remoteCaches::contains).peek(cacheName -> LOG.infof("Reindexing %s cache. This can take a long time to complete. While the rebuild operation is in progress, queries might return fewer results.", cacheName)).peek(arg_0 -> ((RemoteCacheManager)this.remoteCacheManager).getCache(arg_0)).forEach(arg_0 -> ((RemoteCacheManagerAdmin)administration).reindexCache(arg_0));
            }
            LOG.infof("HotRod client configuration was successful.", new Object[0]);
        }
        finally {
            if (!HotRodLocksUtils.removeWithInstanceIdentifier((ConcurrentMap<String, String>)locksCache, HOT_ROD_INIT_LOCK_NAME)) {
                throw new RuntimeException("Cannot release HotRod init lock");
            }
        }
    }

    private void configureLocking(ConfigurationBuilder builder) {
        builder.remoteCache(HOT_ROD_LOCKS_CACHE_NAME).configurationURI(DefaultHotRodConnectionProviderFactory.getCacheConfigUri(HOT_ROD_LOCKS_CACHE_NAME));
    }

    private void registerSchemata() {
        RemoteCache protoMetadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        Set<Object> cachesForIndexUpdate = new HashSet();
        CommonPrimitivesProtoSchemaInitializer commonSchema = CommonPrimitivesProtoSchemaInitializer.INSTANCE;
        String currentProtoFile = (String)protoMetadataCache.get((Object)commonSchema.getProtoFileName());
        if (currentProtoFile == null) {
            protoMetadataCache.put((Object)commonSchema.getProtoFileName(), (Object)commonSchema.getProtoFile());
        } else if (this.isUpdateNeeded(commonSchema.getProtoFileName(), 1, currentProtoFile)) {
            protoMetadataCache.put((Object)commonSchema.getProtoFileName(), (Object)commonSchema.getProtoFile());
            cachesForIndexUpdate = AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).collect(Collectors.toSet());
        }
        for (HotRodEntityDescriptor<?, ?> hotRodEntityDescriptor : AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values()) {
            GeneratedSchema schema = hotRodEntityDescriptor.getProtoSchema();
            currentProtoFile = (String)protoMetadataCache.get((Object)schema.getProtoFileName());
            if (currentProtoFile == null) {
                protoMetadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
                continue;
            }
            if (!this.isUpdateNeeded(schema.getProtoFileName(), hotRodEntityDescriptor.getCurrentVersion(), currentProtoFile)) continue;
            protoMetadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
            cachesForIndexUpdate.add(hotRodEntityDescriptor.getCacheName());
        }
        String errors = (String)protoMetadataCache.get((Object)".errors");
        if (errors != null) {
            for (String errorFile : errors.split("\n")) {
                LOG.errorf("\nThere was an error in proto file: %s\nError message: %s\nCurrent proto schema: %s", (Object)errorFile, protoMetadataCache.get((Object)(errorFile + ".errors")), protoMetadataCache.get((Object)errorFile));
            }
            throw new IllegalStateException("Some Protobuf schema files contain errors: " + errors);
        }
        RemoteCacheManagerAdmin remoteCacheManagerAdmin = this.remoteCacheManager.administration();
        cachesForIndexUpdate.forEach(arg_0 -> ((RemoteCacheManagerAdmin)remoteCacheManagerAdmin).updateIndexSchema(arg_0));
    }

    private boolean isUpdateNeeded(String protoFileName, int currentSchemaVersion, String currentProtoFileDeployed) {
        if (currentProtoFileDeployed == null) {
            return true;
        }
        Integer deployedSchemaVersion = HotRodVersionUtils.parseSchemaVersionFromProtoFile(currentProtoFileDeployed);
        if (deployedSchemaVersion == null) {
            LOG.errorf("Schema %s does not contain expected schema-version definition:\n%s", (Object)protoFileName, (Object)currentProtoFileDeployed);
            throw new IllegalStateException("Deployed schema " + protoFileName + " does not contain expected schema-version definition. See log for more details.");
        }
        if (currentSchemaVersion != deployedSchemaVersion && !HotRodVersionUtils.adjacentVersions(deployedSchemaVersion, currentSchemaVersion)) {
            throw new IllegalStateException("Infinispan server contains too old schema version for " + protoFileName);
        }
        return HotRodVersionUtils.isVersion2NewerThanVersion1(deployedSchemaVersion, currentSchemaVersion);
    }

    private void configureRemoteCaches(ConfigurationBuilder builder) {
        Consumer<String> configurator = this.configurationBuilderConsumer(builder);
        AutogeneratedHotRodDescriptors.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).distinct().forEach(configurator);
    }

    private static URI getCacheConfigUri(String cacheName) {
        try {
            return DefaultHotRodConnectionProviderFactory.class.getClassLoader().getResource("config/" + cacheName + "-cache-config.xml").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot read the cache configuration for cache + " + cacheName, e);
        }
    }

    private Consumer<String> configurationBuilderConsumer(ConfigurationBuilder builder) {
        return cacheName -> {
            LOG.debugf("Configuring cache %s", cacheName);
            builder.remoteCache(cacheName).configurationURI(DefaultHotRodConnectionProviderFactory.getCacheConfigUri(cacheName)).transactionMode(TransactionMode.FULL_XA).transactionManagerLookup(this.transactionManagerLookup).nearCacheMode(this.config.scope(new String[]{cacheName}).getBoolean("nearCacheEnabled", this.config.getBoolean("nearCacheEnabled", Boolean.valueOf(true))) != false ? NearCacheMode.INVALIDATED : NearCacheMode.DISABLED).nearCacheMaxEntries(this.config.scope(new String[]{cacheName}).getInt("nearCacheMaxEntries", this.config.getInt("nearCacheMaxEntries", Integer.valueOf(10000))).intValue()).nearCacheUseBloomFilter(this.config.scope(new String[]{cacheName}).getBoolean("nearCacheBloomFilter", this.config.getBoolean("nearCacheBloomFilter", Boolean.valueOf(false))).booleanValue());
        };
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

