/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.events;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.events.Event;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventStoreProviderFactory;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.events.MapAdminEventEntity;
import org.keycloak.models.map.events.MapAuthEventEntity;
import org.keycloak.models.map.events.MapEventStoreProvider;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;

public class MapEventStoreProviderFactory
implements AmphibianProviderFactory<EventStoreProvider>,
EnvironmentDependentProviderFactory,
EventStoreProviderFactory,
InvalidationHandler {
    public static final String PROVIDER_ID = "map";
    private Config.Scope storageConfigScopeAdminEvents;
    private Config.Scope storageConfigScopeLoginEvents;
    private final String uniqueKey = this.getClass().getName() + AbstractMapProviderFactory.uniqueCounter.incrementAndGet();

    public void init(Config.Scope config) {
        this.storageConfigScopeAdminEvents = config.scope(new String[]{"storage-admin-events"});
        this.storageConfigScopeLoginEvents = config.scope(new String[]{"storage-auth-events"});
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public EventStoreProvider create(KeycloakSession session) {
        MapEventStoreProvider provider = (MapEventStoreProvider)session.getAttribute(this.uniqueKey, MapEventStoreProvider.class);
        if (provider != null) {
            return provider;
        }
        MapStorageProvider factoryAe = (MapStorageProvider)AbstractMapProviderFactory.getProviderFactoryOrComponentFactory(session, this.storageConfigScopeAdminEvents).create(session);
        MapStorage<MapAdminEventEntity, AdminEvent> adminEventsStore = factoryAe.getStorage(AdminEvent.class, new MapStorageProviderFactory.Flag[0]);
        MapStorageProvider factoryLe = (MapStorageProvider)AbstractMapProviderFactory.getProviderFactoryOrComponentFactory(session, this.storageConfigScopeLoginEvents).create(session);
        MapStorage<MapAuthEventEntity, Event> loginEventsStore = factoryLe.getStorage(Event.class, new MapStorageProviderFactory.Flag[0]);
        provider = new MapEventStoreProvider(session, loginEventsStore, adminEventsStore);
        session.setAttribute(this.uniqueKey, (Object)provider);
        return provider;
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            this.create(session).clear((RealmModel)params[0]);
            this.create(session).clearAdmin((RealmModel)params[0]);
        }
    }

    public void close() {
        super.close();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Event provider";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

