/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.dom.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPMetadataDescriptor {
    public static EntityDescriptorType buildSPDescriptor(URI loginBinding, URI logoutBinding, URI assertionEndpoint, URI logoutEndpoint, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<KeyDescriptorType> signingCerts, List<KeyDescriptorType> encryptionCerts) {
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(entityId);
        entityDescriptor.setID(IDGenerator.create("ID_"));
        SPSSODescriptorType spSSODescriptor = new SPSSODescriptorType(Arrays.asList(JBossSAMLURIConstants.PROTOCOL_NSURI.get()));
        spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestsSigned));
        spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(wantAssertionsSigned));
        spSSODescriptor.addNameIDFormat(nameIDPolicyFormat);
        spSSODescriptor.addSingleLogoutService(new EndpointType(logoutBinding, logoutEndpoint));
        if (wantAuthnRequestsSigned && signingCerts != null) {
            for (KeyDescriptorType key : signingCerts) {
                spSSODescriptor.addKeyDescriptor(key);
            }
        }
        if (wantAssertionsEncrypted && encryptionCerts != null) {
            for (KeyDescriptorType key : encryptionCerts) {
                spSSODescriptor.addKeyDescriptor(key);
            }
        }
        IndexedEndpointType assertionConsumerEndpoint = new IndexedEndpointType(loginBinding, assertionEndpoint);
        assertionConsumerEndpoint.setIsDefault(Boolean.valueOf(true));
        assertionConsumerEndpoint.setIndex(1);
        spSSODescriptor.addAssertionConsumerService(assertionConsumerEndpoint);
        entityDescriptor.addChoiceType(new EntityDescriptorType.EDTChoiceType(Arrays.asList(new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spSSODescriptor))));
        return entityDescriptor;
    }

    public static KeyDescriptorType buildKeyDescriptorType(Element keyInfo, KeyTypes use, String algorithm) {
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        keyDescriptor.setUse(use);
        keyDescriptor.setKeyInfo(keyInfo);
        if (algorithm != null) {
            EncryptionMethodType encMethod = new EncryptionMethodType(algorithm);
            keyDescriptor.addEncryptionMethod(encMethod);
        }
        return keyDescriptor;
    }

    public static Element buildKeyInfoElement(String keyName, String pemEncodedCertificate) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element keyInfo = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyInfo");
        if (keyName != null) {
            Element keyNameElement = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyName");
            keyNameElement.setTextContent(keyName);
            keyInfo.appendChild(keyNameElement);
        }
        Element x509Data = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Data");
        Element x509Certificate = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Certificate");
        x509Certificate.setTextContent(pemEncodedCertificate);
        x509Data.appendChild(x509Certificate);
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }
}

