/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaRecordSettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PFILEPATH;

    public VmaRecordSettings(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaRecordSettings.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaRecordFlags")
    public int flags() {
        return VmaRecordSettings.nflags(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pFilePath() {
        return VmaRecordSettings.npFilePath(this.address());
    }

    @NativeType(value="char const *")
    public String pFilePathString() {
        return VmaRecordSettings.npFilePathString(this.address());
    }

    public VmaRecordSettings flags(@NativeType(value="VmaRecordFlags") int value) {
        VmaRecordSettings.nflags(this.address(), value);
        return this;
    }

    public VmaRecordSettings pFilePath(@NativeType(value="char const *") ByteBuffer value) {
        VmaRecordSettings.npFilePath(this.address(), value);
        return this;
    }

    public VmaRecordSettings set(int flags, ByteBuffer pFilePath) {
        this.flags(flags);
        this.pFilePath(pFilePath);
        return this;
    }

    public VmaRecordSettings set(VmaRecordSettings src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaRecordSettings malloc() {
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaRecordSettings calloc() {
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaRecordSettings create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaRecordSettings create(long address) {
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)address);
    }

    @Nullable
    public static VmaRecordSettings createSafe(long address) {
        return address == 0L ? null : (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaRecordSettings.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaRecordSettings.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaRecordSettings mallocStack() {
        return VmaRecordSettings.mallocStack(MemoryStack.stackGet());
    }

    public static VmaRecordSettings callocStack() {
        return VmaRecordSettings.callocStack(MemoryStack.stackGet());
    }

    public static VmaRecordSettings mallocStack(MemoryStack stack) {
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaRecordSettings callocStack(MemoryStack stack) {
        return (VmaRecordSettings)VmaRecordSettings.wrap(VmaRecordSettings.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaRecordSettings.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaRecordSettings.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VmaRecordSettings.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static ByteBuffer npFilePath(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PFILEPATH)));
    }

    public static String npFilePathString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)PFILEPATH)));
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npFilePath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PFILEPATH), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFILEPATH)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VmaRecordSettings.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VmaRecordSettings.__struct((Struct.Member[])new Struct.Member[]{VmaRecordSettings.__member((int)4), VmaRecordSettings.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PFILEPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaRecordSettings, Buffer>
    implements NativeResource {
        private static final VmaRecordSettings ELEMENT_FACTORY = VmaRecordSettings.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaRecordSettings getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaRecordFlags")
        public int flags() {
            return VmaRecordSettings.nflags(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pFilePath() {
            return VmaRecordSettings.npFilePath(this.address());
        }

        @NativeType(value="char const *")
        public String pFilePathString() {
            return VmaRecordSettings.npFilePathString(this.address());
        }

        public Buffer flags(@NativeType(value="VmaRecordFlags") int value) {
            VmaRecordSettings.nflags(this.address(), value);
            return this;
        }

        public Buffer pFilePath(@NativeType(value="char const *") ByteBuffer value) {
            VmaRecordSettings.npFilePath(this.address(), value);
            return this;
        }
    }
}

