/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUDA_MEMCPY3D_PEER;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CU40
extends CU {
    public static final long CU_LAUNCH_PARAM_END = 0L;
    public static final long CU_LAUNCH_PARAM_BUFFER_POINTER = 1L;
    public static final long CU_LAUNCH_PARAM_BUFFER_SIZE = 2L;
    public static final int CU_POINTER_ATTRIBUTE_CONTEXT = 1;
    public static final int CU_POINTER_ATTRIBUTE_MEMORY_TYPE = 2;
    public static final int CU_POINTER_ATTRIBUTE_DEVICE_POINTER = 3;
    public static final int CU_POINTER_ATTRIBUTE_HOST_POINTER = 4;
    public static final int CU_POINTER_ATTRIBUTE_P2P_TOKENS = 5;
    public static final int CU_POINTER_ATTRIBUTE_SYNC_MEMOPS = 6;
    public static final int CU_POINTER_ATTRIBUTE_BUFFER_ID = 7;
    public static final int CU_POINTER_ATTRIBUTE_IS_MANAGED = 8;
    public static final int CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL = 9;

    protected CU40() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="CUresult")
    public static int cuCtxDestroy(@NativeType(value="CUcontext") long ctx) {
        long __functionAddress = Functions.CtxDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return JNI.callPI((long)ctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxPushCurrent(@NativeType(value="CUcontext") long ctx) {
        long __functionAddress = Functions.CtxPushCurrent;
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return JNI.callPI((long)ctx, (long)__functionAddress);
    }

    public static int ncuCtxPopCurrent(long pctx) {
        long __functionAddress = Functions.CtxPopCurrent;
        return JNI.callPI((long)pctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxPopCurrent(@NativeType(value="CUcontext *") PointerBuffer pctx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU40.ncuCtxPopCurrent(MemoryUtil.memAddress((CustomBuffer)pctx));
    }

    @NativeType(value="CUresult")
    public static int cuCtxSetCurrent(@NativeType(value="CUcontext") long ctx) {
        long __functionAddress = Functions.CtxSetCurrent;
        return JNI.callPI((long)ctx, (long)__functionAddress);
    }

    public static int ncuCtxGetCurrent(long pctx) {
        long __functionAddress = Functions.CtxGetCurrent;
        return JNI.callPI((long)pctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetCurrent(@NativeType(value="CUcontext *") PointerBuffer pctx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU40.ncuCtxGetCurrent(MemoryUtil.memAddress((CustomBuffer)pctx));
    }

    public static int ncuMemHostRegister(long p, long bytesize, int Flags) {
        long __functionAddress = Functions.MemHostRegister;
        return JNI.callPPI((long)p, (long)bytesize, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemHostRegister(@NativeType(value="void *") ByteBuffer p, @NativeType(value="unsigned int") int Flags) {
        return CU40.ncuMemHostRegister(MemoryUtil.memAddress((ByteBuffer)p), p.remaining(), Flags);
    }

    public static int ncuMemHostUnregister(long p) {
        long __functionAddress = Functions.MemHostUnregister;
        return JNI.callPI((long)p, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemHostUnregister(@NativeType(value="void *") ByteBuffer p) {
        return CU40.ncuMemHostUnregister(MemoryUtil.memAddress((ByteBuffer)p));
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy(@NativeType(value="CUdeviceptr") long dst, @NativeType(value="CUdeviceptr") long src, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.Memcpy;
        if (Checks.CHECKS) {
            Checks.check((long)dst);
            Checks.check((long)src);
        }
        return JNI.callPPPI((long)dst, (long)src, (long)ByteCount, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyPeer(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="CUcontext") long dstContext, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUcontext") long srcContext, @NativeType(value="size_t") long ByteCount) {
        long __functionAddress = Functions.MemcpyPeer;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
            Checks.check((long)dstContext);
            Checks.check((long)srcDevice);
            Checks.check((long)srcContext);
        }
        return JNI.callPPPPPI((long)dstDevice, (long)dstContext, (long)srcDevice, (long)srcContext, (long)ByteCount, (long)__functionAddress);
    }

    public static int ncuMemcpy3DPeer(long pCopy) {
        long __functionAddress = Functions.Memcpy3DPeer;
        if (Checks.CHECKS) {
            CUDA_MEMCPY3D_PEER.validate(pCopy);
        }
        return JNI.callPI((long)pCopy, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy3DPeer(@NativeType(value="CUDA_MEMCPY3D_PEER const *") CUDA_MEMCPY3D_PEER pCopy) {
        return CU40.ncuMemcpy3DPeer(pCopy.address());
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyAsync(@NativeType(value="CUdeviceptr") long dst, @NativeType(value="CUdeviceptr") long src, @NativeType(value="size_t") long ByteCount, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemcpyAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dst);
            Checks.check((long)src);
        }
        return JNI.callPPPPI((long)dst, (long)src, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpyPeerAsync(@NativeType(value="CUdeviceptr") long dstDevice, @NativeType(value="CUcontext") long dstContext, @NativeType(value="CUdeviceptr") long srcDevice, @NativeType(value="CUcontext") long srcContext, @NativeType(value="size_t") long ByteCount, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemcpyPeerAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dstDevice);
            Checks.check((long)dstContext);
            Checks.check((long)srcDevice);
            Checks.check((long)srcContext);
        }
        return JNI.callPPPPPPI((long)dstDevice, (long)dstContext, (long)srcDevice, (long)srcContext, (long)ByteCount, (long)hStream, (long)__functionAddress);
    }

    public static int ncuMemcpy3DPeerAsync(long pCopy, long hStream) {
        long __functionAddress = Functions.Memcpy3DPeerAsync;
        if (Checks.CHECKS) {
            CUDA_MEMCPY3D_PEER.validate(pCopy);
        }
        return JNI.callPPI((long)pCopy, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemcpy3DPeerAsync(@NativeType(value="CUDA_MEMCPY3D_PEER const *") CUDA_MEMCPY3D_PEER pCopy, @NativeType(value="CUstream") long hStream) {
        return CU40.ncuMemcpy3DPeerAsync(pCopy.address(), hStream);
    }

    public static int ncuPointerGetAttribute(long data, int attribute, long ptr) {
        long __functionAddress = Functions.PointerGetAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        return JNI.callPPI((long)data, (int)attribute, (long)ptr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuPointerGetAttribute(@NativeType(value="void *") ByteBuffer data, @NativeType(value="CUpointer_attribute") int attribute, @NativeType(value="CUdeviceptr") long ptr) {
        return CU40.ncuPointerGetAttribute(MemoryUtil.memAddress((ByteBuffer)data), attribute, ptr);
    }

    @NativeType(value="CUresult")
    public static int cuStreamDestroy(@NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.StreamDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hStream);
        }
        return JNI.callPI((long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuEventDestroy(@NativeType(value="CUevent") long hEvent) {
        long __functionAddress = Functions.EventDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hEvent);
        }
        return JNI.callPI((long)hEvent, (long)__functionAddress);
    }

    public static int ncuLaunchKernel(long f, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, long hStream, long kernelParams, long extra) {
        long __functionAddress = Functions.LaunchKernel;
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return JNI.callPPPPI((long)f, (int)gridDimX, (int)gridDimY, (int)gridDimZ, (int)blockDimX, (int)blockDimY, (int)blockDimZ, (int)sharedMemBytes, (long)hStream, (long)kernelParams, (long)extra, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchKernel(@NativeType(value="CUfunction") long f, @NativeType(value="unsigned int") int gridDimX, @NativeType(value="unsigned int") int gridDimY, @NativeType(value="unsigned int") int gridDimZ, @NativeType(value="unsigned int") int blockDimX, @NativeType(value="unsigned int") int blockDimY, @NativeType(value="unsigned int") int blockDimZ, @NativeType(value="unsigned int") int sharedMemBytes, @NativeType(value="CUstream") long hStream, @Nullable @NativeType(value="void **") PointerBuffer kernelParams, @Nullable @NativeType(value="void **") PointerBuffer extra) {
        return CU40.ncuLaunchKernel(f, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, hStream, MemoryUtil.memAddressSafe((Pointer)kernelParams), MemoryUtil.memAddressSafe((Pointer)extra));
    }

    public static int ncuDeviceCanAccessPeer(long canAccessPeer, int dev, int peerDev) {
        long __functionAddress = Functions.DeviceCanAccessPeer;
        return JNI.callPI((long)canAccessPeer, (int)dev, (int)peerDev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceCanAccessPeer(@NativeType(value="int *") IntBuffer canAccessPeer, @NativeType(value="CUdevice") int dev, @NativeType(value="CUdevice") int peerDev) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)canAccessPeer, (int)1);
        }
        return CU40.ncuDeviceCanAccessPeer(MemoryUtil.memAddress((IntBuffer)canAccessPeer), dev, peerDev);
    }

    @NativeType(value="CUresult")
    public static int cuCtxEnablePeerAccess(@NativeType(value="CUcontext") long peerContext, @NativeType(value="unsigned int") int Flags) {
        long __functionAddress = Functions.CtxEnablePeerAccess;
        if (Checks.CHECKS) {
            Checks.check((long)peerContext);
        }
        return JNI.callPI((long)peerContext, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxDisablePeerAccess(@NativeType(value="CUcontext") long peerContext) {
        long __functionAddress = Functions.CtxDisablePeerAccess;
        if (Checks.CHECKS) {
            Checks.check((long)peerContext);
        }
        return JNI.callPI((long)peerContext, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long CtxDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuCtxDestroy", 2));
        public static final long CtxPushCurrent = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuCtxPushCurrent", 2));
        public static final long CtxPopCurrent = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuCtxPopCurrent", 2));
        public static final long CtxSetCurrent = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxSetCurrent");
        public static final long CtxGetCurrent = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxGetCurrent");
        public static final long MemHostRegister = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuMemHostRegister", 2));
        public static final long MemHostUnregister = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMemHostUnregister");
        public static final long Memcpy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTDS("cuMemcpy"));
        public static final long MemcpyPeer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTDS("cuMemcpyPeer"));
        public static final long Memcpy3DPeer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTDS("cuMemcpy3DPeer"));
        public static final long MemcpyAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuMemcpyAsync"));
        public static final long MemcpyPeerAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuMemcpyPeerAsync"));
        public static final long Memcpy3DPeerAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuMemcpy3DPeerAsync"));
        public static final long PointerGetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuPointerGetAttribute");
        public static final long StreamDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuStreamDestroy", 2));
        public static final long EventDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuEventDestroy", 2));
        public static final long LaunchKernel = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuLaunchKernel"));
        public static final long DeviceCanAccessPeer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDeviceCanAccessPeer");
        public static final long CtxEnablePeerAccess = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxEnablePeerAccess");
        public static final long CtxDisablePeerAccess = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxDisablePeerAccess");

        private Functions() {
        }
    }
}

