/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU70;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUstreamBatchMemOpParams;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU80
extends CU70 {
    public static final int CU_DEVICE_CPU = -1;
    public static final int CU_DEVICE_INVALID = -2;
    public static final int CU_STREAM_WAIT_VALUE_GEQ = 0;
    public static final int CU_STREAM_WAIT_VALUE_EQ = 1;
    public static final int CU_STREAM_WAIT_VALUE_AND = 2;
    public static final int CU_STREAM_WAIT_VALUE_NOR = 3;
    public static final int CU_STREAM_WAIT_VALUE_FLUSH = 0x40000000;
    public static final int CU_STREAM_WRITE_VALUE_DEFAULT = 0;
    public static final int CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER = 1;
    public static final int CU_STREAM_MEM_OP_WAIT_VALUE_32 = 1;
    public static final int CU_STREAM_MEM_OP_WRITE_VALUE_32 = 2;
    public static final int CU_STREAM_MEM_OP_WAIT_VALUE_64 = 4;
    public static final int CU_STREAM_MEM_OP_WRITE_VALUE_64 = 5;
    public static final int CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES = 3;
    public static final int CU_MEM_ADVISE_SET_READ_MOSTLY = 1;
    public static final int CU_MEM_ADVISE_UNSET_READ_MOSTLY = 2;
    public static final int CU_MEM_ADVISE_SET_PREFERRED_LOCATION = 3;
    public static final int CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION = 4;
    public static final int CU_MEM_ADVISE_SET_ACCESSED_BY = 5;
    public static final int CU_MEM_ADVISE_UNSET_ACCESSED_BY = 6;
    public static final int CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY = 1;
    public static final int CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = 2;
    public static final int CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY = 3;
    public static final int CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = 4;
    public static final int CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK = 1;
    public static final int CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED = 2;
    public static final int CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED = 3;
    public static final int CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED = 4;
    public static final int CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED = 4;

    protected CU80() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="CUresult")
    public static int cuMemPrefetchAsync(@NativeType(value="CUdeviceptr") long devPtr, @NativeType(value="size_t") long count, @NativeType(value="CUdevice") int dstDevice, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.MemPrefetchAsync;
        if (Checks.CHECKS) {
            Checks.check((long)devPtr);
        }
        return JNI.callPPPI((long)devPtr, (long)count, (int)dstDevice, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemAdvise(@NativeType(value="CUdeviceptr") long devPtr, @NativeType(value="size_t") long count, @NativeType(value="CUmem_advise") int advice, @NativeType(value="CUdevice") int device) {
        long __functionAddress = Functions.MemAdvise;
        if (Checks.CHECKS) {
            Checks.check((long)devPtr);
        }
        return JNI.callPPI((long)devPtr, (long)count, (int)advice, (int)device, (long)__functionAddress);
    }

    public static int ncuMemRangeGetAttribute(long data, long dataSize, int attribute, long devPtr, long count) {
        long __functionAddress = Functions.MemRangeGetAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)devPtr);
        }
        return JNI.callPPPPI((long)data, (long)dataSize, (int)attribute, (long)devPtr, (long)count, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemRangeGetAttribute(@NativeType(value="void *") ByteBuffer data, @NativeType(value="CUmem_range_attribute") int attribute, @NativeType(value="CUdeviceptr") long devPtr, @NativeType(value="size_t") long count) {
        return CU80.ncuMemRangeGetAttribute(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), attribute, devPtr, count);
    }

    public static int ncuMemRangeGetAttributes(long data, long dataSizes, long attributes, long numAttributes, long devPtr, long count) {
        long __functionAddress = Functions.MemRangeGetAttributes;
        if (Checks.CHECKS) {
            Checks.check((long)devPtr);
        }
        return JNI.callPPPPPPI((long)data, (long)dataSizes, (long)attributes, (long)numAttributes, (long)devPtr, (long)count, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemRangeGetAttributes(@NativeType(value="void **") PointerBuffer data, @NativeType(value="size_t *") PointerBuffer dataSizes, @NativeType(value="CUmem_range_attribute *") IntBuffer attributes, @NativeType(value="CUdeviceptr") long devPtr, @NativeType(value="size_t") long count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)data, (int)attributes.remaining());
            Checks.check((CustomBuffer)dataSizes, (int)attributes.remaining());
        }
        return CU80.ncuMemRangeGetAttributes(MemoryUtil.memAddress((CustomBuffer)data), MemoryUtil.memAddress((CustomBuffer)dataSizes), MemoryUtil.memAddress((IntBuffer)attributes), attributes.remaining(), devPtr, count);
    }

    @NativeType(value="CUresult")
    public static int cuStreamWaitValue32(@NativeType(value="CUstream") long stream, @NativeType(value="CUdeviceptr") long addr, @NativeType(value="cuuint32_t") int value, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.StreamWaitValue32;
        if (Checks.CHECKS) {
            Checks.check((long)addr);
        }
        return JNI.callPPI((long)stream, (long)addr, (int)value, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamWaitValue64(@NativeType(value="CUstream") long stream, @NativeType(value="CUdeviceptr") long addr, @NativeType(value="cuuint64_t") long value, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.StreamWaitValue64;
        if (Checks.CHECKS) {
            Checks.check((long)addr);
        }
        return JNI.callPPJI((long)stream, (long)addr, (long)value, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamWriteValue32(@NativeType(value="CUstream") long stream, @NativeType(value="CUdeviceptr") long addr, @NativeType(value="cuuint32_t") int value, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.StreamWriteValue32;
        if (Checks.CHECKS) {
            Checks.check((long)addr);
        }
        return JNI.callPPI((long)stream, (long)addr, (int)value, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamWriteValue64(@NativeType(value="CUstream") long stream, @NativeType(value="CUdeviceptr") long addr, @NativeType(value="cuuint64_t") long value, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.StreamWriteValue64;
        if (Checks.CHECKS) {
            Checks.check((long)addr);
        }
        return JNI.callPPJI((long)stream, (long)addr, (long)value, (int)flags, (long)__functionAddress);
    }

    public static int ncuStreamBatchMemOp(long stream, int count, long paramArray, int flags) {
        long __functionAddress = Functions.StreamBatchMemOp;
        return JNI.callPPI((long)stream, (int)count, (long)paramArray, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamBatchMemOp(@NativeType(value="CUstream") long stream, @NativeType(value="CUstreamBatchMemOpParams *") CUstreamBatchMemOpParams.Buffer paramArray, @NativeType(value="unsigned int") int flags) {
        return CU80.ncuStreamBatchMemOp(stream, paramArray.remaining(), paramArray.address(), flags);
    }

    public static int ncuDeviceGetP2PAttribute(long value, int attrib, int srcDevice, int dstDevice) {
        long __functionAddress = Functions.DeviceGetP2PAttribute;
        return JNI.callPI((long)value, (int)attrib, (int)srcDevice, (int)dstDevice, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetP2PAttribute(@NativeType(value="int *") IntBuffer value, @NativeType(value="CUdevice_P2PAttribute") int attrib, @NativeType(value="CUdevice") int srcDevice, @NativeType(value="CUdevice") int dstDevice) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return CU80.ncuDeviceGetP2PAttribute(MemoryUtil.memAddress((IntBuffer)value), attrib, srcDevice, dstDevice);
    }

    public static final class Functions {
        public static final long MemPrefetchAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuMemPrefetchAsync"));
        public static final long MemAdvise = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMemAdvise");
        public static final long MemRangeGetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMemRangeGetAttribute");
        public static final long MemRangeGetAttributes = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMemRangeGetAttributes");
        public static final long StreamWaitValue32 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamWaitValue32"));
        public static final long StreamWaitValue64 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamWaitValue64"));
        public static final long StreamWriteValue32 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamWriteValue32"));
        public static final long StreamWriteValue64 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamWriteValue64"));
        public static final long StreamBatchMemOp = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamBatchMemOp"));
        public static final long DeviceGetP2PAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDeviceGetP2PAttribute");

        private Functions() {
        }
    }
}

