/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU90;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUuuid;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU92
extends CU90 {
    protected CU92() {
        throw new UnsupportedOperationException();
    }

    public static int ncuDeviceGetUuid(long uuid, int dev) {
        long __functionAddress = Functions.DeviceGetUuid;
        return JNI.callPI((long)uuid, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetUuid(@NativeType(value="CUuuid *") CUuuid uuid, @NativeType(value="CUdevice") int dev) {
        return CU92.ncuDeviceGetUuid(uuid.address(), dev);
    }

    public static int ncuStreamGetCtx(long hStream, long pctx) {
        long __functionAddress = Functions.StreamGetCtx;
        if (Checks.CHECKS) {
            Checks.check((long)hStream);
        }
        return JNI.callPPI((long)hStream, (long)pctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamGetCtx(@NativeType(value="CUstream") long hStream, @NativeType(value="CUcontext *") PointerBuffer pctx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU92.ncuStreamGetCtx(hStream, MemoryUtil.memAddress((CustomBuffer)pctx));
    }

    public static final class Functions {
        public static final long DeviceGetUuid = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDeviceGetUuid");
        public static final long StreamGetCtx = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamGetCtx"));

        private Functions() {
        }
    }
}

