/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshKey")
public class AIMeshKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    public AIMeshKey(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMeshKey.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIMeshKey.nmTime(this.address());
    }

    @NativeType(value="unsigned int")
    public int mValue() {
        return AIMeshKey.nmValue(this.address());
    }

    public AIMeshKey mTime(double value) {
        AIMeshKey.nmTime(this.address(), value);
        return this;
    }

    public AIMeshKey mValue(@NativeType(value="unsigned int") int value) {
        AIMeshKey.nmValue(this.address(), value);
        return this;
    }

    public AIMeshKey set(double mTime, int mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIMeshKey set(AIMeshKey src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMeshKey malloc() {
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMeshKey calloc() {
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMeshKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMeshKey create(long address) {
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)address);
    }

    @Nullable
    public static AIMeshKey createSafe(long address) {
        return address == 0L ? null : (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMeshKey.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshKey.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMeshKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIMeshKey mallocStack() {
        return AIMeshKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey callocStack() {
        return AIMeshKey.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey mallocStack(MemoryStack stack) {
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshKey callocStack(MemoryStack stack) {
        return (AIMeshKey)AIMeshKey.wrap(AIMeshKey.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshKey.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static int nmValue(long struct) {
        return UNSAFE.getInt(null, struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MVALUE, value);
    }

    static {
        Struct.Layout layout = AIMeshKey.__struct((Struct.Member[])new Struct.Member[]{AIMeshKey.__member((int)8), AIMeshKey.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMeshKey, Buffer>
    implements NativeResource {
        private static final AIMeshKey ELEMENT_FACTORY = AIMeshKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMeshKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIMeshKey.nmTime(this.address());
        }

        @NativeType(value="unsigned int")
        public int mValue() {
            return AIMeshKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIMeshKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="unsigned int") int value) {
            AIMeshKey.nmValue(this.address(), value);
            return this;
        }
    }
}

