/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_u32_t")
public class LibDivideU32
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    public LibDivideU32(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LibDivideU32.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int magic() {
        return LibDivideU32.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideU32.nmore(this.address());
    }

    public LibDivideU32 magic(@NativeType(value="uint32_t") int value) {
        LibDivideU32.nmagic(this.address(), value);
        return this;
    }

    public LibDivideU32 more(@NativeType(value="uint8_t") byte value) {
        LibDivideU32.nmore(this.address(), value);
        return this;
    }

    public LibDivideU32 set(int magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideU32 set(LibDivideU32 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LibDivideU32 malloc() {
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LibDivideU32 calloc() {
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LibDivideU32 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LibDivideU32 create(long address) {
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)address);
    }

    @Nullable
    public static LibDivideU32 createSafe(long address) {
        return address == 0L ? null : (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LibDivideU32.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideU32.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LibDivideU32.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LibDivideU32 mallocStack() {
        return LibDivideU32.mallocStack(MemoryStack.stackGet());
    }

    public static LibDivideU32 callocStack() {
        return LibDivideU32.callocStack(MemoryStack.stackGet());
    }

    public static LibDivideU32 mallocStack(MemoryStack stack) {
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LibDivideU32 callocStack(MemoryStack stack) {
        return (LibDivideU32)LibDivideU32.wrap(LibDivideU32.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return LibDivideU32.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return LibDivideU32.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)LibDivideU32.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmagic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return UNSAFE.getByte(null, struct + (long)MORE);
    }

    public static void nmagic(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideU32.__struct((Struct.Member[])new Struct.Member[]{LibDivideU32.__member((int)4), LibDivideU32.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideU32, Buffer>
    implements NativeResource {
        private static final LibDivideU32 ELEMENT_FACTORY = LibDivideU32.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LibDivideU32 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int magic() {
            return LibDivideU32.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideU32.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="uint32_t") int value) {
            LibDivideU32.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideU32.nmore(this.address(), value);
            return this;
        }
    }
}

