/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_text")
public class NkStyleText
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int PADDING;

    public NkStyleText(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleText.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleText.ncolor(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleText.npadding(this.address());
    }

    public NkStyleText color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleText.ncolor(this.address(), value);
        return this;
    }

    public NkStyleText color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleText padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleText.npadding(this.address(), value);
        return this;
    }

    public NkStyleText padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleText set(NkColor color, NkVec2 padding) {
        this.color(color);
        this.padding(padding);
        return this;
    }

    public NkStyleText set(NkStyleText src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleText malloc() {
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStyleText calloc() {
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStyleText create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStyleText create(long address) {
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)address);
    }

    @Nullable
    public static NkStyleText createSafe(long address) {
        return address == 0L ? null : (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStyleText.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleText.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStyleText.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkStyleText mallocStack() {
        return NkStyleText.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleText callocStack() {
        return NkStyleText.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleText mallocStack(MemoryStack stack) {
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleText callocStack(MemoryStack stack) {
        return (NkStyleText)NkStyleText.wrap(NkStyleText.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleText.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleText.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleText.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)NkColor.SIZEOF);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleText.__struct((Struct.Member[])new Struct.Member[]{NkStyleText.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleText.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        PADDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleText, Buffer>
    implements NativeResource {
        private static final NkStyleText ELEMENT_FACTORY = NkStyleText.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleText getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleText.ncolor(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleText.npadding(this.address());
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleText.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleText.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }
    }
}

