/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.meshoptimizer.LibMeshOptimizer;
import org.lwjgl.util.meshoptimizer.MeshoptAllocateI;
import org.lwjgl.util.meshoptimizer.MeshoptBounds;
import org.lwjgl.util.meshoptimizer.MeshoptDeallocateI;
import org.lwjgl.util.meshoptimizer.MeshoptMeshlet;
import org.lwjgl.util.meshoptimizer.MeshoptOverdrawStatistics;
import org.lwjgl.util.meshoptimizer.MeshoptStream;
import org.lwjgl.util.meshoptimizer.MeshoptVertexCacheStatistics;
import org.lwjgl.util.meshoptimizer.MeshoptVertexFetchStatistics;

public class MeshOptimizer {
    public static final int MESHOPTIMIZER_VERSION = 130;

    protected MeshOptimizer() {
        throw new UnsupportedOperationException();
    }

    public static native long nmeshopt_generateVertexRemap(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_generateVertexRemap(@NativeType(value="unsigned int *") IntBuffer destination, @Nullable @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long index_count, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_size) {
        long vertex_count = destination.remaining();
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)indices, (long)index_count);
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_generateVertexRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), index_count, MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    public static native long nmeshopt_generateVertexRemapMulti(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_generateVertexRemapMulti(@NativeType(value="unsigned int *") IntBuffer destination, @Nullable @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long index_count, @NativeType(value="struct meshopt_Stream const *") MeshoptStream.Buffer streams) {
        long vertex_count = destination.remaining();
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)indices, (long)index_count);
            MeshoptStream.validate(streams.address(), streams.remaining());
        }
        return MeshOptimizer.nmeshopt_generateVertexRemapMulti(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), index_count, vertex_count, streams.address(), streams.remaining());
    }

    public static native void nmeshopt_remapVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static void meshopt_remapVertexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_size, @NativeType(value="unsigned int const *") IntBuffer remap) {
        long vertex_count = remap.remaining();
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        MeshOptimizer.nmeshopt_remapVertexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size, MemoryUtil.memAddress((IntBuffer)remap));
    }

    public static native void nmeshopt_remapIndexBuffer(long var0, long var2, long var4, long var6);

    public static void meshopt_remapIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @Nullable @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="unsigned int const *") IntBuffer remap) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)indices, (int)destination.remaining());
        }
        MeshOptimizer.nmeshopt_remapIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), destination.remaining(), MemoryUtil.memAddress((IntBuffer)remap));
    }

    public static native void nmeshopt_generateShadowIndexBuffer(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void meshopt_generateShadowIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="size_t") long vertex_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_stride));
        }
        MeshOptimizer.nmeshopt_generateShadowIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size, vertex_stride);
    }

    public static native void nmeshopt_generateShadowIndexBufferMulti(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_generateShadowIndexBufferMulti(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="struct meshopt_Stream const *") MeshoptStream.Buffer streams) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
            MeshoptStream.validate(streams.address(), streams.remaining());
        }
        MeshOptimizer.nmeshopt_generateShadowIndexBufferMulti(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), vertex_count, streams.address(), streams.remaining());
    }

    public static native void nmeshopt_optimizeVertexCache(long var0, long var2, long var4, long var6);

    public static void meshopt_optimizeVertexCache(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
        }
        MeshOptimizer.nmeshopt_optimizeVertexCache(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), vertex_count);
    }

    public static native void nmeshopt_optimizeVertexCacheFifo(long var0, long var2, long var4, long var6, int var8);

    public static void meshopt_optimizeVertexCacheFifo(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int cache_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
        }
        MeshOptimizer.nmeshopt_optimizeVertexCacheFifo(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), vertex_count, cache_size);
    }

    public static native void nmeshopt_optimizeOverdraw(long var0, long var2, long var4, long var6, long var8, long var10, float var12);

    public static void meshopt_optimizeOverdraw(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, float threshold) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_optimizeOverdraw(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, threshold);
    }

    public static native long nmeshopt_optimizeVertexFetch(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_optimizeVertexFetch(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="unsigned int *") IntBuffer indices, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(vertex_count * vertex_size));
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_optimizeVertexFetch(MemoryUtil.memAddress((ByteBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    public static native long nmeshopt_optimizeVertexFetchRemap(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long meshopt_optimizeVertexFetchRemap(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices) {
        return MeshOptimizer.nmeshopt_optimizeVertexFetchRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), destination.remaining());
    }

    public static native long nmeshopt_encodeIndexBuffer(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long meshopt_encodeIndexBuffer(@NativeType(value="unsigned char *") ByteBuffer buffer, @NativeType(value="unsigned int const *") IntBuffer indices) {
        return MeshOptimizer.nmeshopt_encodeIndexBuffer(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining());
    }

    @NativeType(value="size_t")
    public static native long meshopt_encodeIndexBufferBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2);

    public static native int nmeshopt_decodeIndexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static int meshopt_decodeIndexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long index_count, @NativeType(value="size_t") long index_size, @NativeType(value="unsigned char const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(index_count * index_size));
        }
        return MeshOptimizer.nmeshopt_decodeIndexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), index_count, index_size, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native long nmeshopt_encodeVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long meshopt_encodeVertexBuffer(@NativeType(value="unsigned char *") ByteBuffer buffer, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_encodeVertexBuffer(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    @NativeType(value="size_t")
    public static native long meshopt_encodeVertexBufferBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2);

    public static native int nmeshopt_decodeVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static int meshopt_decodeVertexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="unsigned char const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_decodeVertexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), vertex_count, vertex_size, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native long nmeshopt_simplify(long var0, long var2, long var4, long var6, long var8, long var10, long var12, float var14);

    @NativeType(value="size_t")
    public static long meshopt_simplify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long target_index_count, float target_error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        return MeshOptimizer.nmeshopt_simplify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, target_index_count, target_error);
    }

    public static native long nmeshopt_simplifySloppy(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long meshopt_simplifySloppy(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long target_index_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)target_index_count);
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        return MeshOptimizer.nmeshopt_simplifySloppy(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, target_index_count);
    }

    public static native long nmeshopt_simplifyPoints(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long meshopt_simplifyPoints(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long target_vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)target_vertex_count);
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        return MeshOptimizer.nmeshopt_simplifyPoints(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, target_vertex_count);
    }

    public static native long nmeshopt_stripify(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long meshopt_stripify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int restart_index) {
        return MeshOptimizer.nmeshopt_stripify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, restart_index);
    }

    @NativeType(value="size_t")
    public static native long meshopt_stripifyBound(@NativeType(value="size_t") long var0);

    public static native long nmeshopt_unstripify(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long meshopt_unstripify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="unsigned int") int restart_index) {
        return MeshOptimizer.nmeshopt_unstripify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), restart_index);
    }

    @NativeType(value="size_t")
    public static native long meshopt_unstripifyBound(@NativeType(value="size_t") long var0);

    public static native void nmeshopt_analyzeVertexCache(long var0, long var2, long var4, int var6, int var7, int var8, long var9);

    @NativeType(value="struct meshopt_VertexCacheStatistics")
    public static MeshoptVertexCacheStatistics meshopt_analyzeVertexCache(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int cache_size, @NativeType(value="unsigned int") int warp_size, @NativeType(value="unsigned int") int primgroup_size, @NativeType(value="struct meshopt_VertexCacheStatistics") MeshoptVertexCacheStatistics __result) {
        MeshOptimizer.nmeshopt_analyzeVertexCache(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, cache_size, warp_size, primgroup_size, __result.address());
        return __result;
    }

    public static native void nmeshopt_analyzeOverdraw(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="struct meshopt_OverdrawStatistics")
    public static MeshoptOverdrawStatistics meshopt_analyzeOverdraw(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_OverdrawStatistics") MeshoptOverdrawStatistics __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        MeshOptimizer.nmeshopt_analyzeOverdraw(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_analyzeVertexFetch(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="struct meshopt_VertexFetchStatistics")
    public static MeshoptVertexFetchStatistics meshopt_analyzeVertexFetch(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="struct meshopt_VertexFetchStatistics") MeshoptVertexFetchStatistics __result) {
        MeshOptimizer.nmeshopt_analyzeVertexFetch(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, vertex_size, __result.address());
        return __result;
    }

    public static native long nmeshopt_buildMeshlets(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_buildMeshlets(@NativeType(value="struct meshopt_Meshlet *") MeshoptMeshlet.Buffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long max_vertices, @NativeType(value="size_t") long max_triangles) {
        return MeshOptimizer.nmeshopt_buildMeshlets(destination.address(), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, max_vertices, max_triangles);
    }

    @NativeType(value="size_t")
    public static native long meshopt_buildMeshletsBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2, @NativeType(value="size_t") long var4);

    public static native void nmeshopt_computeClusterBounds(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="struct meshopt_Bounds")
    public static MeshoptBounds meshopt_computeClusterBounds(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_Bounds") MeshoptBounds __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        MeshOptimizer.nmeshopt_computeClusterBounds(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_computeMeshletBounds(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="struct meshopt_Bounds")
    public static MeshoptBounds meshopt_computeMeshletBounds(@NativeType(value="struct meshopt_Meshlet const *") MeshoptMeshlet meshlet, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_Bounds") MeshoptBounds __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        MeshOptimizer.nmeshopt_computeMeshletBounds(meshlet.address(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_spatialSortRemap(long var0, long var2, long var4, long var6);

    public static void meshopt_spatialSortRemap(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_positions_stride) {
        long vertex_count = destination.remaining();
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        MeshOptimizer.nmeshopt_spatialSortRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native void nmeshopt_spatialSortTriangles(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_spatialSortTriangles(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)destination.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * vertex_positions_stride));
        }
        MeshOptimizer.nmeshopt_spatialSortTriangles(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), destination.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native void nmeshopt_setAllocator(long var0, long var2);

    public static void meshopt_setAllocator(@NativeType(value="void * (*) (size_t)") MeshoptAllocateI allocate, @NativeType(value="void (*) (void *)") MeshoptDeallocateI deallocate) {
        MeshOptimizer.nmeshopt_setAllocator(allocate.address(), deallocate.address());
    }

    public static int meshopt_quantizeUnorm(float v, int N) {
        float scale = (1 << N) - 1;
        v = v >= 0.0f ? v : 0.0f;
        v = v <= 1.0f ? v : 1.0f;
        return (int)(v * scale + 0.5f);
    }

    public static int meshopt_quantizeSnorm(float v, int N) {
        float scale = (1 << N - 1) - 1;
        float round = v >= 0.0f ? 0.5f : -0.5f;
        v = v >= -1.0f ? v : -1.0f;
        v = v <= 1.0f ? v : 1.0f;
        return (int)(v * scale + round);
    }

    public static short meshopt_quantizeHalf(float v) {
        int ui = Float.floatToRawIntBits(v);
        int s = ui >>> 16 & 0x8000;
        int em = ui & Integer.MAX_VALUE;
        int h = em - 0x38000000 + 4096 >> 13;
        h = em < 0x38800000 ? 0 : h;
        h = em >= 1199570944 ? 31744 : h;
        h = em > 2139095040 ? 32256 : h;
        return (short)(s | h);
    }

    public static float meshopt_quantizeFloat(float v, int N) {
        int ui = Float.floatToRawIntBits(v);
        int mask = (1 << 23 - N) - 1;
        int round = 1 << 23 - N >> 1;
        int e = ui & 0x7F800000;
        int rui = ui + round & ~mask;
        ui = e == 2139095040 ? ui : rui;
        ui = e == 0 ? 0 : ui;
        return Float.intBitsToFloat(ui);
    }

    static {
        LibMeshOptimizer.initialize();
    }
}

