/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMError {
    public static final int LLVMErrorSuccess = 0;

    protected LLVMError() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetErrorTypeId(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.GetErrorTypeId;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        return JNI.invokePP((long)Err, (long)__functionAddress);
    }

    public static void LLVMConsumeError(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.ConsumeError;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        JNI.invokePV((long)Err, (long)__functionAddress);
    }

    public static long nLLVMGetErrorMessage(long Err) {
        long __functionAddress = Functions.GetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        return JNI.invokePP((long)Err, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer LLVMGetErrorMessage(@NativeType(value="LLVMErrorRef") long Err) {
        long __result = LLVMError.nLLVMGetErrorMessage(Err);
        return MemoryUtil.memByteBufferNT1Safe((long)__result);
    }

    public static void nLLVMDisposeErrorMessage(long ErrMsg) {
        long __functionAddress = Functions.DisposeErrorMessage;
        JNI.invokePV((long)ErrMsg, (long)__functionAddress);
    }

    public static void LLVMDisposeErrorMessage(@NativeType(value="char *") ByteBuffer ErrMsg) {
        LLVMError.nLLVMDisposeErrorMessage(MemoryUtil.memAddress((ByteBuffer)ErrMsg));
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetStringErrorTypeId() {
        long __functionAddress = Functions.GetStringErrorTypeId;
        return JNI.invokeP((long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetErrorTypeId = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetErrorTypeId");
        public static final long ConsumeError = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMConsumeError");
        public static final long GetErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetErrorMessage");
        public static final long DisposeErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeErrorMessage");
        public static final long GetStringErrorTypeId = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetStringErrorTypeId");

        private Functions() {
        }
    }
}

