/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    public VkExternalMemoryBufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExternalMemoryBufferCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(VkExternalMemoryBufferCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfo malloc() {
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo calloc() {
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExternalMemoryBufferCreateInfo create(long address) {
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExternalMemoryBufferCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryBufferCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkExternalMemoryBufferCreateInfo mallocStack() {
        return VkExternalMemoryBufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfo callocStack() {
        return VkExternalMemoryBufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfo mallocStack(MemoryStack stack) {
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo callocStack(MemoryStack stack) {
        return (VkExternalMemoryBufferCreateInfo)VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryBufferCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkExternalMemoryBufferCreateInfo.__member((int)4), VkExternalMemoryBufferCreateInfo.__member((int)POINTER_SIZE), VkExternalMemoryBufferCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryBufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkExternalMemoryBufferCreateInfo ELEMENT_FACTORY = VkExternalMemoryBufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExternalMemoryBufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

