/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceSubgroupProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBGROUPSIZE;
    public static final int SUPPORTEDSTAGES;
    public static final int SUPPORTEDOPERATIONS;
    public static final int QUADOPERATIONSINALLSTAGES;

    public VkPhysicalDeviceSubgroupProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceSubgroupProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int subgroupSize() {
        return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int supportedStages() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
    }

    @NativeType(value="VkSubgroupFeatureFlags")
    public int supportedOperations() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean quadOperationsInAllStages() {
        return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
    }

    public VkPhysicalDeviceSubgroupProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(VkPhysicalDeviceSubgroupProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceSubgroupProperties malloc() {
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceSubgroupProperties calloc() {
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceSubgroupProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceSubgroupProperties create(long address) {
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceSubgroupProperties createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceSubgroupProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceSubgroupProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceSubgroupProperties mallocStack() {
        return VkPhysicalDeviceSubgroupProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceSubgroupProperties callocStack() {
        return VkPhysicalDeviceSubgroupProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceSubgroupProperties mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceSubgroupProperties callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceSubgroupProperties)VkPhysicalDeviceSubgroupProperties.wrap(VkPhysicalDeviceSubgroupProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceSubgroupProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceSubgroupProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceSubgroupProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsubgroupSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPSIZE);
    }

    public static int nsupportedStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDSTAGES);
    }

    public static int nsupportedOperations(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDOPERATIONS);
    }

    public static int nquadOperationsInAllStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUADOPERATIONSINALLSTAGES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSubgroupProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceSubgroupProperties.__member((int)4), VkPhysicalDeviceSubgroupProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceSubgroupProperties.__member((int)4), VkPhysicalDeviceSubgroupProperties.__member((int)4), VkPhysicalDeviceSubgroupProperties.__member((int)4), VkPhysicalDeviceSubgroupProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBGROUPSIZE = layout.offsetof(2);
        SUPPORTEDSTAGES = layout.offsetof(3);
        SUPPORTEDOPERATIONS = layout.offsetof(4);
        QUADOPERATIONSINALLSTAGES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceSubgroupProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceSubgroupProperties ELEMENT_FACTORY = VkPhysicalDeviceSubgroupProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceSubgroupProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int subgroupSize() {
            return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int supportedStages() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
        }

        @NativeType(value="VkSubgroupFeatureFlags")
        public int supportedOperations() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean quadOperationsInAllStages() {
            return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
            return this;
        }
    }
}

