/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.ClassTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonTestUtilProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class TestClassGenerator
extends CodeActionsProvider {
    private static final String GENERATE_TEST_CLASS_COMMAND = "java.generate.testClass";
    private final Set<String> commands = Collections.singleton("java.generate.testClass");

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = TestClassGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            return Collections.emptyList();
        }
        ClassTree cls = (ClassTree)tp.getLeaf();
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        int startPos = (int)sourcePositions.getStartPosition(tp.getCompilationUnit(), cls);
        String code = info.getText();
        if (startPos < 0 || offset < 0 || offset < startPos || offset >= code.length()) {
            return Collections.emptyList();
        }
        String headerText = code.substring(startPos, offset);
        int idx = headerText.indexOf(123);
        if (idx >= 0) {
            return Collections.emptyList();
        }
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject fileObject = info.getFileObject();
        if (!fileObject.isValid()) {
            return Collections.emptyList();
        }
        FileObject root = cp.findOwnerRoot(fileObject);
        if (root == null) {
            return Collections.emptyList();
        }
        Map<Object, List<String>> validCombinations = TestClassGenerator.getValidCombinations((CompilationInfo)info);
        if (validCombinations == null || validCombinations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        for (Map.Entry<Object, List<String>> entrySet : validCombinations.entrySet()) {
            Object location = entrySet.getKey();
            for (String testingFramework : entrySet.getValue()) {
                result.add(this.createCodeAction(Bundle.DN_GenerateTestClass(testingFramework, TestClassGenerator.getLocationText(location)), "refactor", null, GENERATE_TEST_CLASS_COMMAND, Utils.toUri(fileObject), testingFramework, Utils.toUri(TestClassGenerator.getTargetFolder(location))));
            }
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Object> processCommand(final NbCodeLanguageClient client, String command, List<Object> arguments) {
        block9: {
            try {
                if (arguments.size() > 2) {
                    String uri = ((JsonPrimitive)arguments.get(0)).getAsString();
                    FileObject fileObject = Utils.fromUri(uri);
                    if (fileObject == null) {
                        throw new IllegalArgumentException(String.format("Cannot resolve source file from uri: %s", uri));
                    }
                    String testingFramework = ((JsonPrimitive)arguments.get(1)).getAsString();
                    String targetUri = ((JsonPrimitive)arguments.get(2)).getAsString();
                    FileObject targetFolder = Utils.fromUri(targetUri);
                    if (targetFolder == null) {
                        throw new IllegalArgumentException(String.format("Cannot resolve target folder from uri: %s", targetUri));
                    }
                    Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
                    for (Lookup.Item provider : providers) {
                        if (!provider.getDisplayName().equals(testingFramework)) continue;
                        TestCreatorProvider.Context context = new TestCreatorProvider.Context(new FileObject[]{fileObject});
                        context.setSingleClass(true);
                        context.setTargetFolder(targetFolder);
                        context.setTestClassName(TestClassGenerator.getPreffiledName(fileObject, testingFramework));
                        FileChangeAdapter fcl = new FileChangeAdapter(){

                            public void fileDataCreated(FileEvent fe) {
                                RequestProcessor.getDefault().post(() -> client.showDocument(new ShowDocumentParams(Utils.toUri(fe.getFile()))), 1000);
                            }
                        };
                        targetFolder.addRecursiveListener((FileChangeListener)fcl);
                        try {
                            ((TestCreatorProvider)provider.getInstance()).createTests(context);
                        }
                        finally {
                            RequestProcessor.getDefault().post(() -> TestClassGenerator.lambda$processCommand$0(targetFolder, (FileChangeListener)fcl), 1000);
                        }
                    }
                    break block9;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (JsonSyntaxException | IllegalArgumentException | MalformedURLException ex) {
                client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    private static String getLocationText(Object location) {
        String text = location instanceof SourceGroup ? ((SourceGroup)location).getDisplayName() : (location instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)location)) : location.toString());
        return text;
    }

    private static Map<Object, List<String>> getValidCombinations(CompilationInfo info) {
        List<String> testingFrameworks = TestClassGenerator.getTestingFrameworks(info.getFileObject());
        if (testingFrameworks.isEmpty()) {
            return null;
        }
        HashMap<Object, List<String>> validCombinations = new HashMap<Object, List<String>>();
        for (Object location : TestClassGenerator.getLocations(info.getFileObject())) {
            String targetFolderPath = TestClassGenerator.getTargetFolderPath(location);
            ArrayList<String> framework2Add = new ArrayList<String>();
            for (String framework : testingFrameworks) {
                String preffiledName = TestClassGenerator.getPreffiledName(info.getFileObject(), framework);
                preffiledName = preffiledName.replace('.', File.separatorChar).concat(".java");
                String path = targetFolderPath.concat(File.separator).concat(preffiledName);
                File f = new File(path);
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo != null) continue;
                framework2Add.add(framework);
            }
            if (framework2Add.isEmpty()) continue;
            validCombinations.put(location, framework2Add);
        }
        return validCombinations;
    }

    private static List<String> getTestingFrameworks(FileObject fileObject) {
        ArrayList<String> testingFrameworks = new ArrayList<String>();
        Collection testCreatorProviders = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : testCreatorProviders) {
            if (!((TestCreatorProvider)provider.getInstance()).enable(new FileObject[]{fileObject})) continue;
            testingFrameworks.add(provider.getDisplayName());
        }
        return testingFrameworks;
    }

    private static Object[] getLocations(FileObject activeFO) {
        SourceGroup sourceGroupOwner;
        Object[] locations = null;
        Collection testUtilProviders = Lookup.getDefault().lookupAll(CommonTestUtilProvider.class);
        Iterator iterator = testUtilProviders.iterator();
        if (iterator.hasNext()) {
            CommonTestUtilProvider provider = (CommonTestUtilProvider)iterator.next();
            locations = provider.getTestTargets(activeFO);
        }
        if (locations != null && locations.length == 0 && (sourceGroupOwner = TestClassGenerator.findSourceGroupOwner(activeFO)) != null) {
            locations = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroupOwner.getRootFolder());
        }
        return locations != null ? locations : new Object[]{};
    }

    private static String getPreffiledName(FileObject fileObj, String selectedFramework) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        String className = cp.getResourceName(fileObj, '.', false);
        return className + TestClassGenerator.getTestingFrameworkSuffix(selectedFramework) + "Test";
    }

    private static String getTestingFrameworkSuffix(String selectedFramework) {
        if (selectedFramework == null) {
            return "";
        }
        String testngFramework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            testngFramework = provider.getTestngFramework();
        }
        return selectedFramework.equals(testngFramework) ? "NG" : "";
    }

    private static FileObject getTargetFolder(Object selectedLocation) {
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder();
        }
        if (selectedLocation instanceof URL) {
            return URLMapper.findFileObject((URL)((URL)selectedLocation));
        }
        assert (selectedLocation instanceof FileObject);
        return (FileObject)selectedLocation;
    }

    private static String getTargetFolderPath(Object selectedLocation) {
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder().getPath();
        }
        if (selectedLocation instanceof URL) {
            return ((URL)selectedLocation).getPath();
        }
        assert (selectedLocation instanceof FileObject);
        return ((FileObject)selectedLocation).getPath();
    }

    private static SourceGroup findSourceGroupOwner(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null) {
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup srcGroup = sourceGroups[i];
                FileObject root = srcGroup.getRootFolder();
                if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
                return srcGroup;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$processCommand$0(FileObject targetFolder, FileChangeListener fcl) {
        targetFolder.removeRecursiveListener(fcl);
    }
}

