/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.EntityClassesPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MicronautRepository
implements TemplateWizard.Iterator {
    static final String PROP_ENTITIES = "wizard-entities";
    static final String PROP_SELECTED_ENTITIES = "wizard-selected-entities";
    private WizardDescriptor.Panel panel;
    private WizardDescriptor wizardDescriptor;
    private FileObject targetFolder;
    private boolean jpaSupported;

    public static TemplateWizard.Iterator create() {
        return new MicronautRepository();
    }

    public static CreateFromTemplateHandler handler() {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                try {
                    FileObject folder = desc.getTarget();
                    Project project = FileOwnerQuery.getOwner((FileObject)folder);
                    if (project == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoProject(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)folder);
                    if (sourceGroup == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoSourceGroup(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    boolean jpaSupported = Utils.isJPASupported(sourceGroup);
                    Map<String, String> entity2idTypes = MicronautRepository.getEntityClasses(sourceGroup, jpaSupported);
                    ArrayList<NotifyDescriptor.QuickPick.Item> entities = new ArrayList<NotifyDescriptor.QuickPick.Item>();
                    for (String entityFQN : entity2idTypes.keySet()) {
                        int idx = entityFQN.lastIndexOf(46);
                        if (idx < 0) {
                            entities.add(new NotifyDescriptor.QuickPick.Item(entityFQN, null));
                            continue;
                        }
                        entities.add(new NotifyDescriptor.QuickPick.Item(entityFQN.substring(idx + 1), entityFQN.substring(0, idx)));
                    }
                    if (entities.isEmpty()) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoEntities(sourceGroup.getRootFolder().getPath()), 0));
                        return Collections.emptyList();
                    }
                    NotifyDescriptor.QuickPick qp = new NotifyDescriptor.QuickPick(Bundle.MSG_SelectEntities(), Bundle.MSG_SelectEntities(), entities, true);
                    if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)qp)) {
                        String dialect = MicronautRepository.getDialect(jpaSupported);
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        for (NotifyDescriptor.QuickPick.Item item : qp.getItems()) {
                            if (!item.isSelected()) continue;
                            String fqn = item.getDescription() != null ? item.getDescription() + '.' + item.getLabel() : item.getLabel();
                            String entityIdType = entity2idTypes.get(fqn);
                            FileObject fo = MicronautRepository.generate(folder, item.getLabel(), fqn, entityIdType, dialect);
                            if (fo == null) continue;
                            generated.add(fo);
                        }
                        return generated;
                    }
                }
                catch (Exception ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                return Collections.emptyList();
            }
        };
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        String dialect = MicronautRepository.getDialect(this.jpaSupported);
        HashSet<DataObject> generated = new HashSet<DataObject>();
        Map selectedEntities = (Map)wiz.getProperty(PROP_SELECTED_ENTITIES);
        for (Map.Entry entry : selectedEntities.entrySet()) {
            String fqn = (String)entry.getKey();
            int idx = fqn.lastIndexOf(46);
            String label = idx < 0 ? fqn : fqn.substring(idx + 1);
            FileObject fo = MicronautRepository.generate(this.targetFolder, label, fqn, (String)entry.getValue(), dialect);
            if (fo == null) continue;
            generated.add(DataObject.find((FileObject)fo));
        }
        return generated;
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.panel = new EntityClassesPanel.WizardPanel(NbBundle.getMessage(MicronautRepository.class, (String)"Templates/Micronaut/Repository"));
        Wizards.mergeSteps((WizardDescriptor)this.wizardDescriptor, (WizardDescriptor.Panel[])new WizardDescriptor.Panel[]{this.panel}, (String[])new String[]{NbBundle.getMessage(MicronautRepository.class, (String)"LBL_EntityClasses")});
        this.targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        Project project = Templates.getProject((WizardDescriptor)wiz);
        SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)this.targetFolder);
        if (sourceGroup != null) {
            this.jpaSupported = Utils.isJPASupported(sourceGroup);
            Map<String, String> entities = MicronautRepository.getEntityClasses(sourceGroup, this.jpaSupported);
            wiz.putProperty(PROP_ENTITIES, entities);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    static Map<String, String> getEntityClasses(SourceGroup sg, boolean jpaSupported) {
        HashMap<String, String> entities = new HashMap<String, String>();
        JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sg.getRootFolder()), (FileObject[])new FileObject[0]);
        if (js != null) {
            try {
                js.runWhenScanFinished(cc -> {
                    TypeElement typeElement = cc.getElements().getTypeElement(jpaSupported ? "javax.persistence.Entity" : "io.micronaut.data.annotation.MappedEntity");
                    if (typeElement != null) {
                        TypeElement idTypeElement = cc.getElements().getTypeElement(jpaSupported ? "javax.persistence.Id" : "io.micronaut.data.annotation.Id");
                        Set elementHandles = cc.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                        for (ElementHandle elementHandle : elementHandles) {
                            TypeElement type = (TypeElement)elementHandle.resolve((CompilationInfo)cc);
                            if (type == null) continue;
                            String fqn = null;
                            String idType = null;
                            for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
                                if (fqn != null || typeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                fqn = type.getQualifiedName().toString();
                            }
                            if (fqn == null) continue;
                            if (idTypeElement != null) {
                                for (VariableElement variableElement : ElementFilter.fieldsIn(type.getEnclosedElements())) {
                                    if (idType != null) continue;
                                    for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                                        if (idType != null || idTypeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                        idType = cc.getTypeUtilities().getTypeName(variableElement.asType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString();
                                    }
                                }
                            }
                            if (idType == null) {
                                idType = "java.lang.Object";
                            }
                            entities.put(fqn, idType);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return entities;
    }

    private static String getDialect(boolean jpaSupported) {
        if (!jpaSupported) {
            DatabaseConnection connection = ConnectionManager.getDefault().getPreferredConnection(true);
            if (connection != null) {
                try {
                    ConnectionManager.getDefault().connect(connection);
                    Connection conn = connection.getJDBCConnection();
                    String name = conn.getMetaData().getDatabaseProductName();
                    if (name.matches("(?i).*h2.*")) {
                        return "H2";
                    }
                    if (name.matches("(?i).*mysql.*")) {
                        return "MYSQL";
                    }
                    if (name.matches("(?i).*oracle.*")) {
                        return "ORACLE";
                    }
                    if (name.matches("(?i).*postgresql.*")) {
                        return "POSTGRES";
                    }
                    if (name.matches("(?i).*microsoft.*")) {
                        return "SQL_SERVER";
                    }
                }
                catch (SQLException | DatabaseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return "";
        }
        return null;
    }

    private static FileObject generate(FileObject folder, String entityName, String entityFQN, String entityIdType, String dialect) {
        try {
            JavaSource js;
            String name = entityName + "Repository";
            FileObject fo = GenerationUtils.createInterface((FileObject)folder, (String)name, (String)Bundle.MSG_Repository_Interface(name));
            if (fo != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                js.runModificationTask(copy -> {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    Tree origTree = copy.getCompilationUnit().getTypeDecls().get(0);
                    if (origTree.getKind() == Tree.Kind.INTERFACE) {
                        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
                        TreeMaker tm = copy.getTreeMaker();
                        List<ExpressionTree> args = Arrays.asList(tm.QualIdent(entityFQN), tm.QualIdent(entityIdType));
                        ParameterizedTypeTree type = tm.ParameterizedType((Tree)tm.QualIdent("io.micronaut.data.repository.CrudRepository"), args);
                        ClassTree cls = tm.addClassImplementsClause((ClassTree)origTree, (Tree)type);
                        if (dialect == null) {
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.annotation.Repository"));
                        } else if (dialect.isEmpty()) {
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.jdbc.annotation.JdbcRepository"));
                        } else {
                            List<ExpressionTree> annArgs = Collections.singletonList(gu.createAnnotationArgument("dialect", "io.micronaut.data.model.query.builder.sql.Dialect", dialect));
                            cls = gu.addAnnotation(cls, gu.createAnnotation("io.micronaut.data.jdbc.annotation.JdbcRepository", annArgs));
                        }
                        ModifiersTree mods = tm.Modifiers(Collections.emptySet(), Arrays.asList(gu.createAnnotation("java.lang.Override"), gu.createAnnotation("io.micronaut.core.annotation.NonNull")));
                        ParameterizedTypeTree retType = tm.ParameterizedType((Tree)tm.QualIdent("java.util.List"), Collections.singletonList(tm.QualIdent(entityFQN)));
                        MethodTree findAllMethod = tm.Method(mods, (CharSequence)"findAll", (Tree)retType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (BlockTree)null, null);
                        cls = tm.addClassMember(cls, (Tree)findAllMethod);
                        copy.rewrite(origTree, (Tree)cls);
                    }
                }).commit();
            }
            return fo;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

