/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hyperlink;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.hyperlink.Bundle;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautConfigHyperlinkProvider
implements HyperlinkProviderExt {
    public static MicronautConfigHyperlinkProvider createYamlProvider() {
        return new MicronautConfigHyperlinkProvider();
    }

    public static MicronautConfigHyperlinkProvider createPropertiesProvider() {
        return new MicronautConfigHyperlinkProvider();
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        int[] span = new int[2];
        ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, span, sources);
        return (int[])(property != null || !sources.isEmpty() ? span : null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> {
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (!sources.isEmpty()) {
                ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
                for (ConfigurationMetadataSource source : sources) {
                    ElementHandle handle;
                    if (property != null && source.getProperties().get(property.getId()) != property || (handle = MicronautConfigHyperlinkProvider.getElementHandle(cpInfo, source.getType(), property != null ? property.getName() : null, cancel)) == null || !ElementOpen.open((ClasspathInfo)cpInfo, (ElementHandle)handle)) continue;
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }, (String)Bundle.LBL_GoToDeclaration(), (AtomicBoolean)cancel, (boolean)false);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, null);
        if (property != null) {
            StringBuilder sb = new StringBuilder("<html><body>");
            sb.append("<b>").append(property.getId().replace(".", ".&#x200B;")).append("</b>");
            String propertyType = property.getType();
            if (propertyType != null) {
                sb.append("<pre>").append(propertyType).append("</pre>");
            }
            return sb.toString();
        }
        return null;
    }

    private static ElementHandle getElementHandle(ClasspathInfo cpInfo, String typeName, String propertyName, AtomicBoolean cancel) {
        ElementHandle[] handle = new ElementHandle[1];
        if (typeName != null) {
            handle[0] = ElementHandle.createTypeElementHandle((ElementKind)ElementKind.CLASS, (String)typeName);
            if (cpInfo != null && propertyName != null) {
                try {
                    JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]).runUserActionTask(controller -> {
                        if (cancel != null && cancel.get()) {
                            return;
                        }
                        TypeElement te = (TypeElement)handle[0].resolve((CompilationInfo)controller);
                        if (te != null) {
                            ElementHandle found = null;
                            String name = "set" + propertyName.replace("-", "");
                            for (ExecutableElement executableElement : ElementFilter.methodsIn(te.getEnclosedElements())) {
                                if (!name.equalsIgnoreCase(executableElement.getSimpleName().toString())) continue;
                                found = ElementHandle.create((Element)executableElement);
                                break;
                            }
                            if (found == null) {
                                TypeElement typeElement = controller.getElements().getTypeElement("io.micronaut.context.annotation.Property");
                                for (VariableElement variableElement : ElementFilter.fieldsIn(te.getEnclosedElements())) {
                                    block2: for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                                        if (typeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                            if (!"name".contentEquals(entry.getKey().getSimpleName()) || !propertyName.equals(entry.getValue().getValue())) continue;
                                            found = ElementHandle.create((Element)variableElement);
                                            continue block2;
                                        }
                                    }
                                }
                            }
                            if (found != null) {
                                handle[0] = found;
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return handle[0];
    }

    public static class LocationProvider
    implements HyperlinkLocationProvider {
        public static LocationProvider createYamlProvider() {
            return new LocationProvider();
        }

        public static LocationProvider createPropertiesProvider() {
            return new LocationProvider();
        }

        public CompletableFuture<HyperlinkLocation> getHyperlinkLocation(Document doc, int offset) {
            AtomicBoolean cancel = new AtomicBoolean();
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (!sources.isEmpty()) {
                ClasspathInfo cpInfo = ClasspathInfo.create((Document)doc);
                for (ConfigurationMetadataSource source : sources) {
                    String typeName;
                    ElementHandle handle;
                    if (property != null && source.getProperties().get(property.getId()) != property || (handle = MicronautConfigHyperlinkProvider.getElementHandle(cpInfo, typeName = source.getType(), property != null ? property.getName() : null, cancel)) == null) continue;
                    CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)cpInfo, (ElementHandle)handle, (String)(typeName.replace('.', '/') + ".class"));
                    return future.thenApply(location -> location != null ? HyperlinkLocationProvider.createHyperlinkLocation((FileObject)location.getFileObject(), (int)location.getStartOffset(), (int)location.getEndOffset()) : null);
                }
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

