/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;

public final class JSSlowArray
extends JSAbstractArray {
    public static final String CLASS_NAME = "Array";
    public static final JSSlowArray INSTANCE = new JSSlowArray();

    private JSSlowArray() {
    }

    public static boolean isJSSlowArray(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSSlowArray.isJSSlowArray((DynamicObject)obj);
    }

    public static boolean isJSSlowArray(DynamicObject obj) {
        return JSSlowArray.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        String indexAsString = Boundaries.stringValueOf(index);
        if (JSOrdinary.INSTANCE.hasOwnProperty(store, indexAsString)) {
            return JSOrdinary.INSTANCE.getOwnHelper(store, thisObj, indexAsString);
        }
        return super.getOwnHelper(store, thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        String indexAsString = Boundaries.stringValueOf(index);
        if (JSOrdinary.INSTANCE.hasOwnProperty(thisObj, indexAsString)) {
            return JSSlowArray.ordinarySet(thisObj, indexAsString, value, receiver, isStrict);
        }
        return super.set(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        ScriptArray array = JSSlowArray.arrayAccess().getArrayType(thisObj);
        if (array.hasElement(thisObj, index)) {
            ScriptArray arrayType = JSSlowArray.arrayGetArrayType(thisObj);
            if (arrayType.canDeleteElement(thisObj, index, isStrict)) {
                JSSlowArray.arraySetArrayType(thisObj, arrayType.deleteElement(thisObj, index, isStrict));
                return true;
            }
            return false;
        }
        return JSOrdinary.INSTANCE.delete(thisObj, index, isStrict);
    }

    @Override
    protected DynamicObject makeSlowArray(DynamicObject thisObj) {
        assert (JSSlowArray.isJSSlowArray(thisObj));
        return thisObj;
    }

    @Override
    protected boolean defineOwnPropertyIndex(DynamicObject thisObj, String name, PropertyDescriptor descriptor, boolean doThrow) {
        boolean succeeded;
        ScriptArray arrayType;
        PropertyDescriptor desc;
        long index = JSRuntime.toUInt32(name);
        if (index >= this.getLength(thisObj) && !(desc = this.getOwnProperty(thisObj, "length")).getWritable()) {
            return DefinePropertyUtil.reject(doThrow, "array length is not writable");
        }
        if (this.getLength(thisObj) <= index) {
            this.setLength(thisObj, index + 1L, doThrow);
        }
        if ((arrayType = JSSlowArray.arrayGetArrayType(thisObj)).hasElement(thisObj, index) && !JSOrdinary.INSTANCE.hasOwnProperty(thisObj, name)) {
            JSContext context = JSObject.getJSContext(thisObj);
            boolean wasNotExtensible = !JSShape.isExtensible(thisObj.getShape());
            JSObjectUtil.putDataProperty(context, thisObj, name, this.get(thisObj, index), JSAttributes.fromConfigurableEnumerableWritable(!arrayType.isSealed(), true, !arrayType.isFrozen()));
            if (wasNotExtensible) assert (!JSShape.isExtensible(thisObj.getShape()));
            JSSlowArray.arraySetArrayType(thisObj, arrayType.deleteElementImpl(thisObj, index, false));
        }
        if (!(succeeded = JSSlowArray.jsDefineProperty(thisObj, index, descriptor, false))) {
            JSContext context = JavaScriptLanguage.getCurrentJSRealm().getContext();
            return DefinePropertyUtil.reject(doThrow, context.isOptionNashornCompatibilityMode() ? "cannot set property" : "Cannot redefine property");
        }
        return true;
    }

    private static boolean jsDefineProperty(DynamicObject thisObj, long index, PropertyDescriptor descriptor, boolean doThrow) {
        ScriptArray internalArray = JSSlowArray.arrayAccess().getArrayType(thisObj);
        boolean copyValue = internalArray.hasElement(thisObj, index) && !descriptor.hasValue() && !descriptor.hasGet();
        boolean succeed = DefinePropertyUtil.ordinaryDefineOwnProperty(thisObj, Boundaries.stringValueOf(index), descriptor, doThrow);
        if (copyValue) {
            JSObject.set(thisObj, index, internalArray.getElement(thisObj, index), doThrow);
        }
        return succeed;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setLength(DynamicObject thisObj, long length, boolean doThrow) {
        if (this.testIntegrityLevel(thisObj, true)) {
            throw Errors.createTypeError("cannot set length of a frozen array");
        }
        long oldLen = this.getLength(thisObj);
        long newLen = length;
        ScriptArray internalArray = JSSlowArray.arrayGetArrayType(thisObj);
        boolean sealed = internalArray.isSealed();
        boolean deleteSucceeded = true;
        if (newLen < oldLen) {
            for (long idx = oldLen - 1L; idx >= newLen; --idx) {
                deleteSucceeded = internalArray.hasElement(thisObj, idx) ? !sealed : JSOrdinary.INSTANCE.delete(thisObj, idx, false);
                if (deleteSucceeded) continue;
                newLen = idx + 1L;
                break;
            }
        }
        if (newLen > Integer.MAX_VALUE && !(internalArray instanceof SparseArray)) {
            internalArray = SparseArray.makeSparseArray(thisObj, internalArray);
        }
        JSSlowArray.arraySetArrayType(thisObj, internalArray.setLength(thisObj, newLen, doThrow));
        if (!deleteSucceeded) {
            JSContext context = JavaScriptLanguage.getCurrentJSRealm().getContext();
            return DefinePropertyUtil.reject(doThrow, context.isOptionNashornCompatibilityMode() ? "cannot set property: length" : "Cannot redefine property: length");
        }
        return true;
    }
}

