/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.devops.Devops;
import com.oracle.bmc.devops.DevopsPaginators;
import com.oracle.bmc.devops.DevopsWaiters;
import com.oracle.bmc.devops.internal.http.ApproveDeploymentConverter;
import com.oracle.bmc.devops.internal.http.CancelBuildRunConverter;
import com.oracle.bmc.devops.internal.http.CancelDeploymentConverter;
import com.oracle.bmc.devops.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildRunConverter;
import com.oracle.bmc.devops.internal.http.CreateConnectionConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployStageConverter;
import com.oracle.bmc.devops.internal.http.CreateDeploymentConverter;
import com.oracle.bmc.devops.internal.http.CreateProjectConverter;
import com.oracle.bmc.devops.internal.http.CreateRepositoryConverter;
import com.oracle.bmc.devops.internal.http.CreateTriggerConverter;
import com.oracle.bmc.devops.internal.http.DeleteBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.DeleteBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployStageConverter;
import com.oracle.bmc.devops.internal.http.DeleteProjectConverter;
import com.oracle.bmc.devops.internal.http.DeleteRefConverter;
import com.oracle.bmc.devops.internal.http.DeleteRepositoryConverter;
import com.oracle.bmc.devops.internal.http.DeleteTriggerConverter;
import com.oracle.bmc.devops.internal.http.GetBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.GetBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.GetBuildRunConverter;
import com.oracle.bmc.devops.internal.http.GetCommitConverter;
import com.oracle.bmc.devops.internal.http.GetCommitDiffConverter;
import com.oracle.bmc.devops.internal.http.GetConnectionConverter;
import com.oracle.bmc.devops.internal.http.GetDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.GetDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.GetDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.GetDeployStageConverter;
import com.oracle.bmc.devops.internal.http.GetDeploymentConverter;
import com.oracle.bmc.devops.internal.http.GetFileDiffConverter;
import com.oracle.bmc.devops.internal.http.GetMirrorRecordConverter;
import com.oracle.bmc.devops.internal.http.GetObjectContentConverter;
import com.oracle.bmc.devops.internal.http.GetObjectConverter;
import com.oracle.bmc.devops.internal.http.GetProjectConverter;
import com.oracle.bmc.devops.internal.http.GetRefConverter;
import com.oracle.bmc.devops.internal.http.GetRepoFileDiffConverter;
import com.oracle.bmc.devops.internal.http.GetRepoFileLinesConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryArchiveContentConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryFileLinesConverter;
import com.oracle.bmc.devops.internal.http.GetTriggerConverter;
import com.oracle.bmc.devops.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.devops.internal.http.ListAuthorsConverter;
import com.oracle.bmc.devops.internal.http.ListBuildPipelineStagesConverter;
import com.oracle.bmc.devops.internal.http.ListBuildPipelinesConverter;
import com.oracle.bmc.devops.internal.http.ListBuildRunsConverter;
import com.oracle.bmc.devops.internal.http.ListCommitDiffsConverter;
import com.oracle.bmc.devops.internal.http.ListCommitsConverter;
import com.oracle.bmc.devops.internal.http.ListConnectionsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployArtifactsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployEnvironmentsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployPipelinesConverter;
import com.oracle.bmc.devops.internal.http.ListDeployStagesConverter;
import com.oracle.bmc.devops.internal.http.ListDeploymentsConverter;
import com.oracle.bmc.devops.internal.http.ListMirrorRecordsConverter;
import com.oracle.bmc.devops.internal.http.ListPathsConverter;
import com.oracle.bmc.devops.internal.http.ListProjectsConverter;
import com.oracle.bmc.devops.internal.http.ListRefsConverter;
import com.oracle.bmc.devops.internal.http.ListRepositoriesConverter;
import com.oracle.bmc.devops.internal.http.ListTriggersConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.devops.internal.http.MirrorRepositoryConverter;
import com.oracle.bmc.devops.internal.http.PutRepositoryRefConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildRunConverter;
import com.oracle.bmc.devops.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployStageConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeploymentConverter;
import com.oracle.bmc.devops.internal.http.UpdateProjectConverter;
import com.oracle.bmc.devops.internal.http.UpdateRepositoryConverter;
import com.oracle.bmc.devops.internal.http.UpdateTriggerConverter;
import com.oracle.bmc.devops.requests.ApproveDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelBuildRunRequest;
import com.oracle.bmc.devops.requests.CancelDeploymentRequest;
import com.oracle.bmc.devops.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.requests.CreateConnectionRequest;
import com.oracle.bmc.devops.requests.CreateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.CreateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.CreateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.CreateDeployStageRequest;
import com.oracle.bmc.devops.requests.CreateDeploymentRequest;
import com.oracle.bmc.devops.requests.CreateProjectRequest;
import com.oracle.bmc.devops.requests.CreateRepositoryRequest;
import com.oracle.bmc.devops.requests.CreateTriggerRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.DeleteConnectionRequest;
import com.oracle.bmc.devops.requests.DeleteDeployArtifactRequest;
import com.oracle.bmc.devops.requests.DeleteDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.DeleteDeployPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteDeployStageRequest;
import com.oracle.bmc.devops.requests.DeleteProjectRequest;
import com.oracle.bmc.devops.requests.DeleteRefRequest;
import com.oracle.bmc.devops.requests.DeleteRepositoryRequest;
import com.oracle.bmc.devops.requests.DeleteTriggerRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.GetBuildRunRequest;
import com.oracle.bmc.devops.requests.GetCommitDiffRequest;
import com.oracle.bmc.devops.requests.GetCommitRequest;
import com.oracle.bmc.devops.requests.GetConnectionRequest;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.GetDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.GetDeployPipelineRequest;
import com.oracle.bmc.devops.requests.GetDeployStageRequest;
import com.oracle.bmc.devops.requests.GetDeploymentRequest;
import com.oracle.bmc.devops.requests.GetFileDiffRequest;
import com.oracle.bmc.devops.requests.GetMirrorRecordRequest;
import com.oracle.bmc.devops.requests.GetObjectContentRequest;
import com.oracle.bmc.devops.requests.GetObjectRequest;
import com.oracle.bmc.devops.requests.GetProjectRequest;
import com.oracle.bmc.devops.requests.GetRefRequest;
import com.oracle.bmc.devops.requests.GetRepoFileDiffRequest;
import com.oracle.bmc.devops.requests.GetRepoFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryArchiveContentRequest;
import com.oracle.bmc.devops.requests.GetRepositoryFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryRequest;
import com.oracle.bmc.devops.requests.GetTriggerRequest;
import com.oracle.bmc.devops.requests.GetWorkRequestRequest;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelineStagesRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.requests.ListCommitDiffsRequest;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.requests.ListConnectionsRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.ListDeployEnvironmentsRequest;
import com.oracle.bmc.devops.requests.ListDeployPipelinesRequest;
import com.oracle.bmc.devops.requests.ListDeployStagesRequest;
import com.oracle.bmc.devops.requests.ListDeploymentsRequest;
import com.oracle.bmc.devops.requests.ListMirrorRecordsRequest;
import com.oracle.bmc.devops.requests.ListPathsRequest;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.requests.ListRefsRequest;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.requests.ListTriggersRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.devops.requests.MirrorRepositoryRequest;
import com.oracle.bmc.devops.requests.PutRepositoryRefRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.UpdateBuildRunRequest;
import com.oracle.bmc.devops.requests.UpdateConnectionRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.UpdateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.UpdateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateDeployStageRequest;
import com.oracle.bmc.devops.requests.UpdateDeploymentRequest;
import com.oracle.bmc.devops.requests.UpdateProjectRequest;
import com.oracle.bmc.devops.requests.UpdateRepositoryRequest;
import com.oracle.bmc.devops.requests.UpdateTriggerRequest;
import com.oracle.bmc.devops.responses.ApproveDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelBuildRunResponse;
import com.oracle.bmc.devops.responses.CancelDeploymentResponse;
import com.oracle.bmc.devops.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.devops.responses.CreateConnectionResponse;
import com.oracle.bmc.devops.responses.CreateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.CreateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.CreateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.CreateDeployStageResponse;
import com.oracle.bmc.devops.responses.CreateDeploymentResponse;
import com.oracle.bmc.devops.responses.CreateProjectResponse;
import com.oracle.bmc.devops.responses.CreateRepositoryResponse;
import com.oracle.bmc.devops.responses.CreateTriggerResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.DeleteConnectionResponse;
import com.oracle.bmc.devops.responses.DeleteDeployArtifactResponse;
import com.oracle.bmc.devops.responses.DeleteDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.DeleteDeployPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteDeployStageResponse;
import com.oracle.bmc.devops.responses.DeleteProjectResponse;
import com.oracle.bmc.devops.responses.DeleteRefResponse;
import com.oracle.bmc.devops.responses.DeleteRepositoryResponse;
import com.oracle.bmc.devops.responses.DeleteTriggerResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.GetBuildRunResponse;
import com.oracle.bmc.devops.responses.GetCommitDiffResponse;
import com.oracle.bmc.devops.responses.GetCommitResponse;
import com.oracle.bmc.devops.responses.GetConnectionResponse;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.GetDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.GetDeployPipelineResponse;
import com.oracle.bmc.devops.responses.GetDeployStageResponse;
import com.oracle.bmc.devops.responses.GetDeploymentResponse;
import com.oracle.bmc.devops.responses.GetFileDiffResponse;
import com.oracle.bmc.devops.responses.GetMirrorRecordResponse;
import com.oracle.bmc.devops.responses.GetObjectContentResponse;
import com.oracle.bmc.devops.responses.GetObjectResponse;
import com.oracle.bmc.devops.responses.GetProjectResponse;
import com.oracle.bmc.devops.responses.GetRefResponse;
import com.oracle.bmc.devops.responses.GetRepoFileDiffResponse;
import com.oracle.bmc.devops.responses.GetRepoFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryArchiveContentResponse;
import com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryResponse;
import com.oracle.bmc.devops.responses.GetTriggerResponse;
import com.oracle.bmc.devops.responses.GetWorkRequestResponse;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelineStagesResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import com.oracle.bmc.devops.responses.ListCommitDiffsResponse;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.devops.responses.ListConnectionsResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.devops.responses.ListDeployEnvironmentsResponse;
import com.oracle.bmc.devops.responses.ListDeployPipelinesResponse;
import com.oracle.bmc.devops.responses.ListDeployStagesResponse;
import com.oracle.bmc.devops.responses.ListDeploymentsResponse;
import com.oracle.bmc.devops.responses.ListMirrorRecordsResponse;
import com.oracle.bmc.devops.responses.ListPathsResponse;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import com.oracle.bmc.devops.responses.ListRefsResponse;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import com.oracle.bmc.devops.responses.ListTriggersResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.devops.responses.MirrorRepositoryResponse;
import com.oracle.bmc.devops.responses.PutRepositoryRefResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.UpdateBuildRunResponse;
import com.oracle.bmc.devops.responses.UpdateConnectionResponse;
import com.oracle.bmc.devops.responses.UpdateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.UpdateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.UpdateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateDeployStageResponse;
import com.oracle.bmc.devops.responses.UpdateDeploymentResponse;
import com.oracle.bmc.devops.responses.UpdateProjectResponse;
import com.oracle.bmc.devops.responses.UpdateRepositoryResponse;
import com.oracle.bmc.devops.responses.UpdateTriggerResponse;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevopsClient
implements Devops {
    private static final Logger LOG = LoggerFactory.getLogger(DevopsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEVOPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://devops.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DevopsWaiters waiters;
    private final DevopsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        if (circuitBreakerConfiguration == null) {
            circuitBreakerConfiguration = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, null, circuitBreakerConfiguration);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Devops-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DevopsWaiters(executorService, this);
        this.paginators = new DevopsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ApproveDeploymentResponse approveDeployment(ApproveDeploymentRequest request) {
        LOG.trace("Called approveDeployment");
        ApproveDeploymentRequest interceptedRequest = ApproveDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ApproveDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ApproveDeploymentResponse> transformer = ApproveDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ApproveDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/ApproveDeployment");
        return (ApproveDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ApproveDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getApproveDeploymentDetails(), (BmcRequest)retriedRequest);
                return (ApproveDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CancelBuildRunResponse cancelBuildRun(CancelBuildRunRequest request) {
        LOG.trace("Called cancelBuildRun");
        CancelBuildRunRequest interceptedRequest = CancelBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelBuildRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelBuildRunResponse> transformer = CancelBuildRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CancelBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CancelBuildRun");
        return (CancelBuildRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelBuildRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCancelBuildRunDetails(), (BmcRequest)retriedRequest);
                return (CancelBuildRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CancelDeploymentResponse cancelDeployment(CancelDeploymentRequest request) {
        LOG.trace("Called cancelDeployment");
        CancelDeploymentRequest interceptedRequest = CancelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelDeploymentResponse> transformer = CancelDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CancelDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CancelDeployment");
        return (CancelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCancelDeploymentDetails(), (BmcRequest)retriedRequest);
                return (CancelDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        LOG.trace("Called changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ChangeProjectCompartment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ChangeProjectCompartment");
        return (ChangeProjectCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeProjectCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeProjectCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeProjectCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateBuildPipelineResponse createBuildPipeline(CreateBuildPipelineRequest request) {
        LOG.trace("Called createBuildPipeline");
        CreateBuildPipelineRequest interceptedRequest = CreateBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBuildPipelineResponse> transformer = CreateBuildPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/CreateBuildPipeline");
        return (CreateBuildPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBuildPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBuildPipelineDetails(), (BmcRequest)retriedRequest);
                return (CreateBuildPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateBuildPipelineStageResponse createBuildPipelineStage(CreateBuildPipelineStageRequest request) {
        LOG.trace("Called createBuildPipelineStage");
        CreateBuildPipelineStageRequest interceptedRequest = CreateBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBuildPipelineStageResponse> transformer = CreateBuildPipelineStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/CreateBuildPipelineStage");
        return (CreateBuildPipelineStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBuildPipelineStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBuildPipelineStageDetails(), (BmcRequest)retriedRequest);
                return (CreateBuildPipelineStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateBuildRunResponse createBuildRun(CreateBuildRunRequest request) {
        LOG.trace("Called createBuildRun");
        CreateBuildRunRequest interceptedRequest = CreateBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBuildRunResponse> transformer = CreateBuildRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CreateBuildRun");
        return (CreateBuildRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBuildRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBuildRunDetails(), (BmcRequest)retriedRequest);
                return (CreateBuildRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        LOG.trace("Called createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/CreateConnection");
        return (CreateConnectionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectionDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateDeployArtifactResponse createDeployArtifact(CreateDeployArtifactRequest request) {
        LOG.trace("Called createDeployArtifact");
        CreateDeployArtifactRequest interceptedRequest = CreateDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeployArtifactResponse> transformer = CreateDeployArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/CreateDeployArtifact");
        return (CreateDeployArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeployArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeployArtifactDetails(), (BmcRequest)retriedRequest);
                return (CreateDeployArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateDeployEnvironmentResponse createDeployEnvironment(CreateDeployEnvironmentRequest request) {
        LOG.trace("Called createDeployEnvironment");
        CreateDeployEnvironmentRequest interceptedRequest = CreateDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeployEnvironmentResponse> transformer = CreateDeployEnvironmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/CreateDeployEnvironment");
        return (CreateDeployEnvironmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeployEnvironmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeployEnvironmentDetails(), (BmcRequest)retriedRequest);
                return (CreateDeployEnvironmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateDeployPipelineResponse createDeployPipeline(CreateDeployPipelineRequest request) {
        LOG.trace("Called createDeployPipeline");
        CreateDeployPipelineRequest interceptedRequest = CreateDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeployPipelineResponse> transformer = CreateDeployPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/CreateDeployPipeline");
        return (CreateDeployPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeployPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeployPipelineDetails(), (BmcRequest)retriedRequest);
                return (CreateDeployPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateDeployStageResponse createDeployStage(CreateDeployStageRequest request) {
        LOG.trace("Called createDeployStage");
        CreateDeployStageRequest interceptedRequest = CreateDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeployStageResponse> transformer = CreateDeployStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/CreateDeployStage");
        return (CreateDeployStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeployStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeployStageDetails(), (BmcRequest)retriedRequest);
                return (CreateDeployStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest request) {
        LOG.trace("Called createDeployment");
        CreateDeploymentRequest interceptedRequest = CreateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDeploymentResponse> transformer = CreateDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CreateDeployment");
        return (CreateDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDeploymentDetails(), (BmcRequest)retriedRequest);
                return (CreateDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        LOG.trace("Called createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CreateProject");
        return (CreateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProjectDetails(), (BmcRequest)retriedRequest);
                return (CreateProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest request) {
        LOG.trace("Called createRepository");
        CreateRepositoryRequest interceptedRequest = CreateRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRepositoryResponse> transformer = CreateRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/CreateRepository");
        return (CreateRepositoryResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRepositoryResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRepositoryDetails(), (BmcRequest)retriedRequest);
                return (CreateRepositoryResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateTriggerResponse createTrigger(CreateTriggerRequest request) {
        LOG.trace("Called createTrigger");
        CreateTriggerRequest interceptedRequest = CreateTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTriggerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTriggerResponse> transformer = CreateTriggerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/CreateTrigger");
        return (CreateTriggerResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTriggerResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTriggerDetails(), (BmcRequest)retriedRequest);
                return (CreateTriggerResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteBuildPipelineResponse deleteBuildPipeline(DeleteBuildPipelineRequest request) {
        LOG.trace("Called deleteBuildPipeline");
        DeleteBuildPipelineRequest interceptedRequest = DeleteBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBuildPipelineResponse> transformer = DeleteBuildPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/DeleteBuildPipeline");
        return (DeleteBuildPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBuildPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBuildPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteBuildPipelineStageResponse deleteBuildPipelineStage(DeleteBuildPipelineStageRequest request) {
        LOG.trace("Called deleteBuildPipelineStage");
        DeleteBuildPipelineStageRequest interceptedRequest = DeleteBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBuildPipelineStageResponse> transformer = DeleteBuildPipelineStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/DeleteBuildPipelineStage");
        return (DeleteBuildPipelineStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBuildPipelineStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBuildPipelineStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        LOG.trace("Called deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/DeleteConnection");
        return (DeleteConnectionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteDeployArtifactResponse deleteDeployArtifact(DeleteDeployArtifactRequest request) {
        LOG.trace("Called deleteDeployArtifact");
        DeleteDeployArtifactRequest interceptedRequest = DeleteDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeployArtifactResponse> transformer = DeleteDeployArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/DeleteDeployArtifact");
        return (DeleteDeployArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeployArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeployArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteDeployEnvironmentResponse deleteDeployEnvironment(DeleteDeployEnvironmentRequest request) {
        LOG.trace("Called deleteDeployEnvironment");
        DeleteDeployEnvironmentRequest interceptedRequest = DeleteDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeployEnvironmentResponse> transformer = DeleteDeployEnvironmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/DeleteDeployEnvironment");
        return (DeleteDeployEnvironmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeployEnvironmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeployEnvironmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteDeployPipelineResponse deleteDeployPipeline(DeleteDeployPipelineRequest request) {
        LOG.trace("Called deleteDeployPipeline");
        DeleteDeployPipelineRequest interceptedRequest = DeleteDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeployPipelineResponse> transformer = DeleteDeployPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/DeleteDeployPipeline");
        return (DeleteDeployPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeployPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeployPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteDeployStageResponse deleteDeployStage(DeleteDeployStageRequest request) {
        LOG.trace("Called deleteDeployStage");
        DeleteDeployStageRequest interceptedRequest = DeleteDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDeployStageResponse> transformer = DeleteDeployStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/DeleteDeployStage");
        return (DeleteDeployStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDeployStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDeployStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        LOG.trace("Called deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/DeleteProject");
        return (DeleteProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteRefResponse deleteRef(DeleteRefRequest request) {
        LOG.trace("Called deleteRef");
        DeleteRefRequest interceptedRequest = DeleteRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRefConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRefResponse> transformer = DeleteRefConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRef");
        return (DeleteRefResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRefResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRefResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest request) {
        LOG.trace("Called deleteRepository");
        DeleteRepositoryRequest interceptedRequest = DeleteRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRepositoryResponse> transformer = DeleteRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRepository");
        return (DeleteRepositoryResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRepositoryResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRepositoryResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest request) {
        LOG.trace("Called deleteTrigger");
        DeleteTriggerRequest interceptedRequest = DeleteTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTriggerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTriggerResponse> transformer = DeleteTriggerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/DeleteTrigger");
        return (DeleteTriggerResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTriggerResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTriggerResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetBuildPipelineResponse getBuildPipeline(GetBuildPipelineRequest request) {
        LOG.trace("Called getBuildPipeline");
        GetBuildPipelineRequest interceptedRequest = GetBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBuildPipelineResponse> transformer = GetBuildPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/GetBuildPipeline");
        return (GetBuildPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBuildPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBuildPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetBuildPipelineStageResponse getBuildPipelineStage(GetBuildPipelineStageRequest request) {
        LOG.trace("Called getBuildPipelineStage");
        GetBuildPipelineStageRequest interceptedRequest = GetBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBuildPipelineStageResponse> transformer = GetBuildPipelineStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/GetBuildPipelineStage");
        return (GetBuildPipelineStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBuildPipelineStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBuildPipelineStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetBuildRunResponse getBuildRun(GetBuildRunRequest request) {
        LOG.trace("Called getBuildRun");
        GetBuildRunRequest interceptedRequest = GetBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBuildRunResponse> transformer = GetBuildRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/GetBuildRun");
        return (GetBuildRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBuildRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBuildRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetCommitResponse getCommit(GetCommitRequest request) {
        LOG.trace("Called getCommit");
        GetCommitRequest interceptedRequest = GetCommitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCommitConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCommitResponse> transformer = GetCommitConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetCommit", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommit");
        return (GetCommitResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCommitResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCommitResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetCommitDiffResponse getCommitDiff(GetCommitDiffRequest request) {
        LOG.trace("Called getCommitDiff");
        GetCommitDiffRequest interceptedRequest = GetCommitDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCommitDiffConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCommitDiffResponse> transformer = GetCommitDiffConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetCommitDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommitDiff");
        return (GetCommitDiffResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCommitDiffResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCommitDiffResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        LOG.trace("Called getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/GetConnection");
        return (GetConnectionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetDeployArtifactResponse getDeployArtifact(GetDeployArtifactRequest request) {
        LOG.trace("Called getDeployArtifact");
        GetDeployArtifactRequest interceptedRequest = GetDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeployArtifactResponse> transformer = GetDeployArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/GetDeployArtifact");
        return (GetDeployArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeployArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeployArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetDeployEnvironmentResponse getDeployEnvironment(GetDeployEnvironmentRequest request) {
        LOG.trace("Called getDeployEnvironment");
        GetDeployEnvironmentRequest interceptedRequest = GetDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeployEnvironmentResponse> transformer = GetDeployEnvironmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/GetDeployEnvironment");
        return (GetDeployEnvironmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeployEnvironmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeployEnvironmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetDeployPipelineResponse getDeployPipeline(GetDeployPipelineRequest request) {
        LOG.trace("Called getDeployPipeline");
        GetDeployPipelineRequest interceptedRequest = GetDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeployPipelineResponse> transformer = GetDeployPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/GetDeployPipeline");
        return (GetDeployPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeployPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeployPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetDeployStageResponse getDeployStage(GetDeployStageRequest request) {
        LOG.trace("Called getDeployStage");
        GetDeployStageRequest interceptedRequest = GetDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeployStageResponse> transformer = GetDeployStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/GetDeployStage");
        return (GetDeployStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeployStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeployStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest request) {
        LOG.trace("Called getDeployment");
        GetDeploymentRequest interceptedRequest = GetDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeploymentResponse> transformer = GetDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/GetDeployment");
        return (GetDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetFileDiffResponse getFileDiff(GetFileDiffRequest request) {
        LOG.trace("Called getFileDiff");
        GetFileDiffRequest interceptedRequest = GetFileDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFileDiffConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFileDiffResponse> transformer = GetFileDiffConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetFileDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetFileDiff");
        return (GetFileDiffResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFileDiffResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFileDiffResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetMirrorRecordResponse getMirrorRecord(GetMirrorRecordRequest request) {
        LOG.trace("Called getMirrorRecord");
        GetMirrorRecordRequest interceptedRequest = GetMirrorRecordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMirrorRecordConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMirrorRecordResponse> transformer = GetMirrorRecordConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetMirrorRecord", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetMirrorRecord");
        return (GetMirrorRecordResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetMirrorRecordResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetMirrorRecordResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetObjectResponse getObject(GetObjectRequest request) {
        LOG.trace("Called getObject");
        GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetObject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryObject/GetObject");
        return (GetObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetObjectContentResponse getObjectContent(GetObjectContentRequest request) {
        LOG.trace("Called getObjectContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getObjectContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetObjectContentRequest interceptedRequest = GetObjectContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectContentResponse> transformer = GetObjectContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetObjectContent", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetObjectContent");
        return (GetObjectContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetObjectContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetObjectContentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        LOG.trace("Called getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/GetProject");
        return (GetProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRefResponse getRef(GetRefRequest request) {
        LOG.trace("Called getRef");
        GetRefRequest interceptedRequest = GetRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRefConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRefResponse> transformer = GetRefConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRef");
        return (GetRefResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRefResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRefResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRepoFileDiffResponse getRepoFileDiff(GetRepoFileDiffRequest request) {
        LOG.trace("Called getRepoFileDiff");
        GetRepoFileDiffRequest interceptedRequest = GetRepoFileDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepoFileDiffConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRepoFileDiffResponse> transformer = GetRepoFileDiffConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepoFileDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileDiff");
        return (GetRepoFileDiffResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRepoFileDiffResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRepoFileDiffResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRepoFileLinesResponse getRepoFileLines(GetRepoFileLinesRequest request) {
        LOG.trace("Called getRepoFileLines");
        GetRepoFileLinesRequest interceptedRequest = GetRepoFileLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepoFileLinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRepoFileLinesResponse> transformer = GetRepoFileLinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepoFileLines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileLines");
        return (GetRepoFileLinesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRepoFileLinesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRepoFileLinesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRepositoryResponse getRepository(GetRepositoryRequest request) {
        LOG.trace("Called getRepository");
        GetRepositoryRequest interceptedRequest = GetRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRepositoryResponse> transformer = GetRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepository");
        return (GetRepositoryResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRepositoryResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRepositoryResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRepositoryArchiveContentResponse getRepositoryArchiveContent(GetRepositoryArchiveContentRequest request) {
        LOG.trace("Called getRepositoryArchiveContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getRepositoryArchiveContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetRepositoryArchiveContentRequest interceptedRequest = GetRepositoryArchiveContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryArchiveContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRepositoryArchiveContentResponse> transformer = GetRepositoryArchiveContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepositoryArchiveContent", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryArchiveContent");
        return (GetRepositoryArchiveContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRepositoryArchiveContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRepositoryArchiveContentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRepositoryFileLinesResponse getRepositoryFileLines(GetRepositoryFileLinesRequest request) {
        LOG.trace("Called getRepositoryFileLines");
        GetRepositoryFileLinesRequest interceptedRequest = GetRepositoryFileLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryFileLinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRepositoryFileLinesResponse> transformer = GetRepositoryFileLinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepositoryFileLines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryFileLines");
        return (GetRepositoryFileLinesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRepositoryFileLinesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRepositoryFileLinesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetTriggerResponse getTrigger(GetTriggerRequest request) {
        LOG.trace("Called getTrigger");
        GetTriggerRequest interceptedRequest = GetTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTriggerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTriggerResponse> transformer = GetTriggerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/GetTrigger");
        return (GetTriggerResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTriggerResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTriggerResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetWorkRequest", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/GetWorkRequest");
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAuthorsResponse listAuthors(ListAuthorsRequest request) {
        LOG.trace("Called listAuthors");
        ListAuthorsRequest interceptedRequest = ListAuthorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAuthorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAuthorsResponse> transformer = ListAuthorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListAuthors", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListAuthors");
        return (ListAuthorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAuthorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAuthorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListBuildPipelineStagesResponse listBuildPipelineStages(ListBuildPipelineStagesRequest request) {
        LOG.trace("Called listBuildPipelineStages");
        ListBuildPipelineStagesRequest interceptedRequest = ListBuildPipelineStagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildPipelineStagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBuildPipelineStagesResponse> transformer = ListBuildPipelineStagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildPipelineStages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStageSummary/ListBuildPipelineStages");
        return (ListBuildPipelineStagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBuildPipelineStagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBuildPipelineStagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListBuildPipelinesResponse listBuildPipelines(ListBuildPipelinesRequest request) {
        LOG.trace("Called listBuildPipelines");
        ListBuildPipelinesRequest interceptedRequest = ListBuildPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildPipelinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBuildPipelinesResponse> transformer = ListBuildPipelinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildPipelines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineCollection/ListBuildPipelines");
        return (ListBuildPipelinesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBuildPipelinesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBuildPipelinesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListBuildRunsResponse listBuildRuns(ListBuildRunsRequest request) {
        LOG.trace("Called listBuildRuns");
        ListBuildRunsRequest interceptedRequest = ListBuildRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBuildRunsResponse> transformer = ListBuildRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildRuns", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRunSummary/ListBuildRuns");
        return (ListBuildRunsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBuildRunsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBuildRunsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListCommitDiffsResponse listCommitDiffs(ListCommitDiffsRequest request) {
        LOG.trace("Called listCommitDiffs");
        ListCommitDiffsRequest interceptedRequest = ListCommitDiffsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCommitDiffsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCommitDiffsResponse> transformer = ListCommitDiffsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListCommitDiffs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListCommitDiffs");
        return (ListCommitDiffsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCommitDiffsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCommitDiffsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListCommitsResponse listCommits(ListCommitsRequest request) {
        LOG.trace("Called listCommits");
        ListCommitsRequest interceptedRequest = ListCommitsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCommitsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCommitsResponse> transformer = ListCommitsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListCommits", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryCommit/ListCommits");
        return (ListCommitsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCommitsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCommitsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        LOG.trace("Called listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListConnections", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/ConnectionCollection/ListConnections");
        return (ListConnectionsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectionsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectionsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListDeployArtifactsResponse listDeployArtifacts(ListDeployArtifactsRequest request) {
        LOG.trace("Called listDeployArtifacts");
        ListDeployArtifactsRequest interceptedRequest = ListDeployArtifactsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployArtifactsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeployArtifactsResponse> transformer = ListDeployArtifactsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployArtifacts", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifactSummary/ListDeployArtifacts");
        return (ListDeployArtifactsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeployArtifactsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeployArtifactsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListDeployEnvironmentsResponse listDeployEnvironments(ListDeployEnvironmentsRequest request) {
        LOG.trace("Called listDeployEnvironments");
        ListDeployEnvironmentsRequest interceptedRequest = ListDeployEnvironmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployEnvironmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeployEnvironmentsResponse> transformer = ListDeployEnvironmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployEnvironments", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironmentSummary/ListDeployEnvironments");
        return (ListDeployEnvironmentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeployEnvironmentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeployEnvironmentsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListDeployPipelinesResponse listDeployPipelines(ListDeployPipelinesRequest request) {
        LOG.trace("Called listDeployPipelines");
        ListDeployPipelinesRequest interceptedRequest = ListDeployPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployPipelinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeployPipelinesResponse> transformer = ListDeployPipelinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployPipelines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipelineSummary/ListDeployPipelines");
        return (ListDeployPipelinesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeployPipelinesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeployPipelinesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListDeployStagesResponse listDeployStages(ListDeployStagesRequest request) {
        LOG.trace("Called listDeployStages");
        ListDeployStagesRequest interceptedRequest = ListDeployStagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployStagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeployStagesResponse> transformer = ListDeployStagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployStages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStageSummary/ListDeployStages");
        return (ListDeployStagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeployStagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeployStagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest request) {
        LOG.trace("Called listDeployments");
        ListDeploymentsRequest interceptedRequest = ListDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDeploymentsResponse> transformer = ListDeploymentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployments", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeploymentSummary/ListDeployments");
        return (ListDeploymentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDeploymentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDeploymentsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListMirrorRecordsResponse listMirrorRecords(ListMirrorRecordsRequest request) {
        LOG.trace("Called listMirrorRecords");
        ListMirrorRecordsRequest interceptedRequest = ListMirrorRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMirrorRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMirrorRecordsResponse> transformer = ListMirrorRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListMirrorRecords", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListMirrorRecords");
        return (ListMirrorRecordsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMirrorRecordsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMirrorRecordsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListPathsResponse listPaths(ListPathsRequest request) {
        LOG.trace("Called listPaths");
        ListPathsRequest interceptedRequest = ListPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPathsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPathsResponse> transformer = ListPathsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListPaths", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryPathSummary/ListPaths");
        return (ListPathsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPathsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPathsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        LOG.trace("Called listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListProjects", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectSummary/ListProjects");
        return (ListProjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProjectsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListRefsResponse listRefs(ListRefsRequest request) {
        LOG.trace("Called listRefs");
        ListRefsRequest interceptedRequest = ListRefsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRefsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRefsResponse> transformer = ListRefsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListRefs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryRef/ListRefs");
        return (ListRefsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRefsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRefsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest request) {
        LOG.trace("Called listRepositories");
        ListRepositoriesRequest interceptedRequest = ListRepositoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRepositoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRepositoriesResponse> transformer = ListRepositoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListRepositories", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListRepositories");
        return (ListRepositoriesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRepositoriesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRepositoriesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListTriggersResponse listTriggers(ListTriggersRequest request) {
        LOG.trace("Called listTriggers");
        ListTriggersRequest interceptedRequest = ListTriggersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTriggersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTriggersResponse> transformer = ListTriggersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListTriggers", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/TriggerCollection/ListTriggers");
        return (ListTriggersResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTriggersResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTriggersResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequestErrors", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestError/ListWorkRequestErrors");
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequestLogs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestLogEntry/ListWorkRequestLogs");
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequests", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/ListWorkRequests");
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public MirrorRepositoryResponse mirrorRepository(MirrorRepositoryRequest request) {
        LOG.trace("Called mirrorRepository");
        MirrorRepositoryRequest interceptedRequest = MirrorRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MirrorRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, MirrorRepositoryResponse> transformer = MirrorRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"MirrorRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/MirrorRepository");
        return (MirrorRepositoryResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (MirrorRepositoryResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (MirrorRepositoryResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public PutRepositoryRefResponse putRepositoryRef(PutRepositoryRefRequest request) {
        LOG.trace("Called putRepositoryRef");
        PutRepositoryRefRequest interceptedRequest = PutRepositoryRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutRepositoryRefConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PutRepositoryRefResponse> transformer = PutRepositoryRefConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"PutRepositoryRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/PutRepositoryRef");
        return (PutRepositoryRefResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PutRepositoryRefResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getPutRepositoryRefDetails(), (BmcRequest)retriedRequest);
                return (PutRepositoryRefResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateBuildPipelineResponse updateBuildPipeline(UpdateBuildPipelineRequest request) {
        LOG.trace("Called updateBuildPipeline");
        UpdateBuildPipelineRequest interceptedRequest = UpdateBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBuildPipelineResponse> transformer = UpdateBuildPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/UpdateBuildPipeline");
        return (UpdateBuildPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBuildPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBuildPipelineDetails(), (BmcRequest)retriedRequest);
                return (UpdateBuildPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateBuildPipelineStageResponse updateBuildPipelineStage(UpdateBuildPipelineStageRequest request) {
        LOG.trace("Called updateBuildPipelineStage");
        UpdateBuildPipelineStageRequest interceptedRequest = UpdateBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBuildPipelineStageResponse> transformer = UpdateBuildPipelineStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/UpdateBuildPipelineStage");
        return (UpdateBuildPipelineStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBuildPipelineStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBuildPipelineStageDetails(), (BmcRequest)retriedRequest);
                return (UpdateBuildPipelineStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateBuildRunResponse updateBuildRun(UpdateBuildRunRequest request) {
        LOG.trace("Called updateBuildRun");
        UpdateBuildRunRequest interceptedRequest = UpdateBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBuildRunResponse> transformer = UpdateBuildRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/UpdateBuildRun");
        return (UpdateBuildRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBuildRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBuildRunDetails(), (BmcRequest)retriedRequest);
                return (UpdateBuildRunResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        LOG.trace("Called updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/UpdateConnection");
        return (UpdateConnectionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConnectionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConnectionDetails(), (BmcRequest)retriedRequest);
                return (UpdateConnectionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateDeployArtifactResponse updateDeployArtifact(UpdateDeployArtifactRequest request) {
        LOG.trace("Called updateDeployArtifact");
        UpdateDeployArtifactRequest interceptedRequest = UpdateDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeployArtifactResponse> transformer = UpdateDeployArtifactConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/UpdateDeployArtifact");
        return (UpdateDeployArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeployArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeployArtifactDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeployArtifactResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateDeployEnvironmentResponse updateDeployEnvironment(UpdateDeployEnvironmentRequest request) {
        LOG.trace("Called updateDeployEnvironment");
        UpdateDeployEnvironmentRequest interceptedRequest = UpdateDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeployEnvironmentResponse> transformer = UpdateDeployEnvironmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/UpdateDeployEnvironment");
        return (UpdateDeployEnvironmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeployEnvironmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeployEnvironmentDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeployEnvironmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateDeployPipelineResponse updateDeployPipeline(UpdateDeployPipelineRequest request) {
        LOG.trace("Called updateDeployPipeline");
        UpdateDeployPipelineRequest interceptedRequest = UpdateDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeployPipelineResponse> transformer = UpdateDeployPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/UpdateDeployPipeline");
        return (UpdateDeployPipelineResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeployPipelineResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeployPipelineDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeployPipelineResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateDeployStageResponse updateDeployStage(UpdateDeployStageRequest request) {
        LOG.trace("Called updateDeployStage");
        UpdateDeployStageRequest interceptedRequest = UpdateDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployStageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeployStageResponse> transformer = UpdateDeployStageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/UpdateDeployStage");
        return (UpdateDeployStageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeployStageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeployStageDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeployStageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest request) {
        LOG.trace("Called updateDeployment");
        UpdateDeploymentRequest interceptedRequest = UpdateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeploymentResponse> transformer = UpdateDeploymentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/UpdateDeployment");
        return (UpdateDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeploymentDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeploymentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        LOG.trace("Called updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/UpdateProject");
        return (UpdateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProjectDetails(), (BmcRequest)retriedRequest);
                return (UpdateProjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateRepositoryResponse updateRepository(UpdateRepositoryRequest request) {
        LOG.trace("Called updateRepository");
        UpdateRepositoryRequest interceptedRequest = UpdateRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRepositoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRepositoryResponse> transformer = UpdateRepositoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/UpdateRepository");
        return (UpdateRepositoryResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRepositoryResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRepositoryDetails(), (BmcRequest)retriedRequest);
                return (UpdateRepositoryResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateTriggerResponse updateTrigger(UpdateTriggerRequest request) {
        LOG.trace("Called updateTrigger");
        UpdateTriggerRequest interceptedRequest = UpdateTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTriggerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTriggerResponse> transformer = UpdateTriggerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/UpdateTrigger");
        return (UpdateTriggerResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTriggerResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTriggerDetails(), (BmcRequest)retriedRequest);
                return (UpdateTriggerResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DevopsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DevopsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DevopsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DevopsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DevopsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

