/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetObjectRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String filePath;
    private String refName;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "filePath", "refName", "opcRequestId"})
    GetObjectRequest(String repositoryId, String filePath, String refName, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.filePath = filePath;
        this.refName = refName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).filePath(this.filePath).refName(this.refName).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetObjectRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", filePath=" + this.getFilePath() + ", refName=" + this.getRefName() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetObjectRequest)) {
            return false;
        }
        GetObjectRequest other = (GetObjectRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$refName = this.getRefName();
        String other$refName = other.getRefName();
        if (this$refName == null ? other$refName != null : !this$refName.equals(other$refName)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetObjectRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $refName = this.getRefName();
        result = result * 59 + ($refName == null ? 43 : $refName.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getRefName() {
        return this.refName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetObjectRequest, Void> {
        private String repositoryId;
        private String filePath;
        private String refName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetObjectRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.filePath(o.getFilePath());
            this.refName(o.getRefName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetObjectRequest build() {
            GetObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetObjectRequest buildWithoutInvocationCallback() {
            return new GetObjectRequest(this.repositoryId, this.filePath, this.refName, this.opcRequestId);
        }

        public String toString() {
            return "GetObjectRequest.Builder(repositoryId=" + this.repositoryId + ", filePath=" + this.filePath + ", refName=" + this.refName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

