/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListRefsRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private RefType refType;
    private String commitId;
    private Integer limit;
    private String page;
    private String refName;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "refType", "commitId", "limit", "page", "refName", "sortOrder", "sortBy", "opcRequestId"})
    ListRefsRequest(String repositoryId, RefType refType, String commitId, Integer limit, String page, String refName, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.refType = refType;
        this.commitId = commitId;
        this.limit = limit;
        this.page = page;
        this.refName = refName;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).refType(this.refType).commitId(this.commitId).limit(this.limit).page(this.page).refName(this.refName).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListRefsRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", refType=" + (Object)((Object)this.getRefType()) + ", commitId=" + this.getCommitId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", refName=" + this.getRefName() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRefsRequest)) {
            return false;
        }
        ListRefsRequest other = (ListRefsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        RefType this$refType = this.getRefType();
        RefType other$refType = other.getRefType();
        if (this$refType == null ? other$refType != null : !((Object)((Object)this$refType)).equals((Object)other$refType)) {
            return false;
        }
        String this$commitId = this.getCommitId();
        String other$commitId = other.getCommitId();
        if (this$commitId == null ? other$commitId != null : !this$commitId.equals(other$commitId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$refName = this.getRefName();
        String other$refName = other.getRefName();
        if (this$refName == null ? other$refName != null : !this$refName.equals(other$refName)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListRefsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        RefType $refType = this.getRefType();
        result = result * 59 + ($refType == null ? 43 : ((Object)((Object)$refType)).hashCode());
        String $commitId = this.getCommitId();
        result = result * 59 + ($commitId == null ? 43 : $commitId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $refName = this.getRefName();
        result = result * 59 + ($refName == null ? 43 : $refName.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public RefType getRefType() {
        return this.refType;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getRefName() {
        return this.refName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRefsRequest, Void> {
        private String repositoryId;
        private RefType refType;
        private String commitId;
        private Integer limit;
        private String page;
        private String refName;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRefsRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.refType(o.getRefType());
            this.commitId(o.getCommitId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.refName(o.getRefName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRefsRequest build() {
            ListRefsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder refType(RefType refType) {
            this.refType = refType;
            return this;
        }

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListRefsRequest buildWithoutInvocationCallback() {
            return new ListRefsRequest(this.repositoryId, this.refType, this.commitId, this.limit, this.page, this.refName, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListRefsRequest.Builder(repositoryId=" + this.repositoryId + ", refType=" + (Object)((Object)this.refType) + ", commitId=" + this.commitId + ", limit=" + this.limit + ", page=" + this.page + ", refName=" + this.refName + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        RefType("refType"),
        RefName("refName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RefType {
        Branch("BRANCH"),
        Tag("TAG");

        private final String value;
        private static Map<String, RefType> map;

        private RefType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RefType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RefType: " + key);
        }

        static {
            map = new HashMap<String, RefType>();
            for (RefType v : RefType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

