/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseManagementConfig {
    @JsonProperty(value="databaseManagementStatus")
    private final DatabaseManagementStatus databaseManagementStatus;
    @JsonProperty(value="databaseManagementConnectionId")
    private final String databaseManagementConnectionId;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseManagementStatus(this.databaseManagementStatus).databaseManagementConnectionId(this.databaseManagementConnectionId).licenseModel(this.licenseModel);
    }

    public DatabaseManagementStatus getDatabaseManagementStatus() {
        return this.databaseManagementStatus;
    }

    public String getDatabaseManagementConnectionId() {
        return this.databaseManagementConnectionId;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseManagementConfig)) {
            return false;
        }
        DatabaseManagementConfig other = (DatabaseManagementConfig)o;
        DatabaseManagementStatus this$databaseManagementStatus = this.getDatabaseManagementStatus();
        DatabaseManagementStatus other$databaseManagementStatus = other.getDatabaseManagementStatus();
        if (this$databaseManagementStatus == null ? other$databaseManagementStatus != null : !((Object)((Object)this$databaseManagementStatus)).equals((Object)other$databaseManagementStatus)) {
            return false;
        }
        String this$databaseManagementConnectionId = this.getDatabaseManagementConnectionId();
        String other$databaseManagementConnectionId = other.getDatabaseManagementConnectionId();
        if (this$databaseManagementConnectionId == null ? other$databaseManagementConnectionId != null : !this$databaseManagementConnectionId.equals(other$databaseManagementConnectionId)) {
            return false;
        }
        LicenseModel this$licenseModel = this.getLicenseModel();
        LicenseModel other$licenseModel = other.getLicenseModel();
        if (this$licenseModel == null ? other$licenseModel != null : !((Object)((Object)this$licenseModel)).equals((Object)other$licenseModel)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatabaseManagementStatus $databaseManagementStatus = this.getDatabaseManagementStatus();
        result = result * 59 + ($databaseManagementStatus == null ? 43 : ((Object)((Object)$databaseManagementStatus)).hashCode());
        String $databaseManagementConnectionId = this.getDatabaseManagementConnectionId();
        result = result * 59 + ($databaseManagementConnectionId == null ? 43 : $databaseManagementConnectionId.hashCode());
        LicenseModel $licenseModel = this.getLicenseModel();
        result = result * 59 + ($licenseModel == null ? 43 : ((Object)((Object)$licenseModel)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseManagementConfig(databaseManagementStatus=" + (Object)((Object)this.getDatabaseManagementStatus()) + ", databaseManagementConnectionId=" + this.getDatabaseManagementConnectionId() + ", licenseModel=" + (Object)((Object)this.getLicenseModel()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"databaseManagementStatus", "databaseManagementConnectionId", "licenseModel"})
    @Deprecated
    public DatabaseManagementConfig(DatabaseManagementStatus databaseManagementStatus, String databaseManagementConnectionId, LicenseModel licenseModel) {
        this.databaseManagementStatus = databaseManagementStatus;
        this.databaseManagementConnectionId = databaseManagementConnectionId;
        this.licenseModel = licenseModel;
    }

    public static enum LicenseModel {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseManagementStatus {
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        NotEnabled("NOT_ENABLED"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseManagementStatus> map;

        private DatabaseManagementStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseManagementStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseManagementStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseManagementStatus.class);
            map = new HashMap<String, DatabaseManagementStatus>();
            for (DatabaseManagementStatus v : DatabaseManagementStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseManagementStatus")
        private DatabaseManagementStatus databaseManagementStatus;
        @JsonProperty(value="databaseManagementConnectionId")
        private String databaseManagementConnectionId;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseManagementStatus(DatabaseManagementStatus databaseManagementStatus) {
            this.databaseManagementStatus = databaseManagementStatus;
            this.__explicitlySet__.add("databaseManagementStatus");
            return this;
        }

        public Builder databaseManagementConnectionId(String databaseManagementConnectionId) {
            this.databaseManagementConnectionId = databaseManagementConnectionId;
            this.__explicitlySet__.add("databaseManagementConnectionId");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public DatabaseManagementConfig build() {
            DatabaseManagementConfig __instance__ = new DatabaseManagementConfig(this.databaseManagementStatus, this.databaseManagementConnectionId, this.licenseModel);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DatabaseManagementConfig o) {
            Builder copiedBuilder = this.databaseManagementStatus(o.getDatabaseManagementStatus()).databaseManagementConnectionId(o.getDatabaseManagementConnectionId()).licenseModel(o.getLicenseModel());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DatabaseManagementConfig.Builder(databaseManagementStatus=" + (Object)((Object)this.databaseManagementStatus) + ", databaseManagementConnectionId=" + this.databaseManagementConnectionId + ", licenseModel=" + (Object)((Object)this.licenseModel) + ")";
        }
    }
}

