/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.BackupDestinationDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbBackupConfig {
    @JsonProperty(value="autoBackupEnabled")
    private final Boolean autoBackupEnabled;
    @JsonProperty(value="recoveryWindowInDays")
    private final Integer recoveryWindowInDays;
    @JsonProperty(value="autoBackupWindow")
    private final AutoBackupWindow autoBackupWindow;
    @JsonProperty(value="backupDestinationDetails")
    private final List<BackupDestinationDetails> backupDestinationDetails;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().autoBackupEnabled(this.autoBackupEnabled).recoveryWindowInDays(this.recoveryWindowInDays).autoBackupWindow(this.autoBackupWindow).backupDestinationDetails(this.backupDestinationDetails);
    }

    public Boolean getAutoBackupEnabled() {
        return this.autoBackupEnabled;
    }

    public Integer getRecoveryWindowInDays() {
        return this.recoveryWindowInDays;
    }

    public AutoBackupWindow getAutoBackupWindow() {
        return this.autoBackupWindow;
    }

    public List<BackupDestinationDetails> getBackupDestinationDetails() {
        return this.backupDestinationDetails;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbBackupConfig)) {
            return false;
        }
        DbBackupConfig other = (DbBackupConfig)o;
        Boolean this$autoBackupEnabled = this.getAutoBackupEnabled();
        Boolean other$autoBackupEnabled = other.getAutoBackupEnabled();
        if (this$autoBackupEnabled == null ? other$autoBackupEnabled != null : !((Object)this$autoBackupEnabled).equals(other$autoBackupEnabled)) {
            return false;
        }
        Integer this$recoveryWindowInDays = this.getRecoveryWindowInDays();
        Integer other$recoveryWindowInDays = other.getRecoveryWindowInDays();
        if (this$recoveryWindowInDays == null ? other$recoveryWindowInDays != null : !((Object)this$recoveryWindowInDays).equals(other$recoveryWindowInDays)) {
            return false;
        }
        AutoBackupWindow this$autoBackupWindow = this.getAutoBackupWindow();
        AutoBackupWindow other$autoBackupWindow = other.getAutoBackupWindow();
        if (this$autoBackupWindow == null ? other$autoBackupWindow != null : !((Object)((Object)this$autoBackupWindow)).equals((Object)other$autoBackupWindow)) {
            return false;
        }
        List<BackupDestinationDetails> this$backupDestinationDetails = this.getBackupDestinationDetails();
        List<BackupDestinationDetails> other$backupDestinationDetails = other.getBackupDestinationDetails();
        if (this$backupDestinationDetails == null ? other$backupDestinationDetails != null : !((Object)this$backupDestinationDetails).equals(other$backupDestinationDetails)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoBackupEnabled = this.getAutoBackupEnabled();
        result = result * 59 + ($autoBackupEnabled == null ? 43 : ((Object)$autoBackupEnabled).hashCode());
        Integer $recoveryWindowInDays = this.getRecoveryWindowInDays();
        result = result * 59 + ($recoveryWindowInDays == null ? 43 : ((Object)$recoveryWindowInDays).hashCode());
        AutoBackupWindow $autoBackupWindow = this.getAutoBackupWindow();
        result = result * 59 + ($autoBackupWindow == null ? 43 : ((Object)((Object)$autoBackupWindow)).hashCode());
        List<BackupDestinationDetails> $backupDestinationDetails = this.getBackupDestinationDetails();
        result = result * 59 + ($backupDestinationDetails == null ? 43 : ((Object)$backupDestinationDetails).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DbBackupConfig(autoBackupEnabled=" + this.getAutoBackupEnabled() + ", recoveryWindowInDays=" + this.getRecoveryWindowInDays() + ", autoBackupWindow=" + (Object)((Object)this.getAutoBackupWindow()) + ", backupDestinationDetails=" + this.getBackupDestinationDetails() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"autoBackupEnabled", "recoveryWindowInDays", "autoBackupWindow", "backupDestinationDetails"})
    @Deprecated
    public DbBackupConfig(Boolean autoBackupEnabled, Integer recoveryWindowInDays, AutoBackupWindow autoBackupWindow, List<BackupDestinationDetails> backupDestinationDetails) {
        this.autoBackupEnabled = autoBackupEnabled;
        this.recoveryWindowInDays = recoveryWindowInDays;
        this.autoBackupWindow = autoBackupWindow;
        this.backupDestinationDetails = backupDestinationDetails;
    }

    public static enum AutoBackupWindow {
        SlotOne("SLOT_ONE"),
        SlotTwo("SLOT_TWO"),
        SlotThree("SLOT_THREE"),
        SlotFour("SLOT_FOUR"),
        SlotFive("SLOT_FIVE"),
        SlotSix("SLOT_SIX"),
        SlotSeven("SLOT_SEVEN"),
        SlotEight("SLOT_EIGHT"),
        SlotNine("SLOT_NINE"),
        SlotTen("SLOT_TEN"),
        SlotEleven("SLOT_ELEVEN"),
        SlotTwelve("SLOT_TWELVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AutoBackupWindow> map;

        private AutoBackupWindow(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutoBackupWindow create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AutoBackupWindow', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AutoBackupWindow.class);
            map = new HashMap<String, AutoBackupWindow>();
            for (AutoBackupWindow v : AutoBackupWindow.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="autoBackupEnabled")
        private Boolean autoBackupEnabled;
        @JsonProperty(value="recoveryWindowInDays")
        private Integer recoveryWindowInDays;
        @JsonProperty(value="autoBackupWindow")
        private AutoBackupWindow autoBackupWindow;
        @JsonProperty(value="backupDestinationDetails")
        private List<BackupDestinationDetails> backupDestinationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder autoBackupEnabled(Boolean autoBackupEnabled) {
            this.autoBackupEnabled = autoBackupEnabled;
            this.__explicitlySet__.add("autoBackupEnabled");
            return this;
        }

        public Builder recoveryWindowInDays(Integer recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            this.__explicitlySet__.add("recoveryWindowInDays");
            return this;
        }

        public Builder autoBackupWindow(AutoBackupWindow autoBackupWindow) {
            this.autoBackupWindow = autoBackupWindow;
            this.__explicitlySet__.add("autoBackupWindow");
            return this;
        }

        public Builder backupDestinationDetails(List<BackupDestinationDetails> backupDestinationDetails) {
            this.backupDestinationDetails = backupDestinationDetails;
            this.__explicitlySet__.add("backupDestinationDetails");
            return this;
        }

        public DbBackupConfig build() {
            DbBackupConfig __instance__ = new DbBackupConfig(this.autoBackupEnabled, this.recoveryWindowInDays, this.autoBackupWindow, this.backupDestinationDetails);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DbBackupConfig o) {
            Builder copiedBuilder = this.autoBackupEnabled(o.getAutoBackupEnabled()).recoveryWindowInDays(o.getRecoveryWindowInDays()).autoBackupWindow(o.getAutoBackupWindow()).backupDestinationDetails(o.getBackupDestinationDetails());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DbBackupConfig.Builder(autoBackupEnabled=" + this.autoBackupEnabled + ", recoveryWindowInDays=" + this.recoveryWindowInDays + ", autoBackupWindow=" + (Object)((Object)this.autoBackupWindow) + ", backupDestinationDetails=" + this.backupDestinationDetails + ")";
        }
    }
}

