/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.KeyStoreAssociatedDatabaseDetails;
import com.oracle.bmc.database.model.KeyStoreTypeDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KeyStore {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="typeDetails")
    private final KeyStoreTypeDetails typeDetails;
    @JsonProperty(value="associatedDatabases")
    private final List<KeyStoreAssociatedDatabaseDetails> associatedDatabases;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).displayName(this.displayName).timeCreated(this.timeCreated).lifecycleState(this.lifecycleState).lifecycleDetails(this.lifecycleDetails).typeDetails(this.typeDetails).associatedDatabases(this.associatedDatabases).freeformTags(this.freeformTags).definedTags(this.definedTags);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public KeyStoreTypeDetails getTypeDetails() {
        return this.typeDetails;
    }

    public List<KeyStoreAssociatedDatabaseDetails> getAssociatedDatabases() {
        return this.associatedDatabases;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyStore)) {
            return false;
        }
        KeyStore other = (KeyStore)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        KeyStoreTypeDetails this$typeDetails = this.getTypeDetails();
        KeyStoreTypeDetails other$typeDetails = other.getTypeDetails();
        if (this$typeDetails == null ? other$typeDetails != null : !((Object)this$typeDetails).equals(other$typeDetails)) {
            return false;
        }
        List<KeyStoreAssociatedDatabaseDetails> this$associatedDatabases = this.getAssociatedDatabases();
        List<KeyStoreAssociatedDatabaseDetails> other$associatedDatabases = other.getAssociatedDatabases();
        if (this$associatedDatabases == null ? other$associatedDatabases != null : !((Object)this$associatedDatabases).equals(other$associatedDatabases)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        KeyStoreTypeDetails $typeDetails = this.getTypeDetails();
        result = result * 59 + ($typeDetails == null ? 43 : ((Object)$typeDetails).hashCode());
        List<KeyStoreAssociatedDatabaseDetails> $associatedDatabases = this.getAssociatedDatabases();
        result = result * 59 + ($associatedDatabases == null ? 43 : ((Object)$associatedDatabases).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "KeyStore(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", displayName=" + this.getDisplayName() + ", timeCreated=" + this.getTimeCreated() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecycleDetails=" + this.getLifecycleDetails() + ", typeDetails=" + this.getTypeDetails() + ", associatedDatabases=" + this.getAssociatedDatabases() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "displayName", "timeCreated", "lifecycleState", "lifecycleDetails", "typeDetails", "associatedDatabases", "freeformTags", "definedTags"})
    @Deprecated
    public KeyStore(String id, String compartmentId, String displayName, Date timeCreated, LifecycleState lifecycleState, String lifecycleDetails, KeyStoreTypeDetails typeDetails, List<KeyStoreAssociatedDatabaseDetails> associatedDatabases, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.typeDetails = typeDetails;
        this.associatedDatabases = associatedDatabases;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static enum LifecycleState {
        Active("ACTIVE"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="typeDetails")
        private KeyStoreTypeDetails typeDetails;
        @JsonProperty(value="associatedDatabases")
        private List<KeyStoreAssociatedDatabaseDetails> associatedDatabases;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder typeDetails(KeyStoreTypeDetails typeDetails) {
            this.typeDetails = typeDetails;
            this.__explicitlySet__.add("typeDetails");
            return this;
        }

        public Builder associatedDatabases(List<KeyStoreAssociatedDatabaseDetails> associatedDatabases) {
            this.associatedDatabases = associatedDatabases;
            this.__explicitlySet__.add("associatedDatabases");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public KeyStore build() {
            KeyStore __instance__ = new KeyStore(this.id, this.compartmentId, this.displayName, this.timeCreated, this.lifecycleState, this.lifecycleDetails, this.typeDetails, this.associatedDatabases, this.freeformTags, this.definedTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(KeyStore o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).displayName(o.getDisplayName()).timeCreated(o.getTimeCreated()).lifecycleState(o.getLifecycleState()).lifecycleDetails(o.getLifecycleDetails()).typeDetails(o.getTypeDetails()).associatedDatabases(o.getAssociatedDatabases()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "KeyStore.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", displayName=" + this.displayName + ", timeCreated=" + this.timeCreated + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleDetails=" + this.lifecycleDetails + ", typeDetails=" + this.typeDetails + ", associatedDatabases=" + this.associatedDatabases + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ")";
        }
    }
}

