/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConsoleConnectionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleConnectionId;

    @ConstructorProperties(value={"dbNodeId", "consoleConnectionId"})
    GetConsoleConnectionRequest(String dbNodeId, String consoleConnectionId) {
        this.dbNodeId = dbNodeId;
        this.consoleConnectionId = consoleConnectionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).consoleConnectionId(this.consoleConnectionId);
    }

    public String toString() {
        return "GetConsoleConnectionRequest(super=" + super.toString() + ", dbNodeId=" + this.getDbNodeId() + ", consoleConnectionId=" + this.getConsoleConnectionId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetConsoleConnectionRequest)) {
            return false;
        }
        GetConsoleConnectionRequest other = (GetConsoleConnectionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbNodeId = this.getDbNodeId();
        String other$dbNodeId = other.getDbNodeId();
        if (this$dbNodeId == null ? other$dbNodeId != null : !this$dbNodeId.equals(other$dbNodeId)) {
            return false;
        }
        String this$consoleConnectionId = this.getConsoleConnectionId();
        String other$consoleConnectionId = other.getConsoleConnectionId();
        return !(this$consoleConnectionId == null ? other$consoleConnectionId != null : !this$consoleConnectionId.equals(other$consoleConnectionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetConsoleConnectionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbNodeId = this.getDbNodeId();
        result = result * 59 + ($dbNodeId == null ? 43 : $dbNodeId.hashCode());
        String $consoleConnectionId = this.getConsoleConnectionId();
        result = result * 59 + ($consoleConnectionId == null ? 43 : $consoleConnectionId.hashCode());
        return result;
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleConnectionRequest, Void> {
        private String dbNodeId;
        private String consoleConnectionId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleConnectionRequest build() {
            GetConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public GetConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new GetConsoleConnectionRequest(this.dbNodeId, this.consoleConnectionId);
        }

        public String toString() {
            return "GetConsoleConnectionRequest.Builder(dbNodeId=" + this.dbNodeId + ", consoleConnectionId=" + this.consoleConnectionId + ")";
        }
    }
}

