/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.PdbConversionHistoryEntrySummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListPdbConversionHistoryEntriesRequest
extends BmcRequest<Void> {
    private String databaseId;
    private PdbConversionHistoryEntrySummary.Action pdbConversionAction;
    private PdbConversionHistoryEntrySummary.LifecycleState lifecycleState;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"databaseId", "pdbConversionAction", "lifecycleState", "sortBy", "sortOrder", "opcRequestId", "limit", "page"})
    ListPdbConversionHistoryEntriesRequest(String databaseId, PdbConversionHistoryEntrySummary.Action pdbConversionAction, PdbConversionHistoryEntrySummary.LifecycleState lifecycleState, SortBy sortBy, SortOrder sortOrder, String opcRequestId, Integer limit, String page) {
        this.databaseId = databaseId;
        this.pdbConversionAction = pdbConversionAction;
        this.lifecycleState = lifecycleState;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).pdbConversionAction(this.pdbConversionAction).lifecycleState(this.lifecycleState).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public String toString() {
        return "ListPdbConversionHistoryEntriesRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", pdbConversionAction=" + (Object)((Object)this.getPdbConversionAction()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", opcRequestId=" + this.getOpcRequestId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPdbConversionHistoryEntriesRequest)) {
            return false;
        }
        ListPdbConversionHistoryEntriesRequest other = (ListPdbConversionHistoryEntriesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        PdbConversionHistoryEntrySummary.Action this$pdbConversionAction = this.getPdbConversionAction();
        PdbConversionHistoryEntrySummary.Action other$pdbConversionAction = other.getPdbConversionAction();
        if (this$pdbConversionAction == null ? other$pdbConversionAction != null : !((Object)((Object)this$pdbConversionAction)).equals((Object)other$pdbConversionAction)) {
            return false;
        }
        PdbConversionHistoryEntrySummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        PdbConversionHistoryEntrySummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListPdbConversionHistoryEntriesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        PdbConversionHistoryEntrySummary.Action $pdbConversionAction = this.getPdbConversionAction();
        result = result * 59 + ($pdbConversionAction == null ? 43 : ((Object)((Object)$pdbConversionAction)).hashCode());
        PdbConversionHistoryEntrySummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public PdbConversionHistoryEntrySummary.Action getPdbConversionAction() {
        return this.pdbConversionAction;
    }

    public PdbConversionHistoryEntrySummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPdbConversionHistoryEntriesRequest, Void> {
        private String databaseId;
        private PdbConversionHistoryEntrySummary.Action pdbConversionAction;
        private PdbConversionHistoryEntrySummary.LifecycleState lifecycleState;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPdbConversionHistoryEntriesRequest o) {
            this.databaseId(o.getDatabaseId());
            this.pdbConversionAction(o.getPdbConversionAction());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPdbConversionHistoryEntriesRequest build() {
            ListPdbConversionHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder pdbConversionAction(PdbConversionHistoryEntrySummary.Action pdbConversionAction) {
            this.pdbConversionAction = pdbConversionAction;
            return this;
        }

        public Builder lifecycleState(PdbConversionHistoryEntrySummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListPdbConversionHistoryEntriesRequest buildWithoutInvocationCallback() {
            return new ListPdbConversionHistoryEntriesRequest(this.databaseId, this.pdbConversionAction, this.lifecycleState, this.sortBy, this.sortOrder, this.opcRequestId, this.limit, this.page);
        }

        public String toString() {
            return "ListPdbConversionHistoryEntriesRequest.Builder(databaseId=" + this.databaseId + ", pdbConversionAction=" + (Object)((Object)this.pdbConversionAction) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timestarted("TIMESTARTED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

