/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Set;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystem$Environment;
import org.openide.filesystems.FileSystem$HtmlStatus;
import org.openide.filesystems.FileSystem$Status;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.StatusDecorator;
import org.openide.modules.PatchFor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

@PatchFor(value=FileSystem.class)
public abstract class FileSystemCompat {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    @Deprecated
    static final String PROP_CAPABILITIES = "capabilities";
    private boolean hidden = false;
    @Deprecated
    private Object capability;
    private transient PropertyChangeListener capabilityListener;
    private FileSystem$Status status;

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public SystemAction[] getActions(Set<FileObject> foSet) {
        return this.getActions();
    }

    @Deprecated
    public void prepareEnvironment(FileSystem$Environment env) throws EnvironmentNotSupportedException {
        FileSystemCompat o = this;
        throw new EnvironmentNotSupportedException((FileSystem)o);
    }

    public static FileSystemCompat compat(FileSystem fs) {
        FileSystem o = fs;
        return (FileSystemCompat)o;
    }

    private FileSystem fs() {
        FileSystemCompat o = this;
        return (FileSystem)o;
    }

    @Deprecated
    public final FileSystemCapability getCapability() {
        if (this.capability == null) {
            this.capability = new FileSystemCapability.Bean();
            ((FileSystemCapability)this.capability).addPropertyChangeListener(this.getCapabilityChangeListener());
        }
        return (FileSystemCapability)this.capability;
    }

    @Deprecated
    protected final void setCapability(FileSystemCapability capability) {
        if (this.capability != null) {
            ((FileSystemCapability)this.capability).removePropertyChangeListener(this.getCapabilityChangeListener());
        }
        this.capability = capability;
        if (this.capability != null) {
            ((FileSystemCapability)this.capability).addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    private synchronized PropertyChangeListener getCapabilityChangeListener() {
        if (this.capabilityListener == null) {
            this.capabilityListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FileSystemCompat.this.fs().firePropertyChange(FileSystemCompat.PROP_CAPABILITIES, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            };
        }
        return this.capabilityListener;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.capability != null) {
            ((FileSystemCapability)this.capability).addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    @Deprecated
    public final void setHidden(boolean hide) {
        if (hide != this.hidden) {
            this.hidden = hide;
            this.fs().firePropertyChange("hidden", (Object)(!hide ? Boolean.TRUE : Boolean.FALSE), (Object)(hide ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    @Deprecated
    public final boolean isHidden() {
        return this.hidden;
    }

    @Deprecated
    protected boolean isPersistent() {
        return false;
    }

    public FileSystem$Status getStatus() {
        if (this.status == null) {
            this.status = new StatusImpl(this.fs().getDecorator());
        }
        return this.status;
    }

    static {
        try {
            Field f = FileSystem.class.getDeclaredField("SFS_STATUS");
            f.setAccessible(true);
            StatusDecorator del = (StatusDecorator)f.get(null);
            f.set(null, new SystemStatus(del));
        }
        catch (NoSuchFieldException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class StatusImpl
    implements FileSystem$Status,
    FileSystem$HtmlStatus {
        private final StatusDecorator decorator;
        private final Method annotateIconDel;

        public StatusImpl(StatusDecorator decorator) {
            this.decorator = decorator;
            Method m = null;
            try {
                m = decorator.getClass().getMethod("annotateIcon", Image.class, Integer.TYPE, Set.class);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.annotateIconDel = m;
        }

        @Override
        public String annotateName(String name, Set<? extends FileObject> files) {
            return this.decorator.annotateName(name, files);
        }

        @Override
        public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
            if (this.annotateIconDel == null) {
                return icon;
            }
            try {
                return (Image)this.annotateIconDel.invoke((Object)this.decorator, icon, iconType, files);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return icon;
        }

        @Override
        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            return this.decorator.annotateNameHtml(name, files);
        }
    }

    private static class SystemStatus
    implements FileSystem$Status,
    StatusDecorator {
        private final StatusDecorator delegate;

        public SystemStatus(StatusDecorator delegate) {
            this.delegate = delegate;
        }

        @Override
        public String annotateName(String name, Set<? extends FileObject> files) {
            return this.delegate.annotateName(name, files);
        }

        @Override
        public Image annotateIcon(Image im, int type, Set<? extends FileObject> files) {
            for (FileObject fileObject : files) {
                Image img = this.annotateIcon(fileObject, type);
                if (img == null) continue;
                return img;
            }
            return im;
        }

        private Image annotateIcon(FileObject fo, int type) {
            String base;
            Object value;
            String attr = null;
            if (type == 1) {
                attr = "SystemFileSystem.icon";
            } else if (type == 2) {
                attr = "SystemFileSystem.icon32";
            }
            if (attr != null && (value = fo.getAttribute(attr)) != null) {
                if (value instanceof URL) {
                    return Toolkit.getDefaultToolkit().getImage((URL)value);
                }
                if (value instanceof Image) {
                    return (Image)value;
                }
                FileSystem.LOG.warning("Attribute " + attr + " on " + fo + " expected to be a URL or Image; was: " + value);
            }
            if ((base = (String)fo.getAttribute("iconBase")) != null) {
                if (type == 1) {
                    return ImageUtilities.loadImage((String)base, (boolean)true);
                }
                if (type == 2) {
                    return ImageUtilities.loadImage((String)SystemStatus.insertBeforeSuffix(base, "_32"), (boolean)true);
                }
            }
            return null;
        }

        private static String insertBeforeSuffix(String path, String toInsert) {
            String withoutSuffix = path;
            String suffix = "";
            if (path.lastIndexOf(46) >= 0) {
                withoutSuffix = path.substring(0, path.lastIndexOf(46));
                suffix = path.substring(path.lastIndexOf(46), path.length());
            }
            return withoutSuffix + toInsert + suffix;
        }

        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            return name;
        }
    }
}

