/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ConstantDeclaration
extends BodyDeclaration {
    private final ArrayList<Identifier> names = new ArrayList();
    private final ArrayList<Expression> initializers = new ArrayList();
    private final boolean isGlobal;

    private ConstantDeclaration(int start, int end, List<Identifier> names, List<Expression> initializers, boolean isGlobal) {
        super(start, end, 32);
        if (names == null || initializers == null || names.size() != initializers.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<Identifier> iteratorNames = names.iterator();
        Iterator<Expression> iteratorInitializers = initializers.iterator();
        while (iteratorNames.hasNext()) {
            Identifier identifier = iteratorNames.next();
            this.names.add(identifier);
            Expression initializer = iteratorInitializers.next();
            this.initializers.add(initializer);
        }
        this.isGlobal = isGlobal;
    }

    private ConstantDeclaration(int start, int end, int modifier, List<Identifier> names, List<Expression> initializers, boolean isGlobal, List<Attribute> attributes) {
        super(start, end, modifier, false, attributes);
        this.names.addAll(names);
        this.initializers.addAll(initializers);
        this.isGlobal = isGlobal;
    }

    public ConstantDeclaration(int start, int end, int modifier, List variablesAndDefaults, boolean isGlobal) {
        super(start, end, modifier);
        if (variablesAndDefaults == null || variablesAndDefaults.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (ASTNode[] element : variablesAndDefaults) {
            assert (element != null && element.length == 2 && element[0] != null && element[1] != null);
            this.names.add((Identifier)element[0]);
            this.initializers.add((Expression)element[1]);
        }
        this.isGlobal = isGlobal;
    }

    public static ConstantDeclaration create(ConstantDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new ConstantDeclaration(start, declaration.getEndOffset(), declaration.getModifier(), declaration.getNames(), declaration.getInitializers(), declaration.isGlobal(), attributes);
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public List<Expression> getInitializers() {
        return Collections.unmodifiableList(this.initializers);
    }

    public List<Identifier> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getInitializers()) {
            sb.append(expression).append(",");
        }
        return sbAttributes.toString() + this.getModifierString() + "const " + sb;
    }
}

