/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.netbeans.junit.diff.Diff;

public class NativeDiff
implements Diff {
    String diffcmd;

    public void setCmdLine(String cmdLine) {
        this.diffcmd = cmdLine;
    }

    public String getCmdLine() {
        return this.diffcmd;
    }

    @Override
    public boolean diff(File first, File second, File diff) throws IOException {
        boolean result = null != diff ? this.diff(first.getAbsolutePath(), second.getAbsolutePath(), diff.getAbsolutePath()) : this.diff(first.getAbsolutePath(), second.getAbsolutePath(), null);
        return result;
    }

    @Override
    public boolean diff(String first, String second, String diff) throws IOException {
        Process prs = null;
        File diffFile = null;
        diffFile = null == diff ? File.createTempFile("~diff", "tmp~") : new File(diff);
        FileOutputStream fos = new FileOutputStream(diffFile);
        prs = Runtime.getRuntime().exec(this.prepareCommand(new File(first).getAbsolutePath(), new File(second).getAbsolutePath()));
        StreamGobbler outputGobbler = new StreamGobbler(prs.getInputStream(), fos);
        outputGobbler.start();
        try {
            prs.waitFor();
            outputGobbler.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (0 == prs.exitValue() || null == diff) {
            diffFile.delete();
        }
        return prs.exitValue() != 0;
    }

    private String[] prepareCommand(String firstFile, String secondFile) {
        StringTokenizer tok = new StringTokenizer(this.diffcmd);
        int tokensCount = tok.countTokens();
        String[] cmdarray = new String[tokensCount];
        for (int i = 0; i < tokensCount; ++i) {
            String token = tok.nextToken();
            cmdarray[i] = token.equals("%TESTFILE%") ? firstFile : (token.equals("%PASSFILE%") ? secondFile : token);
        }
        return cmdarray;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        OutputStream os;

        StreamGobbler(InputStream is, OutputStream redirect) {
            this.is = is;
            this.os = redirect;
        }

        @Override
        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                }
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

