/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.debuggingview;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.ThreadsCollector;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.CachedChildrenTreeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.PasteType;

public class DebuggingModel
extends CachedChildrenTreeModel
implements ExtendedNodeModel,
TableModel,
TreeExpansionModelFilter,
CPPLiteDebugger.StateListener,
ThreadsCollector.StateListener {
    private static final String RUNNING_THREAD_ICON = "org/netbeans/modules/debugger/resources/threadsView/thread_running_16.png";
    private static final String SUSPENDED_THREAD_ICON = "org/netbeans/modules/debugger/resources/threadsView/thread_suspended_16.png";
    private static final String CALL_STACK_ICON = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame.gif";
    private static final String CURRENT_CALL_STACK_ICON = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame.gif";
    private final CPPLiteDebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final Map<CPPThread, ThreadStateListener> threadStateListeners = new WeakHashMap<CPPThread, ThreadStateListener>();
    private final Reference<CPPThread> lastCurrentThreadRef = new WeakReference<Object>(null);
    private final Reference<CPPFrame> lastCurrentFrameRef = new WeakReference<Object>(null);
    private final Set<Object> expandedExplicitly = new WeakSet();
    private final Set<Object> collapsedExplicitly = new WeakSet();
    private final RequestProcessor RP = new RequestProcessor("Debugging Tree View Refresh", 1);

    public DebuggingModel(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)contextProvider.lookupFirst(null, CPPLiteDebugger.class);
        this.debugger.addStateListener((CPPLiteDebugger.StateListener)WeakListeners.create(CPPLiteDebugger.StateListener.class, (EventListener)this, (Object)this.debugger));
        this.debugger.getThreads().addStateListener((ThreadsCollector.StateListener)WeakListeners.create(ThreadsCollector.StateListener.class, (EventListener)this, (Object)this.debugger.getThreads()));
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            return true;
        }
        if (node instanceof CPPThread) {
            CPPThread thread = (CPPThread)node;
            return !thread.isSuspended();
        }
        return false;
    }

    protected Object[] computeChildren(Object parent) throws UnknownTypeException {
        if (parent == "Root") {
            Object[] threads;
            for (Object t : threads = this.debugger.getThreads().getAllArray()) {
                this.watchState((CPPThread)t);
            }
            return threads;
        }
        if (parent instanceof CPPThread) {
            Object[] stack = ((CPPThread)parent).getStack();
            if (stack != null) {
                return stack;
            }
            return new Object[0];
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CPPThread) {
            return ((CPPThread)node).getName();
        }
        if (node instanceof CPPFrame) {
            CPPFrame frame = (CPPFrame)node;
            return frame.getName();
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CPPThread) {
            String details = ((CPPThread)node).getDetails();
            if (details == null) {
                details = ((CPPThread)node).getName();
            }
            return details;
        }
        if (node instanceof CPPFrame) {
            CPPFrame frame = (CPPFrame)node;
            return frame.getDescription();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            CPPFrame currentFrame = this.debugger.getCurrentFrame();
            if (node.equals(currentFrame)) {
                return CURRENT_CALL_STACK_ICON;
            }
            return CALL_STACK_ICON;
        }
        if (node instanceof CPPThread) {
            CPPThread thread = (CPPThread)node;
            return thread.isSuspended() ? SUSPENDED_THREAD_ICON : RUNNING_THREAD_ICON;
        }
        if (node == "Root") {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID.equals("suspend")) {
            if (node instanceof CPPThread) {
                CPPThread thread = (CPPThread)node;
                CPPThread.Status status = thread.getStatus();
                switch (status) {
                    case CREATED: {
                        return Boolean.FALSE;
                    }
                    case EXITED: {
                        return null;
                    }
                    case RUNNING: {
                        return Boolean.FALSE;
                    }
                    case SUSPENDED: {
                        return Boolean.TRUE;
                    }
                }
                throw new IllegalStateException("Unknown status: " + (Object)((Object)status));
            }
            return null;
        }
        throw new UnknownTypeException((Object)node.toString());
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(TreeExpansionModel original, Object node) throws UnknownTypeException {
        DebuggingModel debuggingModel = this;
        synchronized (debuggingModel) {
            if (this.expandedExplicitly.contains(node)) {
                return true;
            }
            if (this.collapsedExplicitly.contains(node)) {
                return false;
            }
        }
        if (node instanceof CPPThread) {
            CPPThread thread = (CPPThread)node;
            return thread.isSuspended() && this.debugger.getCurrentThread() == thread;
        }
        return original.isExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object node) {
        DebuggingModel debuggingModel = this;
        synchronized (debuggingModel) {
            this.expandedExplicitly.add(node);
            this.collapsedExplicitly.remove(node);
        }
        if (node instanceof CPPThread) {
            this.fireNodeChange(node, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object node) {
        DebuggingModel debuggingModel = this;
        synchronized (debuggingModel) {
            this.expandedExplicitly.remove(node);
            this.collapsedExplicitly.add(node);
        }
        if (node instanceof CPPThread) {
            this.fireNodeChange(node, 1);
        }
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchState(CPPThread t) {
        Map<CPPThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            if (!this.threadStateListeners.containsKey(t)) {
                this.threadStateListeners.put(t, new ThreadStateListener(t));
            }
        }
    }

    @Override
    public void currentThread(CPPThread thread) {
        if (thread != null) {
            this.fireNodeChange(thread, 19);
        }
    }

    @Override
    public void currentFrame(CPPFrame frame) {
        if (frame != null) {
            this.fireNodeChange(frame.getThread(), 16);
            this.fireNodeChange(frame, 3);
        }
    }

    @Override
    public void suspended(boolean suspended) {
    }

    @Override
    public void finished() {
        this.clearCache();
    }

    private void fireModelChange(ModelEvent me) {
        for (ModelListener ls : this.listeners) {
            ls.modelChanged(me);
        }
    }

    private void fireNodeChange(Object node, int mask) {
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, mask);
        for (ModelListener ml : this.listeners) {
            ml.modelChanged((ModelEvent)event);
        }
    }

    @Override
    public void threadStarted(CPPThread thread) {
        this.refreshCache("Root");
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        this.fireModelChange((ModelEvent)ev);
    }

    @Override
    public void threadDied(CPPThread thread) {
        this.refreshCache("Root");
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        this.fireModelChange((ModelEvent)ev);
    }

    private class ThreadStateListener
    implements PropertyChangeListener {
        private final Reference<CPPThread> tr;
        private RequestProcessor.Task task;
        private final PropertyChangeListener propertyChangeListener;

        public ThreadStateListener(CPPThread t) {
            this.tr = new WeakReference<CPPThread>(t);
            this.propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)t);
            t.addPropertyChangeListener(this.propertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("suspended")) {
                return;
            }
            CPPThread t = this.tr.get();
            if (t == null) {
                return;
            }
            ThreadStateListener threadStateListener = this;
            synchronized (threadStateListener) {
                if (this.task == null) {
                    this.task = DebuggingModel.this.RP.create((Runnable)new Refresher());
                }
                int delay = 100;
                this.task.schedule(delay);
            }
        }

        PropertyChangeListener getThreadPropertyChangeListener() {
            return this.propertyChangeListener;
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            @Override
            public void run() {
                CPPThread thread = (CPPThread)ThreadStateListener.this.tr.get();
                if (thread != null) {
                    try {
                        DebuggingModel.this.recomputeChildren(thread);
                    }
                    catch (UnknownTypeException ex) {
                        DebuggingModel.this.refreshCache(thread);
                    }
                    ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)thread);
                    DebuggingModel.this.fireModelChange((ModelEvent)event);
                }
            }
        }
    }
}

