/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.QualifierVerifier;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.netbeans.modules.web.beans.impl.model.Checker;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

class QualifierChecker
extends RuntimeAnnotationChecker
implements Checker {
    private static final String QUALIFIER_TYPE_ANNOTATION = "javax.inject.Qualifier";
    private static final Set<String> BUILT_IN_QUALIFIERS = new HashSet<String>();
    private boolean isEvent;

    QualifierChecker() {
        this(false);
    }

    QualifierChecker(boolean event) {
        this.isEvent = event;
    }

    static QualifierChecker get() {
        return new QualifierChecker();
    }

    static QualifierChecker get(boolean event) {
        return new QualifierChecker(event);
    }

    @Override
    public boolean check() {
        if (BUILT_IN_QUALIFIERS.contains(this.getElement().getQualifiedName().toString())) {
            return true;
        }
        return super.check();
    }

    @Override
    protected String getAnnotation() {
        return QUALIFIER_TYPE_ANNOTATION;
    }

    @Override
    protected Logger getLogger() {
        return FieldInjectionPointLogic.LOGGER;
    }

    @Override
    public boolean hasReqiredTarget(AnnotationMirror target, Set<ElementType> set) {
        boolean hasRequiredTarget = super.hasReqiredTarget(target, set);
        if (!hasRequiredTarget) {
            if (this.isEvent) {
                this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values. Correct target values are {METHOD, FIELD, PARAMETER, TYPE} or {FIELD, PARAMETER}");
            } else {
                this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values. Correct target values are {METHOD, FIELD, PARAMETER, TYPE}");
            }
        }
        return hasRequiredTarget;
    }

    @Override
    protected TargetVerifier getTargetVerifier() {
        return QualifierVerifier.getInstance(this.isEvent);
    }

    static {
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.Any");
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.New");
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.Default");
        BUILT_IN_QUALIFIERS.add("javax.inject.Named");
    }
}

