/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.function.BiConsumer;
import javax.tools.JavaFileObject;

public class TypeEnter
implements Symbol.Completer {
    protected static final Context.Key<TypeEnter> typeEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Names names;
    private final Enter enter;
    private final MemberEnter memberEnter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final Todo todo;
    private final Annotate annotate;
    private final TypeAnnotations typeAnnotations;
    private final Types types;
    private final DeferredLintHandler deferredLintHandler;
    private final Lint lint;
    private final TypeEnvs typeEnvs;
    private final Dependencies dependencies;
    private final Preview preview;
    boolean allowTypeAnnos;
    boolean allowDeprecationOnImport;
    boolean completionEnabled = true;
    private final ImportsPhase completeClass = new ImportsPhase();
    private Phase topLevelPhase;

    public static TypeEnter instance(Context context) {
        TypeEnter instance = context.get(typeEnterKey);
        if (instance == null) {
            instance = new TypeEnter(context);
        }
        return instance;
    }

    protected TypeEnter(Context context) {
        context.put(typeEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.types = Types.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.lint = Lint.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dependencies = Dependencies.instance(context);
        this.preview = Preview.instance(context);
        Source source = Source.instance(context);
        this.allowTypeAnnos = Source.Feature.TYPE_ANNOTATIONS.allowedInSource(source);
        this.allowDeprecationOnImport = Source.Feature.DEPRECATION_ON_IMPORT.allowedInSource(source);
    }

    protected void ensureImportsChecked(List<JCTree.JCCompilationUnit> trees) {
        for (JCTree.JCCompilationUnit tree : trees) {
            if (tree.starImportScope.isFilled()) continue;
            Env<AttrContext> topEnv = this.enter.topLevelEnv(tree);
            this.finishImports(tree, () -> this.completeClass.resolveImports(tree, topEnv));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            Assert.check((sym.flags() & 0x1000000L) == 0L);
            sym.completer = this;
            return;
        }
        try {
            List<Env<AttrContext>> queue;
            this.annotate.blockAnnotations();
            sym.flags_field |= 0x10000000L;
            this.dependencies.push((Symbol.ClassSymbol)sym, Dependencies.CompletionCause.MEMBER_ENTER);
            try {
                queue = this.completeClass.completeEnvs(List.of(this.typeEnvs.get((Symbol.ClassSymbol)sym)));
            }
            finally {
                this.dependencies.pop();
            }
            if (!queue.isEmpty()) {
                HashSet<JCTree.JCCompilationUnit> seen = new HashSet<JCTree.JCCompilationUnit>();
                for (Env<AttrContext> env : queue) {
                    if (!env.toplevel.defs.contains(env.enclClass) || !seen.add(env.toplevel)) continue;
                    this.finishImports(env.toplevel, () -> {});
                }
            }
        }
        finally {
            this.annotate.unblockAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishImports(JCTree.JCCompilationUnit toplevel, Runnable resolve) {
        JavaFileObject prev = this.log.useSource(toplevel.sourcefile);
        try {
            resolve.run();
            this.chk.checkImportsUnique(toplevel);
            this.chk.checkImportsResolvable(toplevel);
            this.chk.checkImportedPackagesObservable(toplevel);
            toplevel.namedImportScope.finalizeScope();
            toplevel.starImportScope.finalizeScope();
        }
        catch (Symbol.CompletionFailure cf) {
            this.chk.completionError(toplevel.pos(), cf);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    private Symbol.MethodSymbol lookupMethod(Symbol.TypeSymbol tsym, Name name, List<Type> argtypes) {
        for (Symbol s2 : tsym.members().getSymbolsByName(name, s -> s.kind == Kinds.Kind.MTH)) {
            if (!this.types.isSameTypes(s2.type.getParameterTypes(), argtypes)) continue;
            return (Symbol.MethodSymbol)s2;
        }
        return null;
    }

    JCTree defaultConstructor(TreeMaker make, DefaultConstructorHelper helper) {
        Type initType = helper.constructorType();
        Symbol.MethodSymbol initSym = helper.constructorSymbol();
        ListBuffer<JCTree.JCExpressionStatement> stats = new ListBuffer<JCTree.JCExpressionStatement>();
        if (helper.owner().type != this.syms.objectType) {
            JCTree.JCExpression meth = !helper.enclosingType().hasTag(TypeTag.NONE) ? make.Select((JCTree.JCExpression)make.Ident((Symbol)initSym.params.head), this.names._super) : make.Ident(this.names._super);
            List<JCTree.JCExpression> typeargs = initType.getTypeArguments().nonEmpty() ? make.Types(initType.getTypeArguments()) : null;
            JCTree.JCExpressionStatement superCall = make.Exec(make.Apply(typeargs, meth, helper.superArgs().map(make::Ident)));
            stats.add(superCall);
        }
        JCTree.JCMethodDecl result = make.MethodDef(initSym, make.Block(0L, stats.toList()));
        return helper.finalAdjustment(result);
    }

    public void markDeprecated(Symbol sym, List<JCTree.JCAnnotation> annotations, Env<AttrContext> env) {
        this.attr.attribAnnotationTypes(annotations, env);
        this.handleDeprecatedAnnotations(annotations, sym);
    }

    private void handleDeprecatedAnnotations(List<JCTree.JCAnnotation> annotations, Symbol sym) {
        List<JCTree.JCAnnotation> al = annotations;
        while (!al.isEmpty()) {
            JCTree.JCAnnotation a = (JCTree.JCAnnotation)al.head;
            if (a.annotationType.type == this.syms.deprecatedType) {
                sym.flags_field |= 0x40000000020000L;
                this.setFlagIfAttributeTrue(a, sym, this.names.forRemoval, 0x80000000000000L);
            } else if (a.annotationType.type == this.syms.previewFeatureType) {
                sym.flags_field |= 0x100000000000000L;
                this.setFlagIfAttributeTrue(a, sym, this.names.reflective, 0x400000000000000L);
            }
            al = al.tail;
        }
    }

    private void setFlagIfAttributeTrue(JCTree.JCAnnotation a, Symbol sym, Name attribute, long flag) {
        a.args.stream().filter(e -> e.hasTag(JCTree.Tag.ASSIGN)).map(e -> (JCTree.JCAssign)e).filter(assign -> TreeInfo.name(assign.lhs) == attribute).findFirst().ifPresent(assign -> {
            JCTree.JCExpression rhs = TreeInfo.skipParens(assign.rhs);
            if (rhs.hasTag(JCTree.Tag.LITERAL) && Boolean.TRUE.equals(((JCTree.JCLiteral)rhs).getValue())) {
                sym.flags_field |= flag;
            }
        });
    }

    abstract class Phase {
        private final ListBuffer<Env<AttrContext>> queue = new ListBuffer();
        private final Phase next;
        private final Dependencies.CompletionCause phaseName;

        Phase(Dependencies.CompletionCause phaseName, Phase next) {
            this.phaseName = phaseName;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final List<Env<AttrContext>> completeEnvs(List<Env<AttrContext>> envs) {
            boolean firstToComplete = this.queue.isEmpty();
            Phase prevTopLevelPhase = TypeEnter.this.topLevelPhase;
            boolean success = false;
            try {
                TypeEnter.this.topLevelPhase = this;
                this.doCompleteEnvs(envs);
                success = true;
            }
            finally {
                TypeEnter.this.topLevelPhase = prevTopLevelPhase;
                if (!success && firstToComplete) {
                    this.queue.clear();
                }
            }
            if (firstToComplete) {
                List<Env<AttrContext>> out = this.queue.toList();
                this.queue.clear();
                return this.next != null ? this.next.completeEnvs(out) : out;
            }
            return List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doCompleteEnvs(List<Env<AttrContext>> envs) {
            for (Env<AttrContext> env : envs) {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)env.tree;
                this.queue.add(env);
                JavaFileObject prev = TypeEnter.this.log.useSource(env.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition prevLintPos = TypeEnter.this.deferredLintHandler.setPos(tree.pos());
                try {
                    TypeEnter.this.dependencies.push(env.enclClass.sym, this.phaseName);
                    this.runPhase(env);
                }
                catch (Symbol.CompletionFailure ex) {
                    TypeEnter.this.chk.completionError(tree.pos(), ex);
                }
                finally {
                    TypeEnter.this.dependencies.pop();
                    TypeEnter.this.deferredLintHandler.setPos(prevLintPos);
                    TypeEnter.this.log.useSource(prev);
                }
            }
        }

        protected abstract void runPhase(Env<AttrContext> var1);
    }

    private final class ImportsPhase
    extends Phase {
        Env<AttrContext> env;
        Scope.ImportFilter staticImportFilter;
        Scope.ImportFilter typeImportFilter;
        BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public ImportsPhase() {
            super(Dependencies.CompletionCause.IMPORTS_PHASE, new HierarchyPhase());
            this.cfHandler = (imp, cf) -> TypeEnter.this.chk.completionError(imp.pos(), (Symbol.CompletionFailure)cf);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            if (sym.owner.kind == Kinds.Kind.PCK) {
                this.resolveImports(env.toplevel, env.enclosing(JCTree.Tag.TOPLEVEL));
                TypeEnter.this.todo.append(env);
            }
            if (sym.owner.kind == Kinds.Kind.TYP) {
                sym.owner.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveImports(JCTree.JCCompilationUnit tree, Env<AttrContext> env) {
            block10: {
                if (tree.starImportScope.isFilled()) {
                    return;
                }
                Scope.ImportFilter prevStaticImportFilter = this.staticImportFilter;
                Scope.ImportFilter prevTypeImportFilter = this.typeImportFilter;
                JCDiagnostic.DiagnosticPosition prevLintPos = TypeEnter.this.deferredLintHandler.immediate();
                Lint prevLint = TypeEnter.this.chk.setLint(TypeEnter.this.lint);
                Env<AttrContext> prevEnv = this.env;
                try {
                    this.env = env;
                    Symbol.PackageSymbol packge = env.toplevel.packge;
                    this.staticImportFilter = (origin, sym) -> sym.isStatic() && TypeEnter.this.chk.importAccessible(sym, packge) && sym.isMemberOf((Symbol.TypeSymbol)origin.owner, TypeEnter.this.types);
                    this.typeImportFilter = (origin, sym) -> sym.kind == Kinds.Kind.TYP && TypeEnter.this.chk.importAccessible(sym, packge);
                    Symbol.PackageSymbol javaLang = TypeEnter.this.syms.enterPackage(((TypeEnter)TypeEnter.this).syms.java_base, ((TypeEnter)TypeEnter.this).names.java_lang);
                    if (javaLang.members().isEmpty() && !javaLang.exists()) {
                        TypeEnter.this.log.error(CompilerProperties.Errors.NoJavaLang);
                        throw new Abort();
                    }
                    this.importAll(TypeEnter.this.make.at(tree.pos()).Import(TypeEnter.this.make.QualIdent(javaLang), false), javaLang, env);
                    JCTree.JCModuleDecl decl = tree.getModuleDecl();
                    if (tree.getPackage() != null && decl == null) {
                        this.checkClassPackageClash(tree.getPackage());
                    }
                    for (JCTree.JCImport imp : tree.getImports()) {
                        this.doImport(imp);
                    }
                    if (decl == null) break block10;
                    JCDiagnostic.DiagnosticPosition prevCheckDeprecatedLintPos = TypeEnter.this.deferredLintHandler.setPos(decl.pos());
                    try {
                        TypeEnter.this.markDeprecated(decl.sym, decl.mods.annotations, env);
                    }
                    finally {
                        TypeEnter.this.deferredLintHandler.setPos(prevCheckDeprecatedLintPos);
                    }
                    TypeEnter.this.annotate.annotateLater(decl.mods.annotations, env, env.toplevel.modle, decl.pos());
                }
                finally {
                    this.env = prevEnv;
                    TypeEnter.this.chk.setLint(prevLint);
                    TypeEnter.this.deferredLintHandler.setPos(prevLintPos);
                    this.staticImportFilter = prevStaticImportFilter;
                    this.typeImportFilter = prevTypeImportFilter;
                }
            }
        }

        private void checkClassPackageClash(JCTree.JCPackageDecl tree) {
            if (tree.pid != null) {
                Symbol p = this.env.toplevel.packge;
                while (p.owner != ((TypeEnter)TypeEnter.this).syms.rootPackage) {
                    p.owner.complete();
                    Symbol.PackageSymbol pack = TypeEnter.this.syms.lookupPackage(this.env.toplevel.modle, p.owner.getQualifiedName());
                    if (TypeEnter.this.syms.getClass(pack.modle, ((Symbol)p).getQualifiedName()) != null) {
                        TypeEnter.this.log.error(tree.pos, CompilerProperties.Errors.PkgClashesWithClassOfSameName(p));
                    }
                    p = p.owner;
                }
            }
            TypeEnter.this.annotate.annotateLater(tree.annotations, this.env, this.env.toplevel.packge, tree.pos());
        }

        private void doImport(JCTree.JCImport tree) {
            JCTree.JCFieldAccess imp = (JCTree.JCFieldAccess)tree.qualid;
            Name name = TreeInfo.name(imp);
            Env<AttrContext> localEnv = this.env.dup(tree);
            Symbol.TypeSymbol p = ((TypeEnter)TypeEnter.this).attr.attribImportQualifier((JCTree.JCImport)tree, localEnv).tsym;
            if (name == ((TypeEnter)TypeEnter.this).names.asterisk) {
                TypeEnter.this.chk.checkCanonical(imp.selected);
                if (tree.staticImport) {
                    this.importStaticAll(tree, p, this.env);
                } else {
                    this.importAll(tree, p, this.env);
                }
            } else if (tree.staticImport) {
                this.importNamedStatic(tree, p, name, localEnv);
                TypeEnter.this.chk.checkCanonical(imp.selected);
            } else {
                Type importedType = this.attribImportType(imp, localEnv);
                Type originalType = importedType.getOriginalType();
                Symbol.TypeSymbol c = originalType.hasTag(TypeTag.CLASS) ? originalType.tsym : importedType.tsym;
                TypeEnter.this.chk.checkCanonical(imp);
                this.importNamed(tree.pos(), c, this.env, tree);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type attribImportType(JCTree tree, Env<AttrContext> env) {
            Assert.check(TypeEnter.this.completionEnabled);
            Lint prevLint = TypeEnter.this.chk.setLint(TypeEnter.this.allowDeprecationOnImport ? TypeEnter.this.lint : TypeEnter.this.lint.suppress(Lint.LintCategory.DEPRECATION, Lint.LintCategory.REMOVAL, Lint.LintCategory.PREVIEW));
            try {
                TypeEnter.this.completionEnabled = false;
                Type type = TypeEnter.this.attr.attribType(tree, env);
                return type;
            }
            finally {
                TypeEnter.this.completionEnabled = true;
                TypeEnter.this.chk.setLint(prevLint);
            }
        }

        private void importAll(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
            env.toplevel.starImportScope.importAll(TypeEnter.this.types, tsym.members(), this.typeImportFilter, imp, this.cfHandler);
        }

        private void importStaticAll(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
            Scope.StarImportScope toScope = env.toplevel.starImportScope;
            Symbol.TypeSymbol origin = tsym;
            toScope.importAll(TypeEnter.this.types, origin.members(), this.staticImportFilter, imp, this.cfHandler);
        }

        private void importNamedStatic(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Name name, Env<AttrContext> env) {
            if (tsym.kind != Kinds.Kind.TYP) {
                TypeEnter.this.log.error(JCDiagnostic.DiagnosticFlag.RECOVERABLE, imp.pos(), CompilerProperties.Errors.StaticImpOnlyClassesAndInterfaces);
                return;
            }
            Scope.NamedImportScope toScope = env.toplevel.namedImportScope;
            Scope.WriteableScope originMembers = tsym.members();
            imp.importScope = toScope.importByName(TypeEnter.this.types, originMembers, name, this.staticImportFilter, imp, this.cfHandler);
        }

        private void importNamed(JCDiagnostic.DiagnosticPosition pos, Symbol tsym, Env<AttrContext> env, JCTree.JCImport imp) {
            if (tsym.kind == Kinds.Kind.TYP) {
                imp.importScope = env.toplevel.namedImportScope.importType(tsym.owner.members(), tsym.owner.members(), tsym);
            }
        }
    }

    static interface DefaultConstructorHelper {
        public Type constructorType();

        public Symbol.MethodSymbol constructorSymbol();

        public Type enclosingType();

        public Symbol.TypeSymbol owner();

        public List<Name> superArgs();

        default public JCTree.JCMethodDecl finalAdjustment(JCTree.JCMethodDecl md) {
            return md;
        }
    }

    class RecordConstructorHelper
    extends BasicConstructorHelper {
        boolean lastIsVarargs;
        List<JCTree.JCVariableDecl> recordFieldDecls;

        RecordConstructorHelper(Symbol.ClassSymbol owner, List<JCTree.JCVariableDecl> recordFieldDecls) {
            super(owner);
            this.recordFieldDecls = recordFieldDecls;
            this.lastIsVarargs = owner.getRecordComponents().stream().anyMatch(rc -> rc.isVarargs());
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                ListBuffer<Type> argtypes = new ListBuffer<Type>();
                JCTree.JCVariableDecl lastField = this.recordFieldDecls.last();
                for (JCTree.JCVariableDecl field : this.recordFieldDecls) {
                    argtypes.add(field == lastField && this.lastIsVarargs ? TypeEnter.this.types.elemtype(field.sym.type) : field.sym.type);
                }
                this.constructorType = new Type.MethodType(argtypes.toList(), ((TypeEnter)TypeEnter.this).syms.voidType, List.nil(), ((TypeEnter)TypeEnter.this).syms.methodClass);
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            Symbol.MethodSymbol csym = super.constructorSymbol();
            csym.flags_field |= 0x8001000000000L;
            ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
            JCTree.JCVariableDecl lastField = this.recordFieldDecls.last();
            for (JCTree.JCVariableDecl field : this.recordFieldDecls) {
                params.add(new Symbol.VarSymbol(0x2000000201000000L | (field == lastField && this.lastIsVarargs ? 0x400000000L : 0L), field.name, field.sym.type, csym));
            }
            csym.params = params.toList();
            csym.flags_field |= 0x2000000000000000L;
            return csym;
        }

        @Override
        public JCTree.JCMethodDecl finalAdjustment(JCTree.JCMethodDecl md) {
            List<JCTree.JCVariableDecl> tmpRecordFieldDecls = this.recordFieldDecls;
            for (JCTree.JCVariableDecl arg : md.params) {
                Symbol.RecordComponent rc = ((Symbol.ClassSymbol)this.owner).getRecordComponent(arg.sym);
                TreeCopier tc = new TreeCopier(TypeEnter.this.make.at(arg.pos));
                arg.mods.annotations = rc.getOriginalAnnos().isEmpty() ? List.nil() : tc.copy(rc.getOriginalAnnos());
                arg.vartype = tc.copy(((JCTree.JCVariableDecl)tmpRecordFieldDecls.head).vartype);
                tmpRecordFieldDecls = tmpRecordFieldDecls.tail;
            }
            return md;
        }
    }

    class AnonClassConstructorHelper
    extends BasicConstructorHelper {
        Symbol.MethodSymbol constr;
        Type encl;
        boolean based;

        AnonClassConstructorHelper(Symbol.TypeSymbol owner, Symbol.MethodSymbol constr, JCTree.JCExpression encl) {
            super(owner);
            this.based = false;
            this.constr = constr;
            this.encl = encl != null ? encl.type : Type.noType;
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                Type ctype = TypeEnter.this.types.memberType(this.owner.type, this.constr);
                if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                    ctype = TypeEnter.this.types.createMethodTypeWithParameters(ctype, ctype.getParameterTypes().prepend(this.enclosingType()));
                    this.based = true;
                }
                this.constructorType = ctype;
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            Symbol.MethodSymbol csym = super.constructorSymbol();
            csym.flags_field |= 0x20000000L | this.constr.flags() & 0x400000000L;
            csym.flags_field = csym.flags_field | (this.based ? 0x200000000000000L : 0L);
            ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
            List<Type> argtypes = this.constructorType().getParameterTypes();
            if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                argtypes = argtypes.tail;
                params = params.prepend(new Symbol.VarSymbol(0x200000000L, TypeEnter.this.make.paramName(0), this.enclosingType(), csym));
            }
            if (this.constr.params != null) {
                for (Symbol.VarSymbol p : this.constr.params) {
                    params.add(new Symbol.VarSymbol(0x200000000L | p.flags(), p.name, (Type)argtypes.head, csym));
                    argtypes = argtypes.tail;
                }
            }
            csym.params = params.toList();
            return csym;
        }

        @Override
        public Type enclosingType() {
            return this.encl;
        }

        @Override
        public List<Name> superArgs() {
            List<JCTree.JCVariableDecl> params = TypeEnter.this.make.Params(this.constructorType().getParameterTypes(), this.constructorSymbol());
            if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                params = params.tail;
            }
            return params.map(vd -> vd.name);
        }
    }

    class BasicConstructorHelper
    implements DefaultConstructorHelper {
        Symbol.TypeSymbol owner;
        Type constructorType;
        Symbol.MethodSymbol constructorSymbol;

        BasicConstructorHelper(Symbol.TypeSymbol owner) {
            this.owner = owner;
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                this.constructorType = new Type.MethodType(List.nil(), ((TypeEnter)TypeEnter.this).syms.voidType, List.nil(), ((TypeEnter)TypeEnter.this).syms.methodClass);
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            if (this.constructorSymbol == null) {
                long flags = (this.owner().flags() & 0x4000L) != 0L && ((TypeEnter)TypeEnter.this).types.supertype((Type)this.owner().type).tsym == ((TypeEnter)TypeEnter.this).syms.enumSym ? 0x1000000002L : this.owner().flags() & 7L | 0x1000000000L;
                this.constructorSymbol = new Symbol.MethodSymbol(flags, ((TypeEnter)TypeEnter.this).names.init, this.constructorType(), this.owner());
            }
            return this.constructorSymbol;
        }

        @Override
        public Type enclosingType() {
            return Type.noType;
        }

        @Override
        public Symbol.TypeSymbol owner() {
            return this.owner;
        }

        @Override
        public List<Name> superArgs() {
            return List.nil();
        }
    }

    private final class MembersPhase
    extends AbstractMembersPhase {
        public MembersPhase() {
            super(Dependencies.CompletionCause.MEMBERS_PHASE, null);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct = (Type.ClassType)sym.type;
            JCTree defaultConstructor = null;
            DefaultConstructorHelper helper = this.getDefaultConstructorHelper(env);
            if (helper != null) {
                TypeEnter.this.chk.checkDefaultConstructor(sym, tree.pos());
                defaultConstructor = TypeEnter.this.defaultConstructor(TypeEnter.this.make.at(tree.pos), helper);
                tree.defs = tree.defs.prepend(defaultConstructor);
            }
            if (!sym.isRecord()) {
                this.enterThisAndSuper(sym, env);
            }
            if (!tree.typarams.isEmpty()) {
                for (JCTree.JCTypeParameter tvar : tree.typarams) {
                    TypeEnter.this.chk.checkNonCyclic((JCDiagnostic.DiagnosticPosition)tvar, (Type.TypeVar)tvar.type);
                }
            }
            this.finishClass(tree, defaultConstructor, env);
            if (TypeEnter.this.allowTypeAnnos) {
                TypeEnter.this.typeAnnotations.organizeTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
                TypeEnter.this.typeAnnotations.validateTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
            }
        }

        DefaultConstructorHelper getDefaultConstructorHelper(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            BasicConstructorHelper helper = null;
            boolean isClassWithoutInit = (sym.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(tree.defs);
            boolean isRecord = sym.isRecord();
            if (isClassWithoutInit && !isRecord) {
                helper = new BasicConstructorHelper(sym);
                if (sym.name.isEmpty()) {
                    JCTree.JCNewClass nc = (JCTree.JCNewClass)env.next.tree;
                    if (nc.constructor != null) {
                        helper = nc.constructor.kind != Kinds.Kind.ERR ? new AnonClassConstructorHelper(sym, (Symbol.MethodSymbol)nc.constructor, nc.encl) : null;
                    }
                }
            }
            if (isRecord) {
                JCTree.JCMethodDecl canonicalInit = null;
                if (isClassWithoutInit || (canonicalInit = this.getCanonicalConstructorDecl(env.enclClass)) == null) {
                    helper = new RecordConstructorHelper(sym, TreeInfo.recordFields(tree));
                }
                if (canonicalInit != null) {
                    canonicalInit.sym.flags_field |= 0x2000000000000000L;
                }
            }
            return helper;
        }

        void finishClass(JCTree.JCClassDecl tree, JCTree defaultConstructor, Env<AttrContext> env) {
            if ((tree.mods.flags & 0x4000L) != 0L && !tree.sym.type.hasTag(TypeTag.ERROR) && (((TypeEnter)TypeEnter.this).types.supertype((Type)tree.sym.type).tsym.flags() & 0x4000L) == 0L) {
                this.addEnumMembers(tree, env);
            }
            boolean isRecord = (tree.sym.flags_field & 0x2000000000000000L) != 0L;
            List<JCTree> alreadyEntered = null;
            if (isRecord) {
                alreadyEntered = List.convert(JCTree.class, TreeInfo.recordFields(tree));
                alreadyEntered = alreadyEntered.prependList(tree.defs.stream().filter(t -> TreeInfo.isConstructor(t) && t != defaultConstructor).collect(List.collector()));
            }
            List<JCTree> defsToEnter = isRecord ? tree.defs.diff(alreadyEntered) : tree.defs;
            TypeEnter.this.memberEnter.memberEnter(defsToEnter, env);
            if (isRecord) {
                this.addRecordMembersIfNeeded(tree, env);
            }
            if (tree.sym.isAnnotationType()) {
                Assert.check(tree.sym.isCompleted());
                tree.sym.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(tree.sym, TypeEnter.this.annotate.annotationTypeSourceCompleter()));
            }
        }

        private void addAccessor(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
            Symbol.MethodSymbol implSym = TypeEnter.this.lookupMethod(env.enclClass.sym, tree.sym.name, List.nil());
            Symbol.RecordComponent rec = ((Symbol.ClassSymbol)tree.sym.owner).getRecordComponent(tree.sym);
            if (implSym == null || (implSym.flags_field & 0x1000000L) != 0L) {
                TreeCopier tc = new TreeCopier(TypeEnter.this.make.at(tree.pos));
                List<JCTree.JCAnnotation> originalAnnos = rec.getOriginalAnnos().isEmpty() ? rec.getOriginalAnnos() : tc.copy(rec.getOriginalAnnos());
                JCTree.JCVariableDecl recordField = TreeInfo.recordFields((JCTree.JCClassDecl)env.tree).stream().filter(rf -> rf.name == tree.name).findAny().get();
                JCTree.JCMethodDecl getter = TypeEnter.this.make.at(tree.pos).MethodDef(TypeEnter.this.make.Modifiers(0x1000001L, originalAnnos), tree.sym.name, tc.copy(recordField.vartype), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter(getter, env);
                rec.accessor = getter.sym;
                rec.accessorMeth = getter;
            } else if (implSym != null) {
                rec.accessor = implSym;
            }
        }

        private void addEnumMembers(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            JCTree.JCExpression valuesType = TypeEnter.this.make.Type(new Type.ArrayType(tree.sym.type, ((TypeEnter)TypeEnter.this).syms.arrayClass));
            JCTree.JCMethodDecl values = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.values, valuesType, List.nil(), List.nil(), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(values, env);
            JCTree.JCMethodDecl valueOf = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.valueOf, TypeEnter.this.make.Type(tree.sym.type), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200008000L), TypeEnter.this.names.fromString("name"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), null)), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(valueOf, env);
        }

        JCTree.JCMethodDecl getCanonicalConstructorDecl(JCTree.JCClassDecl tree) {
            List<Type> recordComponentErasedTypes = TypeEnter.this.types.erasure(TreeInfo.recordFields(tree).map(vd -> vd.sym.type));
            JCTree.JCMethodDecl canonicalDecl = null;
            for (JCTree def : tree.defs) {
                if (!TreeInfo.isConstructor(def)) continue;
                JCTree.JCMethodDecl mdecl = (JCTree.JCMethodDecl)def;
                if (!TypeEnter.this.types.isSameTypes(TypeEnter.this.types.erasure(mdecl.params.stream().map(v -> v.sym.type).collect(List.collector())), recordComponentErasedTypes)) continue;
                canonicalDecl = mdecl;
                break;
            }
            return canonicalDecl;
        }

        private void addRecordMembersIfNeeded(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            if (TypeEnter.this.lookupMethod(tree.sym, ((TypeEnter)TypeEnter.this).names.toString, List.nil()) == null) {
                JCTree.JCMethodDecl toString = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.toString, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter(toString, env);
            }
            if (TypeEnter.this.lookupMethod(tree.sym, ((TypeEnter)TypeEnter.this).names.hashCode, List.nil()) == null) {
                JCTree.JCMethodDecl hashCode = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.hashCode, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.intType), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter(hashCode, env);
            }
            if (TypeEnter.this.lookupMethod(tree.sym, ((TypeEnter)TypeEnter.this).names.equals, List.of(((TypeEnter)TypeEnter.this).syms.objectType)) == null) {
                JCTree.JCMethodDecl equals = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.equals, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.booleanType), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200000000L), TypeEnter.this.names.fromString("o"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.objectType), null)), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter(equals, env);
            }
            List<JCTree.JCVariableDecl> recordFields = TreeInfo.recordFields(tree);
            for (JCTree.JCVariableDecl field : recordFields) {
                field.mods.flags &= 0xFFFFFFFBFFFFFFFFL;
                field.sym.flags_field &= 0xFFFFFFFBFFFFFFFFL;
            }
            recordFields.stream().filter(vd -> TypeEnter.this.lookupMethod(((TypeEnter)TypeEnter.this).syms.objectType.tsym, vd.name, List.nil()) == null).forEach(vd -> this.addAccessor((JCTree.JCVariableDecl)vd, env));
        }
    }

    private final class RecordPhase
    extends AbstractMembersPhase {
        public RecordPhase() {
            super(Dependencies.CompletionCause.RECORD_PHASE, new MembersPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            if ((sym.flags_field & 0x2000000000000000L) != 0L) {
                List<JCTree.JCVariableDecl> fields = TreeInfo.recordFields(tree);
                TypeEnter.this.memberEnter.memberEnter(fields, env);
                for (JCTree.JCVariableDecl field : fields) {
                    sym.getRecordComponent(field, true, field.mods.annotations.isEmpty() ? List.nil() : new TreeCopier(TypeEnter.this.make.at(field.pos)).copy(field.mods.annotations));
                }
                this.enterThisAndSuper(sym, env);
                for (JCTree def : tree.defs) {
                    if (!TreeInfo.isConstructor(def)) continue;
                    TypeEnter.this.memberEnter.memberEnter(def, env);
                }
            }
        }
    }

    private abstract class AbstractMembersPhase
    extends Phase {
        private boolean completing;
        private List<Env<AttrContext>> todo;

        public AbstractMembersPhase(Dependencies.CompletionCause completionCause, Phase next) {
            super(completionCause, next);
            this.todo = List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> envs) {
            this.todo = this.todo.prependList(envs);
            if (this.completing) {
                return;
            }
            boolean prevCompleting = this.completing;
            this.completing = true;
            try {
                while (this.todo.nonEmpty()) {
                    Env head = (Env)this.todo.head;
                    this.todo = this.todo.tail;
                    super.doCompleteEnvs(List.of(head));
                }
            }
            finally {
                this.completing = prevCompleting;
            }
        }

        void enterThisAndSuper(Symbol.ClassSymbol sym, Env<AttrContext> env) {
            Type.ClassType ct = (Type.ClassType)sym.type;
            Symbol.VarSymbol thisSym = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._this, sym.type, sym);
            thisSym.pos = 0;
            ((AttrContext)env.info).scope.enter(thisSym);
            if ((sym.flags_field & 0x200L) == 0L && ct.supertype_field.hasTag(TypeTag.CLASS)) {
                Symbol.VarSymbol superSym = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._super, ct.supertype_field, sym);
                superSym.pos = 0;
                ((AttrContext)env.info).scope.enter(superSym);
            }
        }
    }

    private final class HeaderPhase
    extends AbstractHeaderPhase {
        public HeaderPhase() {
            super(Dependencies.CompletionCause.HEADER_PHASE, new RecordPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct = (Type.ClassType)sym.type;
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            if (tree.extending != null) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(tree.extending, baseEnv, sym, tree.pos());
            }
            for (JCTree.JCExpression impl : tree.implementing) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(impl, baseEnv, sym, tree.pos());
            }
            TypeEnter.this.annotate.flush();
            this.attribSuperTypes(env, baseEnv);
            HashSet<Type> interfaceSet = new HashSet<Type>();
            for (JCTree.JCExpression iface : tree.implementing) {
                Type it = iface.type;
                if (!it.hasTag(TypeTag.CLASS)) continue;
                TypeEnter.this.chk.checkNotRepeated(iface.pos(), TypeEnter.this.types.erasure(it), interfaceSet);
            }
            TypeEnter.this.annotate.annotateLater(tree.mods.annotations, baseEnv, sym, tree.pos());
            TypeEnter.this.attr.attribTypeVariables(tree.typarams, baseEnv, false);
            for (JCTree.JCTypeParameter tp : tree.typarams) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(tp, baseEnv, sym, tree.pos());
            }
            if (sym.owner.kind == Kinds.Kind.PCK && sym.owner != env.toplevel.modle.unnamedPackage && TypeEnter.this.syms.packageExists(env.toplevel.modle, sym.fullname)) {
                TypeEnter.this.log.error(tree.pos, CompilerProperties.Errors.ClashWithPkgOfSameName(Kinds.kindName(sym), sym));
            }
            if (sym.owner.kind == Kinds.Kind.PCK && (sym.flags_field & 1L) == 0L && !env.toplevel.sourcefile.isNameCompatible(sym.name.toString(), JavaFileObject.Kind.SOURCE)) {
                sym.flags_field |= 0x100000000000L;
            }
        }
    }

    private final class PermitsPhase
    extends AbstractHeaderPhase {
        public PermitsPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new HeaderPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            if (!tree.sym.isAnonymous() || tree.sym.isEnum()) {
                for (Type supertype : TypeEnter.this.types.directSupertypes(tree.sym.type)) {
                    if (supertype.tsym.kind != Kinds.Kind.TYP) continue;
                    Symbol.ClassSymbol supClass = (Symbol.ClassSymbol)supertype.tsym;
                    Env<AttrContext> supClassEnv = TypeEnter.this.enter.getEnv(supClass);
                    if (!supClass.isSealed() || supClass.isPermittedExplicit || supClassEnv == null || supClassEnv.toplevel != env.toplevel) continue;
                    supClass.permitted = supClass.permitted.append(tree.sym);
                }
            }
        }
    }

    private final class HierarchyPhase
    extends AbstractHeaderPhase
    implements Symbol.Completer {
        public HierarchyPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new PermitsPhase());
        }

        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> envs) {
            for (Env<AttrContext> env : envs) {
                env.enclClass.sym.completer = this;
            }
            for (Env<AttrContext> env : envs) {
                env.enclClass.sym.complete();
            }
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct = (Type.ClassType)sym.type;
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            this.attribSuperTypes(env, baseEnv);
            if (sym.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                if (tree.extending != null) {
                    TypeEnter.this.chk.checkNonCyclic(tree.extending.pos(), ct.supertype_field);
                    ct.supertype_field = Type.noType;
                } else if (tree.implementing.nonEmpty()) {
                    TypeEnter.this.chk.checkNonCyclic(((JCTree.JCExpression)tree.implementing.head).pos(), (Type)ct.interfaces_field.head);
                    ct.interfaces_field = List.nil();
                }
            }
            TypeEnter.this.markDeprecated(sym, tree.mods.annotations, baseEnv);
            TypeEnter.this.chk.checkNonCyclicDecl(tree);
        }

        @Override
        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression superType) {
            switch (superType.getTag()) {
                case TYPEAPPLY: {
                    return ((JCTree.JCTypeApply)superType).clazz;
                }
            }
            return superType;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            Assert.check(TypeEnter.this.topLevelPhase instanceof ImportsPhase || TypeEnter.this.topLevelPhase == this);
            if (TypeEnter.this.topLevelPhase != this) {
                sym.completer = this;
                return;
            }
            Env<AttrContext> env = TypeEnter.this.typeEnvs.get((Symbol.ClassSymbol)sym);
            super.doCompleteEnvs(List.of(env));
        }
    }

    private abstract class AbstractHeaderPhase
    extends Phase {
        public AbstractHeaderPhase(Dependencies.CompletionCause phaseName, Phase next) {
            super(phaseName, next);
        }

        protected Env<AttrContext> baseEnv(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            Scope.WriteableScope baseScope = Scope.WriteableScope.create(tree.sym);
            for (Symbol sym : ((AttrContext)env.outer.info).scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (!sym.isDirectlyOrIndirectlyLocal()) continue;
                baseScope.enter(sym);
            }
            if (tree.typarams != null) {
                List<JCTree.JCTypeParameter> typarams = tree.typarams;
                while (typarams.nonEmpty()) {
                    baseScope.enter(((JCTree.JCTypeParameter)typarams.head).type.tsym);
                    typarams = typarams.tail;
                }
            }
            Env<AttrContext> outer = env.outer;
            Env<AttrContext> localEnv = outer.dup(tree, ((AttrContext)outer.info).dup(baseScope));
            localEnv.baseClause = true;
            localEnv.outer = outer;
            ((AttrContext)localEnv.info).isSelfCall = false;
            return localEnv;
        }

        protected JCTree.JCExpression enumBase(int pos, Symbol.ClassSymbol c) {
            JCTree.JCTypeApply result = TypeEnter.this.make.at(pos).TypeApply(TypeEnter.this.make.QualIdent(((TypeEnter)TypeEnter.this).syms.enumSym), List.of(TypeEnter.this.make.Type(c.type)));
            return result;
        }

        protected JCTree.JCExpression recordBase(int pos, Symbol.ClassSymbol c) {
            JCTree.JCExpression result = TypeEnter.this.make.at(pos).QualIdent(((TypeEnter)TypeEnter.this).syms.recordType.tsym);
            return result;
        }

        protected Type modelMissingTypes(final Env<AttrContext> env, Type t, final JCTree.JCExpression tree, final boolean interfaceExpected) {
            if (!t.hasTag(TypeTag.ERROR)) {
                return t;
            }
            return new Type.ErrorType(t.getOriginalType(), t.tsym){
                private Type modelType;

                @Override
                public Type getModelType() {
                    if (this.modelType == null) {
                        this.modelType = new Synthesizer(env.toplevel.modle, this.getOriginalType(), interfaceExpected).visit(tree);
                    }
                    return this.modelType;
                }
            };
        }

        protected void attribSuperTypes(Env<AttrContext> env, Env<AttrContext> baseEnv) {
            Type supertype;
            JCTree.JCExpression extending;
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct = (Type.ClassType)sym.type;
            if (tree.extending != null) {
                extending = this.clearTypeParams(tree.extending);
                supertype = TypeEnter.this.attr.attribBase(extending, baseEnv, true, false, true);
                if (supertype == ((TypeEnter)TypeEnter.this).syms.recordType) {
                    TypeEnter.this.log.error(tree, CompilerProperties.Errors.InvalidSupertypeRecord(supertype.tsym));
                }
            } else {
                Type type;
                extending = null;
                if ((tree.mods.flags & 0x4000L) != 0L) {
                    extending = this.enumBase(tree.pos, sym);
                    type = TypeEnter.this.attr.attribBase(extending, baseEnv, true, false, false);
                } else if (sym.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                    type = Type.noType;
                } else if (sym.isRecord()) {
                    extending = this.recordBase(tree.pos, sym);
                    type = TypeEnter.this.attr.attribBase(extending, baseEnv, true, false, false);
                } else {
                    type = ((TypeEnter)TypeEnter.this).syms.objectType;
                }
                supertype = type;
            }
            ct.supertype_field = this.modelMissingTypes(baseEnv, supertype, extending, false);
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            ListBuffer<Type> all_interfaces = null;
            List<JCTree.JCExpression> interfaceTrees = tree.implementing;
            for (JCTree.JCExpression iface : interfaceTrees) {
                iface = this.clearTypeParams(iface);
                Type it = TypeEnter.this.attr.attribBase(iface, baseEnv, false, true, true);
                if (it.hasTag(TypeTag.CLASS)) {
                    interfaces.append(it);
                    if (all_interfaces == null) continue;
                    all_interfaces.append(it);
                    continue;
                }
                if (all_interfaces == null) {
                    all_interfaces = new ListBuffer<Type>().appendList(interfaces);
                }
                all_interfaces.append(this.modelMissingTypes(baseEnv, it, iface, true));
            }
            ListBuffer<Symbol.TypeSymbol> permittedSubtypeSymbols = new ListBuffer<Symbol.TypeSymbol>();
            List<JCTree.JCExpression> permittedTrees = tree.permitting;
            for (JCTree.JCExpression permitted : permittedTrees) {
                Type pt = TypeEnter.this.attr.attribBase(permitted, baseEnv, false, false, false);
                permittedSubtypeSymbols.append(pt.tsym);
            }
            if ((sym.flags_field & 0x2000L) != 0L) {
                ct.interfaces_field = List.of(((TypeEnter)TypeEnter.this).syms.annotationType);
                ct.all_interfaces_field = ct.interfaces_field;
            } else {
                ct.interfaces_field = interfaces.toList();
                List<Type> list = ct.all_interfaces_field = all_interfaces == null ? ct.interfaces_field : all_interfaces.toList();
            }
            if (!permittedSubtypeSymbols.isEmpty()) {
                sym.permitted = permittedSubtypeSymbols.toList();
            }
            sym.isPermittedExplicit = !permittedSubtypeSymbols.isEmpty();
        }

        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression superType) {
            return superType;
        }

        private class Synthesizer
        extends JCTree.Visitor {
            Symbol.ModuleSymbol msym;
            Type originalType;
            boolean interfaceExpected;
            List<Symbol.ClassSymbol> synthesizedSymbols = List.nil();
            Type result;

            Synthesizer(Symbol.ModuleSymbol msym, Type originalType, boolean interfaceExpected) {
                this.msym = msym;
                this.originalType = originalType;
                this.interfaceExpected = interfaceExpected;
            }

            Type visit(JCTree tree) {
                tree.accept(this);
                return this.result;
            }

            List<Type> visit(List<? extends JCTree> trees) {
                ListBuffer<Type> lb = new ListBuffer<Type>();
                for (JCTree jCTree : trees) {
                    lb.append(this.visit(jCTree));
                }
                return lb.toList();
            }

            @Override
            public void visitTree(JCTree tree) {
                this.result = ((TypeEnter)TypeEnter.this).syms.errType;
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                this.result = !tree.type.hasTag(TypeTag.ERROR) ? tree.type : this.synthesizeClass((Name)tree.name, (Symbol)this.msym.unnamedPackage).type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                if (!tree.type.hasTag(TypeTag.ERROR)) {
                    this.result = tree.type;
                } else {
                    Type selectedType;
                    boolean prev = this.interfaceExpected;
                    try {
                        this.interfaceExpected = false;
                        selectedType = this.visit(tree.selected);
                    }
                    finally {
                        this.interfaceExpected = prev;
                    }
                    Symbol.ClassSymbol c = this.synthesizeClass(tree.name, selectedType.tsym);
                    this.result = c.type;
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply tree) {
                if (!tree.type.hasTag(TypeTag.ERROR)) {
                    this.result = tree.type;
                } else {
                    Type.ClassType clazzType = (Type.ClassType)this.visit(tree.clazz);
                    if (this.synthesizedSymbols.contains(clazzType.tsym)) {
                        this.synthesizeTyparams((Symbol.ClassSymbol)clazzType.tsym, tree.arguments.size());
                    }
                    final List<Type> actuals = this.visit(tree.arguments);
                    this.result = new Type.ErrorType(tree.type, clazzType.tsym){

                        @Override
                        public List<Type> getTypeArguments() {
                            return actuals;
                        }
                    };
                }
            }

            Symbol.ClassSymbol synthesizeClass(Name name, Symbol owner) {
                int flags = this.interfaceExpected ? 512 : 0;
                Symbol.ClassSymbol c = new Symbol.ClassSymbol(flags, name, owner);
                c.members_field = new Scope.ErrorScope(c);
                c.type = new Type.ErrorType(this.originalType, (Symbol.TypeSymbol)c){

                    @Override
                    public List<Type> getTypeArguments() {
                        return this.typarams_field;
                    }
                };
                this.synthesizedSymbols = this.synthesizedSymbols.prepend(c);
                return c;
            }

            void synthesizeTyparams(Symbol.ClassSymbol sym, int n) {
                Type.ClassType ct = (Type.ClassType)sym.type;
                Assert.check(ct.typarams_field.isEmpty());
                if (n == 1) {
                    Type.TypeVar v = new Type.TypeVar(TypeEnter.this.names.fromString("T"), sym, ((TypeEnter)TypeEnter.this).syms.botType);
                    ct.typarams_field = ct.typarams_field.prepend(v);
                } else {
                    for (int i = n; i > 0; --i) {
                        Type.TypeVar v = new Type.TypeVar(TypeEnter.this.names.fromString("T" + i), sym, ((TypeEnter)TypeEnter.this).syms.botType);
                        ct.typarams_field = ct.typarams_field.prepend(v);
                    }
                }
            }
        }
    }
}

