/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.scope;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CustomScopePanel
extends JPanel
implements ExplorerManager.Provider {
    private static final Image PACKAGEBADGE = ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    private static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private static final String CLASS = "org/netbeans/modules/java/source/resources/icons/class.png";
    private ExplorerManager manager;
    private boolean initialized;
    private List<ProjectData> projectList = new LinkedList<ProjectData>();
    private Set<FileObject> sourceRoots = new HashSet<FileObject>();
    private Set<FileObject> files = new HashSet<FileObject>();
    private Map<String, NonRecursiveFolder> folders = new HashMap<String, NonRecursiveFolder>();
    private static final Logger LOG = Logger.getLogger(CustomScopePanel.class.getName());
    private OutlineView outlineView1;

    public CustomScopePanel() {
        this.manager = new ExplorerManager();
        this.initComponents();
        this.manager.setRootContext((Node)new WaitNode());
        this.outlineView1.getOutline().setColumnHidingAllowed(false);
    }

    public Scope getCustomScope() {
        return Scope.create(this.sourceRoots, this.folders.values(), this.files);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void initialize(Scope customScope) {
        if (!this.initialized) {
            if (customScope != null) {
                this.sourceRoots.addAll(customScope.getSourceRoots());
                for (NonRecursiveFolder folder : customScope.getFolders()) {
                    this.folders.put(folder.getFolder().getPath(), folder);
                }
                this.files.addAll(customScope.getFiles());
            }
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                SourceGroup[] sources;
                ProjectInformation information = ProjectUtils.getInformation((Project)project);
                ProjectData pData = new ProjectData(information.getDisplayName(), null);
                pData.setIcon(information.getIcon());
                for (SourceGroup sg : sources = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                    Image icon2;
                    SourceData sourceData = new SourceData(sg.getDisplayName(), pData, sg.getRootFolder(), this.sourceRoots);
                    try {
                        icon2 = DataObject.find((FileObject)sg.getRootFolder()).getNodeDelegate().getIcon(2);
                        icon2 = ImageUtilities.mergeImages((Image)icon2, (Image)PACKAGEBADGE, (int)7, (int)7);
                        sourceData.setIcon(icon2);
                    }
                    catch (DataObjectNotFoundException icon2) {
                        // empty catch block
                    }
                    try {
                        icon2 = DataObject.find((FileObject)sg.getRootFolder()).getNodeDelegate().getOpenedIcon(2);
                        icon2 = ImageUtilities.mergeImages((Image)icon2, (Image)PACKAGEBADGE, (int)7, (int)7);
                        sourceData.setOpenedIcon(icon2);
                    }
                    catch (DataObjectNotFoundException icon3) {
                        // empty catch block
                    }
                    ClassPath rcp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{sg.getRootFolder()});
                    ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)rcp);
                    ClassIndex index = cpInfo.getClassIndex();
                    Set packageNames = index.getPackageNames("", false, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    for (String packageName : packageNames) {
                        String pathname = packageName.replace(".", "/");
                        FileObject folder = sg.getRootFolder().getFileObject(pathname);
                        if (folder == null) continue;
                        PackageData data = new PackageData(sourceData, packageName, sourceData, folder, this.folders);
                        sourceData.getPackages().put(packageName, data);
                    }
                    Set declaredTypes = index.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    for (ElementHandle elementHandle : declaredTypes) {
                        String qualifiedName = elementHandle.getQualifiedName();
                        String packageName = "";
                        String className = qualifiedName;
                        int delimiter = qualifiedName.lastIndexOf(".");
                        if (delimiter > 0) {
                            packageName = qualifiedName.substring(0, delimiter);
                            className = qualifiedName.substring(delimiter + 1);
                        }
                        PackageData data = sourceData.getPackages().get(packageName);
                        FileObject file = CustomScopePanel.resolveFile(sg.getRootFolder(), elementHandle.getBinaryName());
                        if (data == null || file == null) continue;
                        ClassData classData = new ClassData(sourceData, className, file, data, this.files);
                        data.getClasses().add(classData);
                    }
                    pData.getSources().add(sourceData);
                }
                if (pData.getSources().isEmpty()) {
                    LOG.log(Level.INFO, "Poject {0} does not have any source roots", pData.getName());
                    continue;
                }
                this.projectList.add(pData);
            }
            if (customScope == null) {
                for (ProjectData projectData : this.projectList) {
                    projectData.setSelected(true);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractNode rootNode = new AbstractNode((Children)new Children.Array(){

                        protected Collection<Node> initCollection() {
                            LinkedList<Node> collection = new LinkedList<Node>();
                            for (ProjectData projectData : CustomScopePanel.this.projectList) {
                                collection.add((Node)new ProjectNode(projectData, CustomScopePanel.this));
                            }
                            return collection;
                        }
                    });
                    CustomScopePanel.this.manager.setRootContext((Node)rootNode);
                    CustomScopePanel.this.outlineView1.getOutline().setRootVisible(false);
                }
            });
        }
        this.initialized = true;
    }

    private static FileObject resolveFile(FileObject root, String classBinaryName) {
        String name;
        FileObject folder;
        assert (classBinaryName != null);
        int index = (classBinaryName = classBinaryName.replace('.', '/')).lastIndexOf(47);
        if (index < 0) {
            folder = root;
            name = classBinaryName;
        } else {
            assert (index > 0) : classBinaryName;
            assert (index < classBinaryName.length() - 1) : classBinaryName;
            folder = root.getFileObject(classBinaryName.substring(0, index));
            name = classBinaryName.substring(index + 1);
        }
        if (folder == null) {
            return null;
        }
        index = name.indexOf(36);
        if (index > 0) {
            name = name.substring(0, index);
        }
        for (FileObject child : folder.getChildren()) {
            if (!"java".equalsIgnoreCase(child.getExt()) || !name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    private void initComponents() {
        this.outlineView1 = new OutlineView(NbBundle.getMessage(CustomScopePanel.class, (String)"DLG_CustomScope"));
        this.outlineView1.setDefaultActionAllowed(false);
        this.outlineView1.setDoubleBuffered(true);
        this.outlineView1.setDragSource(false);
        this.outlineView1.setDropTarget(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.outlineView1, -1, 527, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.outlineView1, -1, 426, Short.MAX_VALUE).addContainerGap()));
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(CustomScopePanel.class, (String)"LBL_WaitNode");
        }
    }

    private static class ClassNode
    extends CustomNode {
        public ClassNode(ClassData data, CustomScopePanel panel) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{data}), panel, data);
            this.setDisplayName(data.getName());
            this.setIconBaseWithExtension(CustomScopePanel.CLASS);
        }
    }

    private static class PackageNode
    extends CustomNode {
        private final PackageData data;

        public PackageNode(PackageData data, CustomScopePanel panel) {
            super(PackageNode.createChildren(data, panel), Lookups.fixed((Object[])new Object[]{data}), panel, data);
            this.setDisplayName(data.getName().isEmpty() ? "<default package>" : data.getName());
            this.setIconBaseWithExtension(CustomScopePanel.PACKAGE);
            this.data = data;
        }

        private static Children createChildren(PackageData data, CustomScopePanel panel) {
            Children.Array childs = new Children.Array();
            for (ClassData classData : data.getClasses()) {
                childs.add(new Node[]{new ClassNode(classData, panel)});
            }
            return childs;
        }

        @Override
        public String getHtmlDisplayName() {
            String htmlDisplayName;
            String string = htmlDisplayName = this.data.getName().isEmpty() ? "&lt;default package&gt;" : this.data.getName();
            if (this.data.isSelected() == null) {
                htmlDisplayName = String.format("<font color=\"#0000E6\">%s</font>", htmlDisplayName);
            } else if (!this.data.isSelected().booleanValue()) {
                htmlDisplayName = String.format("<font color=\"#969696\">%s</font>", htmlDisplayName);
            }
            return htmlDisplayName;
        }
    }

    private static class SourceGroupNode
    extends CustomNode {
        private final SourceData data;

        public SourceGroupNode(SourceData data, CustomScopePanel panel) {
            super((Children)new Childs(data, panel), Lookups.fixed((Object[])new Object[]{data}), panel, data);
            this.data = data;
            this.setDisplayName(data.getName());
        }

        public Image getIcon(int type) {
            return this.data.getIcon();
        }

        public Image getOpenedIcon(int type) {
            return this.data.getOpenedIcon();
        }

        private static class Childs
        extends Children.Keys<String> {
            private final SourceData data;
            private final CustomScopePanel panel;

            public Childs(SourceData data, CustomScopePanel panel) {
                super(true);
                this.data = data;
                this.setKeys(data.getPackages().keySet());
                this.panel = panel;
            }

            protected Node[] createNodes(String key) {
                return new Node[]{new PackageNode(this.data.getPackages().get(key), this.panel)};
            }
        }
    }

    private static class ProjectNode
    extends CustomNode {
        private final ProjectData data;

        public ProjectNode(ProjectData data, CustomScopePanel panel) {
            super(ProjectNode.createChildren(data, panel), Lookups.fixed((Object[])new Object[]{data}), panel, data);
            this.data = data;
            this.setDisplayName(data.getName());
        }

        private static Children createChildren(ProjectData data, CustomScopePanel panel) {
            Children.Array childs = new Children.Array();
            for (SourceData sourceData : data.getSources()) {
                childs.add(new Node[]{new SourceGroupNode(sourceData, panel)});
            }
            return childs;
        }

        public Image getIcon(int type) {
            Icon icon = this.data.getIcon();
            if (icon instanceof ImageIcon) {
                return ((ImageIcon)icon).getImage();
            }
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            BufferedImage image = gc.createCompatibleImage(w, h);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            return image;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }

    private static abstract class CustomNode
    extends AbstractNode
    implements PropertyChangeListener {
        protected final CustomScopePanel panel;
        private final Data data;

        public CustomNode(Children children, Lookup lookup, CustomScopePanel panel, final Data data) {
            super(children, (Lookup)new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{new CheckableNode(){

                public boolean isCheckable() {
                    return true;
                }

                public boolean isCheckEnabled() {
                    return true;
                }

                public Boolean isSelected() {
                    return data.isSelected();
                }

                public void setSelected(Boolean selected) {
                    data.setSelected(selected);
                }
            }})}));
            data.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)data));
            this.panel = panel;
            this.data = data;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public String getHtmlDisplayName() {
            String htmlDisplayName;
            String string = htmlDisplayName = super.getHtmlDisplayName() == null ? this.getDisplayName() : super.getHtmlDisplayName();
            if (this.data.isSelected() == null) {
                htmlDisplayName = String.format("<font color=\"#0000E6\">%s</font>", htmlDisplayName);
            } else if (!this.data.isSelected().booleanValue()) {
                htmlDisplayName = String.format("<font color=\"#969696\">%s</font>", htmlDisplayName);
            }
            return htmlDisplayName;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selected")) {
                if (this.getParentNode() instanceof CustomNode) {
                    CustomNode customNode = (CustomNode)this.getParentNode();
                    this.fireParentsIconChanged(customNode);
                }
                this.fireChildsIconChanged(this.getChildren());
            }
        }

        private void fireParentsIconChanged(CustomNode parentNode) {
            parentNode.fireIconChange();
            if (parentNode.getParentNode() instanceof CustomNode) {
                CustomNode customNode = (CustomNode)parentNode.getParentNode();
                this.fireParentsIconChanged(customNode);
            }
        }

        private void fireChildsIconChanged(Children children) {
            for (Node node : children.getNodes()) {
                ((CustomNode)node).fireIconChange();
                this.fireChildsIconChanged(node.getChildren());
            }
        }
    }

    private static class ClassData
    extends Data {
        private SourceData source;
        private FileObject file;
        private final Set<FileObject> files;

        public ClassData(SourceData source, String name, FileObject file, Data parent, Set<FileObject> files) {
            super(name, parent);
            this.source = source;
            this.file = file;
            this.files = files;
        }

        public SourceData getSource() {
            return this.source;
        }

        public FileObject getFile() {
            return this.file;
        }

        @Override
        protected boolean isFullySelected() {
            return this.files.contains(this.file) || this.getParent().isFullySelected();
        }

        @Override
        protected boolean isPartiallySelected() {
            return false;
        }

        @Override
        protected void setSelected(boolean selected, boolean event) {
            if (selected) {
                this.files.add(this.file);
            } else if (this.files.contains(this.file)) {
                this.files.remove(this.file);
            } else if (this.isFullySelected()) {
                PackageData parent = (PackageData)this.getParent();
                parent.setSelected(false);
                List<ClassData> classes = parent.getClasses();
                for (ClassData classData : classes) {
                    if (classData == this) continue;
                    classData.setSelected(true);
                }
            }
        }
    }

    private static class PackageData
    extends Data {
        private SourceData source;
        private List<ClassData> classes = new LinkedList<ClassData>();
        private NonRecursiveFolder folder;
        private final Map<String, NonRecursiveFolder> folders;

        public PackageData(SourceData source, String name, Data parent, final FileObject folder, Map<String, NonRecursiveFolder> folders) {
            super(name, parent);
            this.source = source;
            this.folder = new NonRecursiveFolder(){

                public FileObject getFolder() {
                    return folder;
                }
            };
            this.folders = folders;
        }

        public List<ClassData> getClasses() {
            return this.classes;
        }

        public SourceData getSource() {
            return this.source;
        }

        @Override
        protected boolean isFullySelected() {
            return this.folders.containsKey(this.folder.getFolder().getPath()) || this.getParent().isFullySelected();
        }

        @Override
        protected boolean isPartiallySelected() {
            boolean selected = false;
            for (ClassData classData : this.classes) {
                if (!classData.isFullySelected() && !classData.isPartiallySelected()) continue;
                selected = true;
                break;
            }
            return selected;
        }

        @Override
        public void setSelected(boolean selected, boolean recursive) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!selected) break block2;
                            this.folders.put(this.folder.getFolder().getPath(), this.folder);
                            break block3;
                        }
                        if (!this.folders.containsKey(this.folder.getFolder().getPath())) break block4;
                        this.folders.remove(this.folder.getFolder().getPath());
                        break block3;
                    }
                    if (!this.isFullySelected()) break block5;
                    Data parent = this.getParent();
                    parent.setSelected(false);
                    for (Map.Entry<String, PackageData> entry : this.source.getPackages().entrySet()) {
                        PackageData packageData = entry.getValue();
                        if (packageData == this) continue;
                        packageData.setSelected(true);
                    }
                    break block3;
                }
                if (!this.isPartiallySelected()) break block3;
                for (ClassData classData : this.classes) {
                    classData.setSelected(false);
                }
            }
        }
    }

    private static class SourceData
    extends Data {
        private FileObject sourceRoot;
        private Image icon;
        private Image openedIcon;
        private Map<String, PackageData> packages = new TreeMap<String, PackageData>();
        private final Set<FileObject> sourceRoots;

        public SourceData(String name, Data parent, FileObject sourceRoot, Set<FileObject> sourceRoots) {
            super(name, parent);
            this.sourceRoot = sourceRoot;
            this.sourceRoots = sourceRoots;
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public Image getOpenedIcon() {
            return this.openedIcon;
        }

        public void setOpenedIcon(Image openedIcon) {
            this.openedIcon = openedIcon;
        }

        public Map<String, PackageData> getPackages() {
            return this.packages;
        }

        public FileObject getSourceRoot() {
            return this.sourceRoot;
        }

        @Override
        public void setSelected(boolean selected, boolean event) {
            if (selected) {
                this.sourceRoots.add(this.sourceRoot);
            } else if (this.sourceRoots.contains(this.sourceRoot)) {
                this.sourceRoots.remove(this.sourceRoot);
            } else if (this.isPartiallySelected()) {
                for (Map.Entry<String, PackageData> entry : this.getPackages().entrySet()) {
                    entry.getValue().setSelected(false);
                }
            }
        }

        @Override
        protected boolean isFullySelected() {
            return this.sourceRoots.contains(this.sourceRoot);
        }

        @Override
        protected boolean isPartiallySelected() {
            boolean selected = false;
            for (Map.Entry<String, PackageData> entry : this.packages.entrySet()) {
                if (!entry.getValue().isFullySelected() && !entry.getValue().isPartiallySelected()) continue;
                selected = true;
            }
            return selected;
        }
    }

    private static class ProjectData
    extends Data {
        private Icon icon;
        private List<SourceData> sources = new LinkedList<SourceData>();

        public ProjectData(String name, Data parent) {
            super(name, parent);
        }

        private void setIcon(Icon icon) {
            this.icon = icon;
        }

        private Icon getIcon() {
            return this.icon;
        }

        public List<SourceData> getSources() {
            return this.sources;
        }

        @Override
        protected boolean isFullySelected() {
            boolean selected = true;
            for (SourceData sourceData : this.sources) {
                if (sourceData.isFullySelected()) continue;
                selected = false;
            }
            return selected;
        }

        @Override
        protected boolean isPartiallySelected() {
            boolean selected = false;
            for (SourceData sourceData : this.sources) {
                if (!sourceData.isFullySelected() && !sourceData.isPartiallySelected()) continue;
                selected = true;
            }
            return selected;
        }

        @Override
        public void setSelected(boolean selected, boolean event) {
            for (SourceData sourceData : this.sources) {
                sourceData.setSelected(selected);
            }
        }
    }

    private static abstract class Data {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        public static final String PROP_SELECTED = "selected";
        private String name;
        private Data parent;

        public Data(String name, Data parent) {
            this.name = name;
            this.parent = parent;
        }

        public Boolean isSelected() {
            Object selected = this.isFullySelected() ? Boolean.valueOf(true) : (this.isPartiallySelected() ? null : Boolean.valueOf(false));
            return selected;
        }

        protected abstract boolean isFullySelected();

        protected abstract boolean isPartiallySelected();

        public void setSelected(boolean selected) {
            this.propertyChangeSupport.firePropertyChange(PROP_SELECTED, !Boolean.FALSE.equals(this.isSelected()), selected);
            this.setSelected(selected, true);
        }

        protected abstract void setSelected(boolean var1, boolean var2);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public String getName() {
            return this.name;
        }

        public Data getParent() {
            return this.parent;
        }
    }
}

