/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.Vector;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.WordDelineator;

class Buffer {
    private final OurVector<Line> lines = new OurVector();
    private int nlines;
    private int visible_cols;
    private int extra_cols;

    int nlines() {
        return this.nlines;
    }

    public int visibleCols() {
        return this.visible_cols;
    }

    public int totalCols() {
        return this.visible_cols + this.extra_cols;
    }

    public Buffer(int visible_cols) {
        this.visible_cols = visible_cols;
    }

    public void setVisibleCols(int visible_cols) {
        int delta = visible_cols - this.visible_cols;
        this.visible_cols = visible_cols;
        this.extra_cols -= delta;
        if (this.extra_cols < 0) {
            this.extra_cols = 0;
        }
    }

    public void noteColumn(int col) {
        int new_extra = col - this.visible_cols;
        if (new_extra > this.extra_cols) {
            this.extra_cols = new_extra;
        }
    }

    Line lineAt(int brow) {
        try {
            return (Line)this.lines.elementAt(brow);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return null;
        }
    }

    Line bottom() {
        return this.lineAt(this.nlines);
    }

    public Line appendLine() {
        Line l = new Line();
        this.lines.add(l);
        ++this.nlines;
        return l;
    }

    public Line addLineAt(int row) {
        Line l = new Line();
        this.lines.add(row, l);
        ++this.nlines;
        return l;
    }

    public int removeLinesAt(int row, int n) {
        int nchars = 0;
        for (int r = row; r < row + n; ++r) {
            nchars += this.lineAt(r).length() + 1;
        }
        this.lines.removeRange(row, row + n);
        this.nlines -= n;
        return nchars;
    }

    public void removeLineAt(int row) {
        this.lines.remove(row);
        --this.nlines;
    }

    public Line moveLineFromTo(int from, int to) {
        Line l = (Line)this.lines.remove(from);
        this.lines.add(to, l);
        return l;
    }

    void visitLines(BCoord begin, BCoord end, boolean newlines, LineVisitor visitor) {
        if (begin.row == end.row) {
            Line l = this.lineAt(begin.row);
            visitor.visit(l, begin.row, begin.col, end.col);
        } else {
            Line l = this.lineAt(begin.row);
            boolean cont = newlines && !l.isWrapped() ? visitor.visit(l, begin.row, begin.col, this.totalCols()) : visitor.visit(l, begin.row, begin.col, l.length() - 1);
            if (!cont) {
                return;
            }
            for (int r = begin.row + 1; r < end.row; ++r) {
                l = this.lineAt(r);
                cont = newlines && !l.isWrapped() ? visitor.visit(l, r, 0, this.totalCols()) : visitor.visit(l, r, 0, l.length() - 1);
                if (cont) continue;
                return;
            }
            l = this.lineAt(end.row);
            cont = visitor.visit(l, end.row, 0, end.col);
            if (!cont) {
                return;
            }
        }
    }

    void reverseVisitLines(BCoord begin, BCoord end, boolean newlines, LineVisitor visitor) {
        if (begin.row == end.row) {
            Line l = this.lineAt(begin.row);
            visitor.visit(l, begin.row, begin.col, end.col);
        } else {
            Line l = this.lineAt(end.row);
            boolean cont = visitor.visit(l, end.row, 0, end.col);
            if (!cont) {
                return;
            }
            for (int r = end.row - 1; r > begin.row; --r) {
                l = this.lineAt(r);
                cont = newlines && !l.isWrapped() ? visitor.visit(l, r, 0, this.totalCols()) : visitor.visit(l, r, 0, l.length() - 1);
                if (cont) continue;
                return;
            }
            l = this.lineAt(begin.row);
            cont = newlines && !l.isWrapped() ? visitor.visit(l, begin.row, begin.col, this.totalCols()) : visitor.visit(l, begin.row, begin.col, l.length() - 1);
            if (!cont) {
                return;
            }
        }
    }

    public BExtent find_line(BCoord coord) {
        WordDelineator newLine = WordDelineator.createNewlineDelineator();
        return this.find_word(newLine, coord);
    }

    public BExtent find_word(WordDelineator word_delineator, BCoord coord) {
        int searchCol;
        Line line;
        StringBuffer lineBuffer;
        int beginRow;
        int row = coord.row;
        Line startLine = this.lineAt(row);
        if (coord.col >= startLine.length()) {
            return new BExtent(coord, coord);
        }
        int lx = 0;
        int rx = 0;
        int endRow = row;
        for (beginRow = row; beginRow >= 0 && (lx = word_delineator.findLeft(lineBuffer = (line = this.lineAt(beginRow)).stringBuffer(), searchCol = lx == -1 ? line.length() - 1 : coord.col, true)) == -1; --beginRow) {
            if (beginRow == 0) {
                lx = 0;
                continue;
            }
            if (this.lineAt(beginRow - 1).isWrapped()) continue;
            lx = 0;
            break;
        }
        while (endRow < this.nlines && (rx = word_delineator.findRight(lineBuffer = (line = this.lineAt(endRow)).stringBuffer(), searchCol = rx == -1 ? 0 : coord.col, true)) == -1) {
            if (endRow == this.nlines - 1) {
                rx = line.length() - 1;
            }
            if (!line.isWrapped()) {
                rx = line.length() - 1;
                break;
            }
            ++endRow;
        }
        return new BExtent(new BCoord(beginRow, lx), new BCoord(endRow, rx));
    }

    public BCoord backup(BCoord c) {
        if (c.col > 0) {
            return new BCoord(c.row, c.col - 1);
        }
        for (int prevrow = c.row - 1; prevrow >= 0; --prevrow) {
            Line l = this.lineAt(prevrow);
            if (l.length() == 0) continue;
            return new BCoord(prevrow, l.length() - 1);
        }
        return null;
    }

    public BCoord advance(BCoord c) {
        int row = c.row;
        int col = c.col;
        Line l = this.lineAt(row);
        if (++col < l.length()) {
            return new BCoord(row, col);
        }
        while (++row < this.nlines) {
            l = this.lineAt(row);
            if (l.length() == 0) continue;
            return new BCoord(row, 0);
        }
        return null;
    }

    private int utilization(int nchars, int ncapacity) {
        float u = (float)nchars / (float)ncapacity;
        float p = u * 100.0f;
        return (int)p;
    }

    public void printStats(boolean indented) {
        int chars = 0;
        int charcapacity = 0;
        int nalines = 0;
        int attrs = 0;
        int attrcapacity = 0;
        for (int lx = 0; lx < this.nlines; ++lx) {
            Line l = this.lineAt(lx);
            chars += l.length();
            charcapacity += l.capacity();
            if (!l.hasAttributes()) continue;
            ++nalines;
            attrs += l.length();
            attrcapacity += l.capacity();
        }
        Term.indent(indented);
        System.out.println("Buffer:  nlines " + this.nlines);
        Term.indent(indented);
        System.out.println("         chars " + chars + "  charcapacity " + charcapacity + "  utilzn %" + this.utilization(chars, charcapacity));
        Term.indent(indented);
        System.out.println("         attrs " + attrs + "  attrcapacity " + attrcapacity + "  utilzn %" + this.utilization(attrs, attrcapacity));
        int unitObjectSz = 8;
        int unitReferenceSz = 4;
        int unitBooleanSz = 4;
        int unitCharSz = 2;
        int unitIntSz = 4;
        int unitCharArraySz = 12;
        int unitIntArraySz = 12;
        long bytes = 0L;
        long unitLineSz = 40L;
        bytes += unitLineSz * (long)this.nlines;
        bytes += (long)(12 * this.nlines);
        bytes += (long)(2 * charcapacity);
        bytes += (long)(12 * nalines);
        Term.indent(indented);
        System.out.println("         bytes " + (bytes += (long)(4 * attrcapacity)) / 1024L + "K");
    }

    private static class OurVector<T>
    extends Vector<T> {
        private OurVector() {
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

