/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class WagonHelper {
    private final Injector injector;

    public WagonHelper(Injector injector) {
        this.injector = injector;
    }

    public WagonFetcher getWagonResourceFetcher(TransferListener listener) {
        return this.getWagonResourceFetcher(listener, null, null);
    }

    public WagonFetcher getWagonResourceFetcher(TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
        return new WagonFetcher((Wagon)this.injector.getInstance(Key.get(Wagon.class, (Annotation)Names.named((String)"http"))), listener, authenticationInfo, proxyInfo);
    }

    public WagonFetcher getWagonResourceFetcher(TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo, String protocol) {
        return new WagonFetcher((Wagon)this.injector.getInstance(Key.get(Wagon.class, (Annotation)Names.named((String)protocol))), listener, authenticationInfo, proxyInfo);
    }

    public static class WagonFetcher
    implements ResourceFetcher {
        private final TransferListener listener;
        private final AuthenticationInfo authenticationInfo;
        private final ProxyInfo proxyInfo;
        private final Wagon wagon;

        public WagonFetcher(Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
            this.wagon = wagon;
            this.listener = listener;
            this.authenticationInfo = authenticationInfo;
            this.proxyInfo = proxyInfo;
        }

        @Override
        public void connect(String id, String url) throws IOException {
            Repository repository = new Repository(id, url);
            try {
                if (this.listener != null) {
                    this.wagon.addTransferListener(this.listener);
                }
                if (this.authenticationInfo != null) {
                    if (this.proxyInfo != null) {
                        this.wagon.connect(repository, this.authenticationInfo, this.proxyInfo);
                    } else {
                        this.wagon.connect(repository, this.authenticationInfo);
                    }
                } else if (this.proxyInfo != null) {
                    this.wagon.connect(repository, this.proxyInfo);
                } else {
                    this.wagon.connect(repository);
                }
            }
            catch (AuthenticationException ex) {
                String msg = "Authentication exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
            catch (WagonException ex) {
                String msg = "Wagon exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
        }

        @Override
        public void disconnect() throws IOException {
            if (this.wagon != null) {
                try {
                    this.wagon.disconnect();
                }
                catch (ConnectionException ex) {
                    throw new IOException(ex.toString(), ex);
                }
            }
        }

        @Override
        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            final File target = Files.createTempFile(name, "tmp", new FileAttribute[0]).toFile();
            target.deleteOnExit();
            this.retrieve(name, target);
            return new FileInputStream(target){

                @Override
                public void close() throws IOException {
                    super.close();
                    target.delete();
                }
            };
        }

        public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
            try {
                this.wagon.get(name, targetFile);
            }
            catch (AuthorizationException e) {
                targetFile.delete();
                String msg = "Authorization exception retrieving " + name;
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg, e);
            }
            catch (ResourceDoesNotExistException e) {
                targetFile.delete();
                String msg = "Resource " + name + " does not exist";
                this.logError(msg, (Exception)((Object)e));
                FileNotFoundException fileNotFoundException = new FileNotFoundException(msg);
                fileNotFoundException.initCause(e);
                throw fileNotFoundException;
            }
            catch (WagonException e) {
                targetFile.delete();
                String msg = "Transfer for " + name + " failed";
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg + "; " + e.getMessage(), e);
            }
        }

        private void logError(String msg, Exception ex) {
            if (this.listener != null) {
                this.listener.debug(msg + "; " + ex.getMessage());
            }
        }
    }
}

