/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class FSCompletionUtils {
    static final String GO_UP = "../";
    private static final String SLASH = "/";
    private static final String FILE = "file";
    private static final Logger LOG = Logger.getLogger(FSCompletionUtils.class.getName());

    /*
     * WARNING - void declaration
     */
    public static List<CompletionProposal> computeRelativeItems(Collection<? extends FileObject> relativeTo, String prefix, int anchor, boolean addExtensions, boolean addRelativePrefix, FileObjectFilter filter) throws IOException {
        String filePrefix;
        String pathPrefix;
        assert (relativeTo != null);
        LinkedList<CompletionProposal> result = new LinkedList<CompletionProposal>();
        int lastSlash = prefix.lastIndexOf(47);
        if (lastSlash != -1) {
            pathPrefix = prefix.substring(0, lastSlash);
            filePrefix = prefix.substring(lastSlash + 1);
        } else {
            pathPrefix = null;
            filePrefix = prefix;
        }
        HashSet<Object> directories = new HashSet<Object>();
        File prefixFile = null;
        if (pathPrefix != null && !pathPrefix.startsWith(".")) {
            prefixFile = pathPrefix.length() == 0 && prefix.startsWith(SLASH) ? new File(SLASH) : new File(pathPrefix);
        }
        if (prefixFile != null && prefixFile.exists()) {
            File normalizeFile = FileUtil.normalizeFile((File)prefixFile);
            FileObject fileObject = FileUtil.toFileObject((File)normalizeFile);
            if (fileObject != null) {
                directories.add(fileObject);
            }
        } else {
            for (FileObject fileObject : relativeTo) {
                void var13_14;
                if (pathPrefix != null) {
                    File toFile = FileUtil.toFile((FileObject)fileObject);
                    if (toFile != null) {
                        URI resolve = null;
                        try {
                            resolve = BaseUtilities.normalizeURI((URI)Utilities.toURI((File)toFile).resolve(pathPrefix));
                        }
                        catch (IllegalArgumentException ex) {
                            resolve = null;
                        }
                        if (resolve != null && (resolve.getScheme() == null || FILE.equals(resolve.getScheme()))) {
                            try {
                                File normalizedFile = FileUtil.normalizeFile((File)Utilities.toFile((URI)resolve));
                                FileObject fileObject2 = FileUtil.toFileObject((File)normalizedFile);
                            }
                            catch (IllegalArgumentException e) {
                                LOG.log(Level.FINE, "could not convert " + resolve + " to File", resolve);
                            }
                        }
                    } else {
                        FileObject fileObject3 = fileObject.getFileObject(pathPrefix);
                    }
                }
                if (var13_14 == null) continue;
                directories.add(var13_14);
            }
        }
        for (FileObject fileObject : directories) {
            FileObject[] children = fileObject.getChildren();
            for (int cntr = 0; cntr < children.length; ++cntr) {
                FileObject current = children[cntr];
                if (!VisibilityQuery.getDefault().isVisible(current) || !current.getNameExt().toLowerCase().startsWith(filePrefix.toLowerCase()) || !filter.accept(current)) continue;
                int newAnchor = anchor - prefix.length();
                result.add(new FSCompletionItem(current, pathPrefix != null ? pathPrefix + SLASH : (filePrefix.isEmpty() && addRelativePrefix ? "./" : ""), addExtensions, newAnchor));
            }
        }
        return result;
    }

    public static FileObject findMappedFileObject(String pathToFile, FileObject parent) {
        String path = pathToFile;
        String[] pathParts = path.split(SLASH);
        FileObject result = null;
        if (parent != null && pathParts.length > 0) {
            if (pathParts[pathParts.length - 1].indexOf(46) > 0 && (result = FSCompletionUtils.findFileObject(parent, path, true)) != null) {
                return result;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)parent);
            RequireJsIndex rIndex = null;
            try {
                rIndex = RequireJsIndex.get(project);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Collection<Object> basePaths = new ArrayList();
            Map<Object, Object> configPaths = new HashMap();
            if (rIndex != null) {
                basePaths = rIndex.getBasePaths();
                configPaths = rIndex.getPathMappings(basePaths.isEmpty() ? pathParts[0] : "");
            }
            String alias = "";
            for (String possibleAlias : configPaths.keySet()) {
                if (possibleAlias.equals(pathToFile)) {
                    alias = possibleAlias;
                    break;
                }
                if (!path.startsWith(possibleAlias) || alias.length() >= possibleAlias.length()) continue;
                alias = possibleAlias;
            }
            if (!alias.isEmpty()) {
                path = (String)configPaths.get(alias) + pathToFile.substring(alias.length());
                if (basePaths.isEmpty() && (result = FSCompletionUtils.findFileObject(parent, FSCompletionUtils.composePath(path), false)) != null) {
                    return result;
                }
            }
            for (Object value : basePaths) {
                String composedPath = FSCompletionUtils.composePath(new String[]{value, path});
                result = FSCompletionUtils.findFileObject(parent, composedPath, false);
                if (result == null) continue;
                return result;
            }
            Map<String, String> pathMappings = RequireJsPreferences.getMappings(project);
            alias = "";
            for (String possibleAlias : pathMappings.keySet()) {
                if (possibleAlias.equals(pathToFile)) {
                    alias = possibleAlias;
                    break;
                }
                if (!pathToFile.startsWith(possibleAlias) || alias.length() >= possibleAlias.length()) continue;
                alias = possibleAlias;
            }
            if (!alias.isEmpty()) {
                path = pathMappings.get(alias) + pathToFile.substring(alias.length());
                result = FSCompletionUtils.findFileObject(parent, FSCompletionUtils.composePath(path), true);
                if (result != null) {
                    return result;
                }
                String projectDirectoryPath = project.getProjectDirectory().getPath();
                for (FileObject parentFO = parent; parentFO != null && parentFO.getPath().contains(projectDirectoryPath); parentFO = parentFO.getParent()) {
                    result = parentFO.getFileObject(path);
                    if (result == null) continue;
                    return result;
                }
            }
            result = FSCompletionUtils.findFileObject(parent, FSCompletionUtils.composePath(pathToFile), true);
        }
        return result;
    }

    public static FileObject findFileObject(FileObject fromFO, String path, boolean filesOnly) {
        List<FileObject> fromOtherRoots;
        FileObject parent = fromFO.getParent();
        Project project = FileOwnerQuery.getOwner((FileObject)fromFO);
        String projectDirectoryPath = "";
        if (project != null) {
            FileObject projectDirectory = project.getProjectDirectory();
            projectDirectoryPath = projectDirectory.getPath();
        }
        if (parent != null && !path.isEmpty()) {
            while (parent != null && parent.getPath().contains(projectDirectoryPath)) {
                FileObject targetFO = parent.getFileObject(path);
                if (targetFO != null && (!filesOnly || filesOnly && !targetFO.isFolder())) {
                    return targetFO;
                }
                targetFO = parent.getFileObject(path + ".js");
                if (targetFO != null) {
                    return targetFO;
                }
                parent = parent.getParent();
            }
        }
        if (!(fromOtherRoots = FSCompletionUtils.findFileObjects(project, path, filesOnly)).isEmpty()) {
            return fromOtherRoots.get(0);
        }
        return null;
    }

    private static List<FileObject> findFileObjects(Project project, String path, boolean filesOnly) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        RequireJsIndex index = null;
        try {
            index = RequireJsIndex.get(project);
        }
        catch (IOException ex) {
            Logger.getLogger(FSCompletionUtils.class.getName()).info("Cannot get RequireJS index.");
        }
        if (index != null && !path.isEmpty()) {
            HashSet<String> sourceRoots = new HashSet<String>();
            ArrayList<String> modulePaths = new ArrayList<String>();
            Map<String, String> packages = index.getPackages();
            Collection<String> basePaths = index.getBasePaths();
            sourceRoots.addAll(index.getSourceRoots());
            if (!packages.isEmpty()) {
                int slashIndex;
                String pkgName;
                String requiredPath = path;
                if (path.startsWith("./")) {
                    requiredPath = path.substring(2, path.length());
                }
                if (requiredPath.contains(SLASH) && packages.get(pkgName = requiredPath.substring(0, slashIndex = requiredPath.indexOf(SLASH))) != null) {
                    requiredPath = packages.get(pkgName) + File.separator + requiredPath.substring(slashIndex + 1, requiredPath.length());
                }
                if (!basePaths.isEmpty() && !requiredPath.startsWith(SLASH)) {
                    for (String bp : basePaths) {
                        modulePaths.add(bp + File.separator + requiredPath);
                    }
                } else {
                    modulePaths.add(requiredPath);
                }
            }
            if (modulePaths.isEmpty()) {
                modulePaths.add(path);
            }
            for (String rootName : sourceRoots) {
                FileObject root = project.getProjectDirectory().getFileObject(rootName);
                if (root == null) continue;
                for (String mp : modulePaths) {
                    FileObject targetFO = root.getFileObject(mp);
                    if (targetFO != null && (!filesOnly || filesOnly && !targetFO.isFolder())) {
                        result.add(targetFO);
                    }
                    if ((targetFO = root.getFileObject(mp + ".js")) == null) continue;
                    result.add(targetFO);
                }
            }
        }
        return result;
    }

    private static String composePath(String ... parts) {
        StringBuilder result = new StringBuilder();
        String lastPart = "";
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (!lastPart.isEmpty() && lastPart.charAt(lastPart.length() - 1) != '/' && part.charAt(0) != '/') {
                result.append('/');
            }
            result.append(part);
            lastPart = part;
        }
        return result.toString();
    }

    public static boolean containsPlugin(String path) {
        int index1 = path.indexOf(33);
        if (index1 == -1) {
            return false;
        }
        int index2 = path.indexOf(47);
        if (index2 == -1) {
            index2 = path.indexOf(46);
        }
        return index2 == -1 || index1 < index2;
    }

    public static String removePlugin(String path) {
        return FSCompletionUtils.containsPlugin(path) ? path.substring(path.indexOf(33) + 1) : path;
    }

    public static String writeFilePathForDocWindow(FileObject fo) {
        String path = fo.getPath();
        String[] parts = path.split(SLASH);
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        int length = 0;
        for (String part : parts) {
            if (length + part.length() > 50) {
                sb.append("\n    ");
                length = 4;
            }
            sb.append(part).append('/');
            length += part.length() + 1;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("</pre>");
        return sb.toString();
    }

    static interface FileObjectFilter {
        public boolean accept(FileObject var1);
    }

    public static class JSIncludesFilter
    implements FileObjectFilter {
        private FileObject currentFile;

        public JSIncludesFilter(FileObject currentFile) {
            this.currentFile = currentFile;
        }

        @Override
        public boolean accept(FileObject file) {
            if (file.equals(this.currentFile) || JSIncludesFilter.isNbProjectMetadata(file)) {
                return false;
            }
            if (file.isFolder()) {
                return true;
            }
            String mimeType = FileUtil.getMIMEType((FileObject)file);
            return mimeType != null && mimeType.startsWith("text/");
        }

        private static boolean isNbProjectMetadata(FileObject fo) {
            String metadataName = "nbproject";
            if (fo.getPath().indexOf("nbproject") != -1) {
                while (fo != null) {
                    if (fo.isFolder() && "nbproject".equals(fo.getNameExt())) {
                        return true;
                    }
                    fo = fo.getParent();
                }
            }
            return false;
        }
    }
}

