/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import org.netbeans.modules.css.lib.api.CssTokenId;

public class Token {
    private int offset;
    private int length;
    private CssTokenId tokenId;
    private CharSequence tokenizerInput;

    public Token(CssTokenId tokenId, int offset, int length, CharSequence tokenizerInput) {
        this.tokenId = tokenId;
        this.offset = offset;
        this.length = length;
        this.tokenizerInput = tokenizerInput;
    }

    public CssTokenId tokenId() {
        return this.tokenId;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public CharSequence image() {
        return this.tokenizerInput.subSequence(this.offset, this.offset + this.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.image());
        sb.append('(');
        sb.append((Object)this.tokenId);
        sb.append(';');
        sb.append(this.offset());
        sb.append('-');
        sb.append(this.offset() + this.length());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.tokenId == other.tokenId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.offset;
        hash = 89 * hash + this.length;
        hash = 89 * hash + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return hash;
    }
}

