/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing;

import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import lombok.NonNull;

@Priority(value=1000)
public class RequestSigningFilter
extends AuthnClientFilter {
    public RequestSigningFilter(@NonNull RequestSigner requestSigner, @NonNull Map<SigningStrategy, RequestSigner> requestSigners) {
        super(requestSigner, requestSigners);
        if (requestSigner == null) {
            throw new NullPointerException("requestSigner is marked non-null but is null");
        }
        if (requestSigners == null) {
            throw new NullPointerException("requestSigners is marked non-null but is null");
        }
    }

    public RequestSigningFilter(@NonNull RequestSigner requestSigner) {
        this(requestSigner, (Map<SigningStrategy, RequestSigner>)ImmutableMap.of());
        if (requestSigner == null) {
            throw new NullPointerException("requestSigner is marked non-null but is null");
        }
    }

    public static RequestSigningFilter fromAuthProvider(@NonNull BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        return new RequestSigningFilter(DefaultRequestSigner.createRequestSigner(authenticationDetailsProvider));
    }

    public static RequestSigningFilter fromConfigFile(@NonNull String configurationFilePath, @Nullable String profile) throws IOException {
        if (configurationFilePath == null) {
            throw new NullPointerException("configurationFilePath is marked non-null but is null");
        }
        return RequestSigningFilter.fromAuthProvider(new ConfigFileAuthenticationDetailsProvider(configurationFilePath, profile));
    }

    @Override
    public void filter(@NonNull ClientRequestContext requestContext) throws IOException {
        if (requestContext == null) {
            throw new NullPointerException("requestContext is marked non-null but is null");
        }
        super.filter(requestContext);
        requestContext.getHeaders().putSingle((Object)"User-Agent", (Object)(ClientRuntime.getRuntime().getUserAgent() + " RequestSigningFilter"));
    }
}

