/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import com.oracle.bmc.io.DuplicatableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedFileInputStream
extends FileInputStream
implements DuplicatableInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedFileInputStream.class);
    private final File sourceFile;
    private long markPosition = 0L;

    public WrappedFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.sourceFile = file;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPosition = super.getChannel().position();
            LOG.trace("mark called, markPosition={}", (Object)this.markPosition);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not mark position");
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        LOG.trace("reset called, markPosition={}", (Object)this.markPosition);
        super.getChannel().position(this.markPosition);
    }

    @Override
    public InputStream duplicate() {
        return WrappedFileInputStream.create(this.sourceFile);
    }

    public static WrappedFileInputStream create(File file) {
        try {
            return new WrappedFileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found", e);
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

