/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.paginator.internal;

import com.google.common.base.Function;
import com.oracle.bmc.paginator.internal.AbstractResponseIterator;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ResponseRecordIterator<REQUESTBUILDER, REQUEST, RESPONSE, ITEMTYPE>
extends AbstractResponseIterator<REQUESTBUILDER, REQUEST, RESPONSE>
implements Iterator<ITEMTYPE> {
    private final Function<RESPONSE, List<ITEMTYPE>> retrieveItemsFromResponseFunction;
    private List<ITEMTYPE> currentItems;
    private Iterator<ITEMTYPE> currentIterator;

    public ResponseRecordIterator(REQUESTBUILDER requestBuilder, Function<RESPONSE, String> nextPageTokenRetrievalFunction, Function<RequestBuilderAndToken<REQUESTBUILDER>, REQUEST> requestBuilderFunction, Function<REQUEST, RESPONSE> pageRetrievalFunction, Function<RESPONSE, List<ITEMTYPE>> retrieveItemsFromResponseFunction) {
        super(requestBuilder, nextPageTokenRetrievalFunction, requestBuilderFunction, pageRetrievalFunction);
        this.retrieveItemsFromResponseFunction = retrieveItemsFromResponseFunction;
    }

    @Override
    public ITEMTYPE next() {
        if (this.currentResponse == null) {
            this.getFirstPage();
        }
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException("There are no more elements available to this iterator");
    }

    @Override
    public boolean hasNext() {
        if (this.currentResponse == null) {
            this.getFirstPage();
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        if (this.nextPageToken == null) {
            return false;
        }
        this.getNextPage();
        while (this.currentItems.isEmpty() && this.nextPageToken != null) {
            this.getNextPage();
        }
        return this.currentIterator.hasNext();
    }

    private void getNextPage() {
        this.fetchNextPage();
        this.currentItems = (List)this.retrieveItemsFromResponseFunction.apply(this.currentResponse);
        this.currentIterator = this.currentItems.iterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal is not supported");
    }

    private void getFirstPage() {
        RequestBuilderAndToken<Object> requestBuilderAndToken = new RequestBuilderAndToken<Object>(this.requestBuilder, null);
        this.currentResponse = this.pageRetrievalFunction.apply(this.requestBuilderFunction.apply(requestBuilderAndToken));
        this.nextPageToken = (String)this.nextPageTokenRetrievalFunction.apply(this.currentResponse);
        this.currentItems = (List)this.retrieveItemsFromResponseFunction.apply(this.currentResponse);
        this.currentIterator = this.currentItems.iterator();
    }
}

