/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.convertor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.project.uiapi.ProjectConvertorServiceFactory;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class DefaultProjectConvertorServices
implements ProjectConvertorServiceFactory {
    @Override
    public Collection<?> createServices(@NonNull Project project, @NonNull ProjectConvertor.Result result) {
        return Collections.singleton(new ProjectInfo(project, result));
    }

    private static final class ProjectInfo
    implements ProjectInformation,
    LookupListener {
        private final Project project;
        private final ProjectConvertor.Result result;
        private final PropertyChangeSupport pcs;
        private final Lookup.Result<ProjectInformation> eventSource;
        private volatile ProjectInformation delegate;

        ProjectInfo(@NonNull Project project, @NonNull ProjectConvertor.Result result) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.project = project;
            this.result = result;
            this.pcs = new PropertyChangeSupport(this);
            this.eventSource = project.getLookup().lookupResult(ProjectInformation.class);
            this.eventSource.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.eventSource));
        }

        @NonNull
        public String getName() {
            ProjectInformation d = this.delegate;
            return d != null ? d.getName() : this.project.getProjectDirectory().getName();
        }

        @NonNull
        public String getDisplayName() {
            ProjectInformation d = this.delegate;
            if (d != null) {
                return d.getDisplayName();
            }
            String res = this.result.getDisplayName();
            if (res == null) {
                res = this.getName();
            }
            return res;
        }

        @NonNull
        public Icon getIcon() {
            ProjectInformation d = this.delegate;
            if (d != null) {
                return d.getIcon();
            }
            Icon res = this.result.getIcon();
            return res;
        }

        @NonNull
        public Project getProject() {
            ProjectInformation d = this.delegate;
            if (d != null) {
                return d.getProject();
            }
            return this.project;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.pcs.removePropertyChangeListener(listener);
        }

        public void resultChanged(LookupEvent ev) {
            ProjectInformation instance;
            Collection instances = this.eventSource.allInstances();
            if (!instances.isEmpty() && (instance = (ProjectInformation)instances.iterator().next()) != this) {
                this.delegate = instance;
                this.pcs.firePropertyChange("name", null, null);
                this.pcs.firePropertyChange("displayName", null, null);
                this.pcs.firePropertyChange("icon", null, null);
            }
        }
    }
}

