/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeletePolicyRequest
extends BmcRequest<Void> {
    private String policyId;
    private String ifMatch;

    @ConstructorProperties(value={"policyId", "ifMatch"})
    DeletePolicyRequest(String policyId, String ifMatch) {
        this.policyId = policyId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().policyId(this.policyId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeletePolicyRequest(super=" + super.toString() + ", policyId=" + this.getPolicyId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeletePolicyRequest)) {
            return false;
        }
        DeletePolicyRequest other = (DeletePolicyRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeletePolicyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeletePolicyRequest, Void> {
        private String policyId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePolicyRequest build() {
            DeletePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeletePolicyRequest buildWithoutInvocationCallback() {
            return new DeletePolicyRequest(this.policyId, this.ifMatch);
        }

        public String toString() {
            return "DeletePolicyRequest.Builder(policyId=" + this.policyId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

