/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.UpdateOAuth2ClientCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateOAuthClientCredentialRequest
extends BmcRequest<UpdateOAuth2ClientCredentialDetails> {
    private String userId;
    private String oauth2ClientCredentialId;
    private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails;
    private String ifMatch;

    @InternalSdk
    public UpdateOAuth2ClientCredentialDetails getBody$() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    @ConstructorProperties(value={"userId", "oauth2ClientCredentialId", "updateOAuth2ClientCredentialDetails", "ifMatch"})
    UpdateOAuthClientCredentialRequest(String userId, String oauth2ClientCredentialId, UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails, String ifMatch) {
        this.userId = userId;
        this.oauth2ClientCredentialId = oauth2ClientCredentialId;
        this.updateOAuth2ClientCredentialDetails = updateOAuth2ClientCredentialDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).oauth2ClientCredentialId(this.oauth2ClientCredentialId).updateOAuth2ClientCredentialDetails(this.updateOAuth2ClientCredentialDetails).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "UpdateOAuthClientCredentialRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", oauth2ClientCredentialId=" + this.getOauth2ClientCredentialId() + ", updateOAuth2ClientCredentialDetails=" + this.getUpdateOAuth2ClientCredentialDetails() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateOAuthClientCredentialRequest)) {
            return false;
        }
        UpdateOAuthClientCredentialRequest other = (UpdateOAuthClientCredentialRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$oauth2ClientCredentialId = this.getOauth2ClientCredentialId();
        String other$oauth2ClientCredentialId = other.getOauth2ClientCredentialId();
        if (this$oauth2ClientCredentialId == null ? other$oauth2ClientCredentialId != null : !this$oauth2ClientCredentialId.equals(other$oauth2ClientCredentialId)) {
            return false;
        }
        UpdateOAuth2ClientCredentialDetails this$updateOAuth2ClientCredentialDetails = this.getUpdateOAuth2ClientCredentialDetails();
        UpdateOAuth2ClientCredentialDetails other$updateOAuth2ClientCredentialDetails = other.getUpdateOAuth2ClientCredentialDetails();
        if (this$updateOAuth2ClientCredentialDetails == null ? other$updateOAuth2ClientCredentialDetails != null : !((Object)this$updateOAuth2ClientCredentialDetails).equals(other$updateOAuth2ClientCredentialDetails)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateOAuthClientCredentialRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $oauth2ClientCredentialId = this.getOauth2ClientCredentialId();
        result = result * 59 + ($oauth2ClientCredentialId == null ? 43 : $oauth2ClientCredentialId.hashCode());
        UpdateOAuth2ClientCredentialDetails $updateOAuth2ClientCredentialDetails = this.getUpdateOAuth2ClientCredentialDetails();
        result = result * 59 + ($updateOAuth2ClientCredentialDetails == null ? 43 : ((Object)$updateOAuth2ClientCredentialDetails).hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public UpdateOAuth2ClientCredentialDetails getUpdateOAuth2ClientCredentialDetails() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateOAuthClientCredentialRequest, UpdateOAuth2ClientCredentialDetails> {
        private String userId;
        private String oauth2ClientCredentialId;
        private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.updateOAuth2ClientCredentialDetails(o.getUpdateOAuth2ClientCredentialDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateOAuthClientCredentialRequest build() {
            UpdateOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateOAuth2ClientCredentialDetails body) {
            this.updateOAuth2ClientCredentialDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder updateOAuth2ClientCredentialDetails(UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails) {
            this.updateOAuth2ClientCredentialDetails = updateOAuth2ClientCredentialDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            return new UpdateOAuthClientCredentialRequest(this.userId, this.oauth2ClientCredentialId, this.updateOAuth2ClientCredentialDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateOAuthClientCredentialRequest.Builder(userId=" + this.userId + ", oauth2ClientCredentialId=" + this.oauth2ClientCredentialId + ", updateOAuth2ClientCredentialDetails=" + this.updateOAuth2ClientCredentialDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

