/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.HashSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.EjbSupport;
import org.netbeans.modules.javaee.specs.support.api.JpaSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;

public final class J2eeProjectCapabilities {
    private final Project project;
    private final J2eeModuleProvider provider;
    private final Profile ejbJarProfile;
    private final Profile webProfile;
    private final Profile carProfile;

    private J2eeProjectCapabilities(Project project, J2eeModuleProvider provider, Profile ejbJarProfile, Profile webProfile, Profile carProfile) {
        this.project = project;
        this.provider = provider;
        this.ejbJarProfile = ejbJarProfile;
        this.webProfile = webProfile;
        this.carProfile = carProfile;
    }

    @CheckForNull
    public static J2eeProjectCapabilities forProject(@NonNull Project project) {
        Car car;
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider == null) {
            return null;
        }
        Profile ejbJarProfile = null;
        Profile webProfile = null;
        Profile carProfile = null;
        if (provider.getJ2eeModule().getType() == J2eeModule.Type.EJB || provider.getJ2eeModule().getType() == J2eeModule.Type.WAR) {
            WebModule module;
            EjbJar[] ejbJars = EjbJar.getEjbJars((Project)project);
            if (ejbJars.length > 0) {
                ejbJarProfile = ejbJars[0].getJ2eeProfile();
            }
            if (provider.getJ2eeModule().getType() == J2eeModule.Type.WAR && (module = WebModule.getWebModule((FileObject)project.getProjectDirectory())) != null) {
                webProfile = module.getJ2eeProfile();
            }
        }
        if (provider.getJ2eeModule().getType() == J2eeModule.Type.CAR && (car = Car.getCar((FileObject)project.getProjectDirectory())) != null) {
            carProfile = car.getJ2eeProfile();
        }
        return new J2eeProjectCapabilities(project, provider, ejbJarProfile, webProfile, carProfile);
    }

    public boolean isEjb30Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean eeOk = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_5) || this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL) || this.ejbJarProfile.equals(Profile.JAVA_EE_7_FULL) || this.ejbJarProfile.equals(Profile.JAVA_EE_8_FULL) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_8_FULL));
        return J2eeModule.Type.EJB.equals(moduleType) && eeOk;
    }

    public boolean isEjb31Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee6or7 = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL) || this.ejbJarProfile.equals(Profile.JAVA_EE_7_FULL) || this.ejbJarProfile.equals(Profile.JAVA_EE_8_FULL) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_8_FULL));
        return ee6or7 && (J2eeModule.Type.EJB.equals(moduleType) || J2eeModule.Type.WAR.equals(moduleType));
    }

    public boolean isEjb31LiteSupported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee6or7Web = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_6_WEB) || this.ejbJarProfile.equals(Profile.JAVA_EE_7_WEB) || this.ejbJarProfile.equals(Profile.JAVA_EE_8_WEB) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_8_WEB));
        return this.isEjb31Supported() || J2eeModule.Type.WAR.equals(moduleType) && ee6or7Web;
    }

    public boolean isEjb32Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee7 = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_7_FULL) || this.ejbJarProfile.equals(Profile.JAVA_EE_8_FULL) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_8_FULL));
        return ee7 && (J2eeModule.Type.EJB.equals(moduleType) || J2eeModule.Type.WAR.equals(moduleType));
    }

    public boolean isEjb32LiteSupported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee7Web = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_7_WEB) || this.ejbJarProfile.equals(Profile.JAVA_EE_8_WEB) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_8_WEB));
        return this.isEjb32Supported() || J2eeModule.Type.WAR.equals(moduleType) && ee7Web;
    }

    public boolean isEjb40Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee9 = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAKARTA_EE_9_FULL) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_9_1_FULL) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_10_FULL));
        return ee9 && (J2eeModule.Type.EJB.equals(moduleType) || J2eeModule.Type.WAR.equals(moduleType));
    }

    public boolean isEjb40LiteSupported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee9Web = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAKARTA_EE_9_WEB) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_9_1_WEB) || this.ejbJarProfile.equals(Profile.JAKARTA_EE_10_WEB));
        return this.isEjb40Supported() || J2eeModule.Type.WAR.equals(moduleType) && ee9Web;
    }

    public boolean isCdi10Supported() {
        return Profile.JAVA_EE_6_FULL.equals(this.ejbJarProfile) || Profile.JAVA_EE_6_WEB.equals(this.webProfile) || Profile.JAVA_EE_6_FULL.equals(this.ejbJarProfile);
    }

    public boolean isCdi11Supported() {
        return Profile.JAKARTA_EE_9_FULL.equals(this.ejbJarProfile) || Profile.JAKARTA_EE_8_FULL.equals(this.ejbJarProfile) || Profile.JAVA_EE_8_FULL.equals(this.ejbJarProfile) || Profile.JAVA_EE_8_WEB.equals(this.webProfile) || Profile.JAVA_EE_7_FULL.equals(this.ejbJarProfile) || Profile.JAVA_EE_7_WEB.equals(this.webProfile) || Profile.JAVA_EE_7_FULL.equals(this.carProfile) || Profile.JAVA_EE_8_FULL.equals(this.carProfile);
    }

    public boolean isCdi20Supported() {
        return Profile.JAVA_EE_8_FULL.equals(this.ejbJarProfile) || Profile.JAVA_EE_8_WEB.equals(this.webProfile) || Profile.JAVA_EE_8_FULL.equals(this.carProfile) || Profile.JAKARTA_EE_8_FULL.equals(this.ejbJarProfile) || Profile.JAKARTA_EE_8_WEB.equals(this.webProfile) || Profile.JAKARTA_EE_8_FULL.equals(this.carProfile);
    }

    public boolean isCdi30Supported() {
        return Profile.JAKARTA_EE_9_FULL.equals(this.ejbJarProfile) || Profile.JAKARTA_EE_9_WEB.equals(this.webProfile) || Profile.JAKARTA_EE_9_FULL.equals(this.carProfile) || Profile.JAKARTA_EE_9_1_FULL.equals(this.ejbJarProfile) || Profile.JAKARTA_EE_9_1_WEB.equals(this.webProfile) || Profile.JAKARTA_EE_9_1_FULL.equals(this.carProfile);
    }

    public boolean isCdi40Supported() {
        return Profile.JAKARTA_EE_10_FULL.equals(this.ejbJarProfile) || Profile.JAKARTA_EE_10_WEB.equals(this.webProfile) || Profile.JAKARTA_EE_10_FULL.equals(this.carProfile);
    }

    @Deprecated
    public boolean isEjbLiteIncluded() {
        J2eePlatform platform = ProjectUtil.getPlatform(this.project);
        if (platform == null) {
            return false;
        }
        return EjbSupport.getInstance((J2eePlatform)platform).isEjb31LiteSupported(platform);
    }

    public boolean hasDefaultPersistenceProvider() {
        J2eePlatform platform = ProjectUtil.getPlatform(this.project);
        if (platform == null) {
            return false;
        }
        HashSet profiles = new HashSet(platform.getSupportedProfiles(this.provider.getJ2eeModule().getType()));
        profiles.remove(Profile.J2EE_13);
        profiles.remove(Profile.J2EE_14);
        if (profiles.isEmpty()) {
            return false;
        }
        JpaSupport support = JpaSupport.getInstance((J2eePlatform)platform);
        return support != null && support.getDefaultProvider() != null;
    }
}

