/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.JavaFileObject;

public interface Elements {
    public PackageElement getPackageElement(CharSequence var1);

    default public PackageElement getPackageElement(ModuleElement module, CharSequence name) {
        return null;
    }

    default public Set<? extends PackageElement> getAllPackageElements(CharSequence name) {
        Set<? extends ModuleElement> modules = this.getAllModuleElements();
        if (modules.isEmpty()) {
            PackageElement packageElt = this.getPackageElement(name);
            return packageElt != null ? Collections.singleton(packageElt) : Collections.emptySet();
        }
        LinkedHashSet<PackageElement> result = new LinkedHashSet<PackageElement>(1);
        for (ModuleElement moduleElement : modules) {
            PackageElement packageElt = this.getPackageElement(moduleElement, name);
            if (packageElt == null) continue;
            result.add(packageElt);
        }
        return Collections.unmodifiableSet(result);
    }

    public TypeElement getTypeElement(CharSequence var1);

    default public TypeElement getTypeElement(ModuleElement module, CharSequence name) {
        return null;
    }

    default public Set<? extends TypeElement> getAllTypeElements(CharSequence name) {
        Set<? extends ModuleElement> modules = this.getAllModuleElements();
        if (modules.isEmpty()) {
            TypeElement typeElt = this.getTypeElement(name);
            return typeElt != null ? Collections.singleton(typeElt) : Collections.emptySet();
        }
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>(1);
        for (ModuleElement moduleElement : modules) {
            TypeElement typeElt = this.getTypeElement(moduleElement, name);
            if (typeElt == null) continue;
            result.add(typeElt);
        }
        return Collections.unmodifiableSet(result);
    }

    default public ModuleElement getModuleElement(CharSequence name) {
        return null;
    }

    default public Set<? extends ModuleElement> getAllModuleElements() {
        return Collections.emptySet();
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror var1);

    public String getDocComment(Element var1);

    public boolean isDeprecated(Element var1);

    default public Origin getOrigin(Element e) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(AnnotatedConstruct c, AnnotationMirror a) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(ModuleElement m, ModuleElement.Directive directive) {
        return Origin.EXPLICIT;
    }

    default public boolean isBridge(ExecutableElement e) {
        return false;
    }

    public Name getBinaryName(TypeElement var1);

    public PackageElement getPackageOf(Element var1);

    default public ModuleElement getModuleOf(Element e) {
        return null;
    }

    public List<? extends Element> getAllMembers(TypeElement var1);

    default public TypeElement getOutermostTypeElement(Element e) {
        TypeElement typeElement;
        block0 : switch (e.getKind()) {
            case PACKAGE: 
            case MODULE: {
                typeElement = null;
                break;
            }
            case OTHER: {
                typeElement = null;
                break;
            }
            default: {
                Element enclosing = e;
                while (true) {
                    TypeElement typeElement2;
                    List<TypeElement> possibleTypeElement;
                    if (!(possibleTypeElement = ElementFilter.typesIn(Collections.unmodifiableList(Arrays.asList(enclosing)))).isEmpty() && (typeElement2 = possibleTypeElement.get(0)).getNestingKind() == NestingKind.TOP_LEVEL) {
                        typeElement = typeElement2;
                        break block0;
                    }
                    enclosing = enclosing.getEnclosingElement();
                }
            }
        }
        return typeElement;
    }

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element var1);

    public boolean hides(Element var1, Element var2);

    public boolean overrides(ExecutableElement var1, ExecutableElement var2, TypeElement var3);

    public String getConstantExpression(Object var1);

    public void printElements(Writer var1, Element ... var2);

    public Name getName(CharSequence var1);

    public boolean isFunctionalInterface(TypeElement var1);

    default public boolean isAutomaticModule(ModuleElement module) {
        return false;
    }

    default public RecordComponentElement recordComponentFor(ExecutableElement accessor) {
        if (accessor.getEnclosingElement().getKind() == ElementKind.RECORD) {
            for (RecordComponentElement rec : ElementFilter.recordComponentsIn(accessor.getEnclosingElement().getEnclosedElements())) {
                if (!Objects.equals(rec.getAccessor(), accessor)) continue;
                return rec;
            }
        }
        return null;
    }

    default public JavaFileObject getFileObjectOf(Element e) {
        throw new UnsupportedOperationException();
    }

    public static enum Origin {
        EXPLICIT,
        MANDATED,
        SYNTHETIC;


        public boolean isDeclared() {
            return this != SYNTHETIC;
        }
    }
}

