"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.get = void 0;
function get(obj, path) {
    if (typeof path === 'string') {
        if (path.includes('.')) {
            throw new Error('Using dots in `get` with a string is not allowed, use array instead');
        }
        return obj[path];
    }
    for (const key of path) {
        obj = obj[key];
    }
    return obj;
}
exports.get = get;
