"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALLOWED_FILE_EXTENSIONS", {
  enumerable: true,
  get: function () {
    return _shared.ALLOWED_FILE_EXTENSIONS;
  }
});
exports.MAPS_APP_ICON = exports.LAYER_VISIBILITY = exports.LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_ICON_TYPE_MAP = exports.DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS = exports.DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.CUSTOM_MAP = exports.APP_PATH = void 0;
Object.defineProperty(exports, "MAPS_APP_ID", {
  enumerable: true,
  get: function () {
    return _shared.MAPS_APP_ID;
  }
});
exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_LAYER_DEFAULT_BORDER_THICKNESS = exports.MAP_INITIAL_STATE = exports.MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAPS_VISUALIZATION_DESCRIPTION = void 0;
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE;
  }
});
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE_IN_MB", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE_IN_MB;
  }
});
exports.OPENSEARCH_MAP_LAYER = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = exports.MIN_LONGITUDE = exports.MAX_LONGITUDE = exports.MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_LIMIT = void 0;
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_NAME", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_NAME;
  }
});
Object.defineProperty(exports, "fromMBtoBytes", {
  enumerable: true,
  get: function () {
    return _util.fromMBtoBytes;
  }
});

var _util = require("./util");

var _shared = require("./constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const DOCUMENTS_DEFAULT_MARKER_SIZE = 5;
exports.DOCUMENTS_DEFAULT_MARKER_SIZE = DOCUMENTS_DEFAULT_MARKER_SIZE;
const DOCUMENTS_DEFAULT_REQUEST_NUMBER = 1000;
exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = DOCUMENTS_DEFAULT_REQUEST_NUMBER;
const DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = false;
exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = DOCUMENTS_DEFAULT_SHOW_TOOLTIPS;
const DOCUMENTS_DEFAULT_TOOLTIPS = [];
exports.DOCUMENTS_DEFAULT_TOOLTIPS = DOCUMENTS_DEFAULT_TOOLTIPS;
const LAYER_PANEL_HIDE_LAYER_ICON = 'eyeClosed';
exports.LAYER_PANEL_HIDE_LAYER_ICON = LAYER_PANEL_HIDE_LAYER_ICON;
const LAYER_PANEL_SHOW_LAYER_ICON = 'eye';
exports.LAYER_PANEL_SHOW_LAYER_ICON = LAYER_PANEL_SHOW_LAYER_ICON;
const MAP_DATA_LAYER_DEFAULT_OPACITY = 70;
exports.MAP_DATA_LAYER_DEFAULT_OPACITY = MAP_DATA_LAYER_DEFAULT_OPACITY;
const MAP_DEFAULT_MAX_ZOOM = 22;
exports.MAP_DEFAULT_MAX_ZOOM = MAP_DEFAULT_MAX_ZOOM;
const MAP_DEFAULT_MIN_ZOOM = 0;
exports.MAP_DEFAULT_MIN_ZOOM = MAP_DEFAULT_MIN_ZOOM;
const MAP_LAYER_DEFAULT_BORDER_THICKNESS = 1;
exports.MAP_LAYER_DEFAULT_BORDER_THICKNESS = MAP_LAYER_DEFAULT_BORDER_THICKNESS;
const MAP_LAYER_DEFAULT_MAX_OPACITY = 100;
exports.MAP_LAYER_DEFAULT_MAX_OPACITY = MAP_LAYER_DEFAULT_MAX_OPACITY;
const MAP_LAYER_DEFAULT_MIN_OPACITY = 0;
exports.MAP_LAYER_DEFAULT_MIN_OPACITY = MAP_LAYER_DEFAULT_MIN_OPACITY;
const MAP_LAYER_DEFAULT_NAME = 'Default map';
exports.MAP_LAYER_DEFAULT_NAME = MAP_LAYER_DEFAULT_NAME;
const MAP_LAYER_DEFAULT_OPACITY_STEP = 1;
exports.MAP_LAYER_DEFAULT_OPACITY_STEP = MAP_LAYER_DEFAULT_OPACITY_STEP;
const MAP_REFERENCE_LAYER_DEFAULT_OPACITY = 100; // Make this configurable from map settings

exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = MAP_REFERENCE_LAYER_DEFAULT_OPACITY;
const MAX_LAYER_LIMIT = 20;
exports.MAX_LAYER_LIMIT = MAX_LAYER_LIMIT;
const MAX_LAYER_NAME_LIMIT = 35;
exports.MAX_LAYER_NAME_LIMIT = MAX_LAYER_NAME_LIMIT;
const MAX_LONGITUDE = 180;
exports.MAX_LONGITUDE = MAX_LONGITUDE;
const MIN_LONGITUDE = -180;
exports.MIN_LONGITUDE = MIN_LONGITUDE;
const NEW_MAP_LAYER_DEFAULT_PREFIX = 'New layer';
exports.NEW_MAP_LAYER_DEFAULT_PREFIX = NEW_MAP_LAYER_DEFAULT_PREFIX;
const MAP_SAVED_OBJECT_TYPE = 'map'; // TODO: Replace with actual app icon

exports.MAP_SAVED_OBJECT_TYPE = MAP_SAVED_OBJECT_TYPE;
const MAPS_APP_ICON = 'gisApp';
exports.MAPS_APP_ICON = MAPS_APP_ICON;
const MAPS_VISUALIZATION_DESCRIPTION = 'Create map visualization with multiple layers'; // Starting position [lng, lat] and zoom

exports.MAPS_VISUALIZATION_DESCRIPTION = MAPS_VISUALIZATION_DESCRIPTION;
const MAP_INITIAL_STATE = {
  lng: 0,
  lat: 0,
  zoom: 1
};
exports.MAP_INITIAL_STATE = MAP_INITIAL_STATE;
const APP_PATH = {
  LANDING_PAGE_PATH: '/',
  CREATE_MAP: '/create',
  EDIT_MAP: '/:id'
};
exports.APP_PATH = APP_PATH;
let DASHBOARDS_MAPS_LAYER_NAME;
exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME;

(function (DASHBOARDS_MAPS_LAYER_NAME) {
  DASHBOARDS_MAPS_LAYER_NAME["OPENSEARCH_MAP"] = "OpenSearch map";
  DASHBOARDS_MAPS_LAYER_NAME["DOCUMENTS"] = "Documents";
  DASHBOARDS_MAPS_LAYER_NAME["CUSTOM_MAP"] = "Custom map";
})(DASHBOARDS_MAPS_LAYER_NAME || (exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME = {}));

let DASHBOARDS_MAPS_LAYER_TYPE;
exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE;

(function (DASHBOARDS_MAPS_LAYER_TYPE) {
  DASHBOARDS_MAPS_LAYER_TYPE["OPENSEARCH_MAP"] = "opensearch_vector_tile_map";
  DASHBOARDS_MAPS_LAYER_TYPE["DOCUMENTS"] = "documents";
  DASHBOARDS_MAPS_LAYER_TYPE["CUSTOM_MAP"] = "custom_map";
})(DASHBOARDS_MAPS_LAYER_TYPE || (exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE = {}));

let DASHBOARDS_MAPS_LAYER_ICON;
exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON;

(function (DASHBOARDS_MAPS_LAYER_ICON) {
  DASHBOARDS_MAPS_LAYER_ICON["OPENSEARCH_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["DOCUMENTS"] = "document";
  DASHBOARDS_MAPS_LAYER_ICON["CUSTOM_MAP"] = "globe";
})(DASHBOARDS_MAPS_LAYER_ICON || (exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON = {}));

let DASHBOARDS_MAPS_LAYER_DESCRIPTION;
exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION;

(function (DASHBOARDS_MAPS_LAYER_DESCRIPTION) {
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["OPENSEARCH_MAP"] = "Use default OpenSearch basemaps.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["DOCUMENTS"] = "View points, lines, and polygons on the map.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CUSTOM_MAP"] = "Configure maps to use a custom map source.";
})(DASHBOARDS_MAPS_LAYER_DESCRIPTION || (exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION = {}));

const DOCUMENTS = {
  name: DASHBOARDS_MAPS_LAYER_NAME.DOCUMENTS,
  type: DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS,
  icon: DASHBOARDS_MAPS_LAYER_ICON.DOCUMENTS,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.DOCUMENTS
};
exports.DOCUMENTS = DOCUMENTS;
const OPENSEARCH_MAP_LAYER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.OPENSEARCH_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.OPENSEARCH_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.OPENSEARCH_MAP
};
exports.OPENSEARCH_MAP_LAYER = OPENSEARCH_MAP_LAYER;
const CUSTOM_MAP = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CUSTOM_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CUSTOM_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CUSTOM_MAP
};
exports.CUSTOM_MAP = CUSTOM_MAP;
const LAYER_VISIBILITY = {
  NONE: 'none',
  VISIBLE: 'visible'
};
exports.LAYER_VISIBILITY = LAYER_VISIBILITY;
const LAYER_ICON_TYPE_MAP = {
  [DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS]: 'document',
  [DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP]: 'globe'
};
exports.LAYER_ICON_TYPE_MAP = LAYER_ICON_TYPE_MAP;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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