// Generated by dts-bundle-generator v6.12.0

import Point from '@mapbox/point-geometry';

declare const _default: any;
/**
 * Format a MapLibre GL Style.  Returns a stringified style with its keys
 * sorted in the same order as the reference style.
 *
 * The optional `space` argument is passed to
 * [`JSON.stringify`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON/stringify)
 * to generate formatted output.
 *
 * If `space` is unspecified, a default of `2` spaces will be used.
 *
 * @private
 * @param {Object} style a MapLibre GL Style
 * @param {number} [space] space argument to pass to `JSON.stringify`
 * @returns {string} stringified formatted JSON
 * @example
 * var fs = require('fs');
 * var format = require('maplibre-gl-style-spec').format;
 * var style = fs.readFileSync('./source.json', 'utf8');
 * fs.writeFileSync('./dest.json', format(style));
 * fs.writeFileSync('./dest.min.json', format(style, 0));
 */
export declare function format(style: any, space?: number): string;
export declare type ColorSpecification = string;
export declare type PaddingSpecification = number | number[];
export declare type FormattedSpecification = string;
export declare type ResolvedImageSpecification = string;
export declare type PromoteIdSpecification = {
	[_: string]: string;
} | string;
export declare type ExpressionInputType = string | number | boolean;
export declare type CollatorExpressionSpecification = [
	"collator",
	{
		"case-sensitive"?: boolean | ExpressionSpecification;
		"diacritic-sensitive"?: boolean | ExpressionSpecification;
		locale?: string | ExpressionSpecification;
	}
];
export declare type InterpolationSpecification = [
	"linear"
] | [
	"exponential",
	number | ExpressionSpecification
] | [
	"cubic-bezier",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
];
export declare type ExpressionSpecification = [
	"array",
	unknown | ExpressionSpecification
] | [
	"array",
	ExpressionInputType | ExpressionSpecification,
	unknown | ExpressionSpecification
] | [
	"array",
	ExpressionInputType | ExpressionSpecification,
	number | ExpressionSpecification,
	unknown | ExpressionSpecification
] | [
	"boolean",
	...(unknown | ExpressionSpecification)[],
	unknown | ExpressionSpecification
] | CollatorExpressionSpecification | [
	"format",
	...(string | [
		"image",
		ExpressionSpecification
	] | ExpressionSpecification | {
		"font-scale"?: number | ExpressionSpecification;
		"text-font"?: string[] | ExpressionSpecification;
		"text-color": ColorSpecification | ExpressionSpecification;
	})[]
] | [
	"image",
	unknown | ExpressionSpecification
] | [
	"literal",
	unknown
] | [
	"number",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"number-format",
	number | ExpressionSpecification,
	{
		"locale"?: string | ExpressionSpecification;
		"currency"?: string | ExpressionSpecification;
		"min-fraction-digits"?: number | ExpressionSpecification;
		"max-fraction-digits"?: number | ExpressionSpecification;
	}
] | [
	"object",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"string",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-boolean",
	unknown | ExpressionSpecification
] | [
	"to-color",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-number",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-string",
	unknown | ExpressionSpecification
] | [
	"accumulated"
] | [
	"feature-state",
	string
] | [
	"geometry-type"
] | [
	"id"
] | [
	"line-progress"
] | [
	"properties"
] | [
	"at",
	number | ExpressionSpecification,
	ExpressionSpecification
] | [
	"get",
	string | ExpressionSpecification,
	(Record<string, unknown> | ExpressionSpecification)?
] | [
	"has",
	string | ExpressionSpecification,
	(Record<string, unknown> | ExpressionSpecification)?
] | [
	"in",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification
] | [
	"index-of",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification
] | [
	"length",
	string | ExpressionSpecification
] | [
	"slice",
	string | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"!",
	boolean | ExpressionSpecification
] | [
	"!=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"<",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"<=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"==",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	">",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	">=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"all",
	...(boolean | ExpressionSpecification)[]
] | [
	"any",
	...(boolean | ExpressionSpecification)[]
] | [
	"case",
	boolean | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	...(boolean | ExpressionInputType | ExpressionSpecification)[],
	ExpressionInputType | ExpressionSpecification
] | [
	"coalesce",
	...(ExpressionInputType | ExpressionSpecification)[]
] | [
	"match",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionInputType[],
	ExpressionInputType | ExpressionSpecification,
	...(ExpressionInputType | ExpressionInputType[] | ExpressionSpecification)[],
	ExpressionInputType
] | [
	"within",
	unknown | ExpressionSpecification
] | [
	"interpolate",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | number[] | ColorSpecification)[]
] | [
	"interpolate-hcl",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | ColorSpecification)[]
] | [
	"interpolate-lab",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | ColorSpecification)[]
] | [
	"step",
	number | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	...(number | ExpressionInputType | ExpressionSpecification)[]
] | [
	"let",
	string,
	ExpressionInputType | ExpressionSpecification,
	...(string | ExpressionInputType | ExpressionSpecification)[]
] | [
	"var",
	string
] | [
	"concat",
	...(ExpressionInputType | ExpressionSpecification)[]
] | [
	"downcase",
	string | ExpressionSpecification
] | [
	"is-supported-script",
	string | ExpressionSpecification
] | [
	"resolved-locale",
	CollatorExpressionSpecification
] | [
	"upcase",
	string | ExpressionSpecification
] | [
	"rgb",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"rgba",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"to-rgba",
	ColorSpecification | ExpressionSpecification
] | [
	"-",
	number | ExpressionSpecification,
	(number | ExpressionSpecification)?
] | [
	"*",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"/",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"%",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"^",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"+",
	...(number | ExpressionSpecification)[]
] | [
	"abs",
	number | ExpressionSpecification
] | [
	"acos",
	number | ExpressionSpecification
] | [
	"asin",
	number | ExpressionSpecification
] | [
	"atan",
	number | ExpressionSpecification
] | [
	"ceil",
	number | ExpressionSpecification
] | [
	"cos",
	number | ExpressionSpecification
] | [
	"distance",
	Record<string, unknown> | ExpressionSpecification
] | [
	"ExpressionSpecification"
] | [
	"floor",
	number | ExpressionSpecification
] | [
	"ln",
	number | ExpressionSpecification
] | [
	"ln2"
] | [
	"log10",
	number | ExpressionSpecification
] | [
	"log2",
	number | ExpressionSpecification
] | [
	"max",
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"min",
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"pi"
] | [
	"round",
	number | ExpressionSpecification
] | [
	"sin",
	number | ExpressionSpecification
] | [
	"sqrt",
	number | ExpressionSpecification
] | [
	"tan",
	number | ExpressionSpecification
] | [
	"zoom"
] | [
	"heatmap-density"
];
export declare type ExpressionFilterSpecification = boolean | ExpressionSpecification;
export declare type LegacyFilterSpecification = [
	"has",
	string
] | [
	"!has",
	string
] | [
	"==",
	string,
	string | number | boolean
] | [
	"!=",
	string,
	string | number | boolean
] | [
	">",
	string,
	string | number | boolean
] | [
	">=",
	string,
	string | number | boolean
] | [
	"<",
	string,
	string | number | boolean
] | [
	"<=",
	string,
	string | number | boolean
] | [
	"in",
	string,
	...(string | number | boolean)[]
] | [
	"!in",
	string,
	...(string | number | boolean)[]
] | [
	"all",
	...LegacyFilterSpecification[]
] | [
	"any",
	...LegacyFilterSpecification[]
] | [
	"none",
	...LegacyFilterSpecification[]
];
export declare type FilterSpecification = ExpressionFilterSpecification | LegacyFilterSpecification;
export declare type TransitionSpecification = {
	duration?: number;
	delay?: number;
};
export declare type CameraFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		number,
		T
	]>;
} | {
	type: "interval";
	stops: Array<[
		number,
		T
	]>;
};
export declare type SourceFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		number,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "interval";
	stops: Array<[
		number,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "categorical";
	stops: Array<[
		string | number | boolean,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "identity";
	property: string;
	default?: T;
};
export declare type CompositeFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		{
			zoom: number;
			value: number;
		},
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "interval";
	stops: Array<[
		{
			zoom: number;
			value: number;
		},
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "categorical";
	stops: Array<[
		{
			zoom: number;
			value: string | number | boolean;
		},
		T
	]>;
	property: string;
	default?: T;
};
export declare type PropertyValueSpecification<T> = T | CameraFunctionSpecification<T> | ExpressionSpecification;
export declare type DataDrivenPropertyValueSpecification<T> = T | CameraFunctionSpecification<T> | SourceFunctionSpecification<T> | CompositeFunctionSpecification<T> | ExpressionSpecification;
export declare type StyleSpecification = {
	"version": 8;
	"name"?: string;
	"metadata"?: unknown;
	"center"?: Array<number>;
	"zoom"?: number;
	"bearing"?: number;
	"pitch"?: number;
	"light"?: LightSpecification;
	"terrain"?: TerrainSpecification;
	"sources": {
		[_: string]: SourceSpecification;
	};
	"sprite"?: string;
	"glyphs"?: string;
	"transition"?: TransitionSpecification;
	"layers": Array<LayerSpecification>;
};
export declare type LightSpecification = {
	"anchor"?: PropertyValueSpecification<"map" | "viewport">;
	"position"?: PropertyValueSpecification<[
		number,
		number,
		number
	]>;
	"color"?: PropertyValueSpecification<ColorSpecification>;
	"intensity"?: PropertyValueSpecification<number>;
};
export declare type TerrainSpecification = {
	"source": string;
	"exaggeration"?: number;
	"elevationOffset"?: number;
};
export declare type VectorSourceSpecification = {
	"type": "vector";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"scheme"?: "xyz" | "tms";
	"minzoom"?: number;
	"maxzoom"?: number;
	"attribution"?: string;
	"promoteId"?: PromoteIdSpecification;
	"volatile"?: boolean;
};
export declare type RasterSourceSpecification = {
	"type": "raster";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"minzoom"?: number;
	"maxzoom"?: number;
	"tileSize"?: number;
	"scheme"?: "xyz" | "tms";
	"attribution"?: string;
	"volatile"?: boolean;
};
export declare type RasterDEMSourceSpecification = {
	"type": "raster-dem";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"minzoom"?: number;
	"maxzoom"?: number;
	"tileSize"?: number;
	"attribution"?: string;
	"encoding"?: "terrarium" | "mapbox";
	"volatile"?: boolean;
};
export declare type GeoJSONSourceSpecification = {
	"type": "geojson";
	"data"?: unknown;
	"maxzoom"?: number;
	"attribution"?: string;
	"buffer"?: number;
	"filter"?: unknown;
	"tolerance"?: number;
	"cluster"?: boolean;
	"clusterRadius"?: number;
	"clusterMaxZoom"?: number;
	"clusterMinPoints"?: number;
	"clusterProperties"?: unknown;
	"lineMetrics"?: boolean;
	"generateId"?: boolean;
	"promoteId"?: PromoteIdSpecification;
};
export declare type VideoSourceSpecification = {
	"type": "video";
	"urls": Array<string>;
	"coordinates": [
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		]
	];
};
export declare type ImageSourceSpecification = {
	"type": "image";
	"url": string;
	"coordinates": [
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		]
	];
};
export declare type SourceSpecification = VectorSourceSpecification | RasterSourceSpecification | RasterDEMSourceSpecification | GeoJSONSourceSpecification | VideoSourceSpecification | ImageSourceSpecification;
export declare type FillLayerSpecification = {
	"id": string;
	"type": "fill";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"fill-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"fill-antialias"?: PropertyValueSpecification<boolean>;
		"fill-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"fill-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-outline-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"fill-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"fill-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
	};
};
export declare type LineLayerSpecification = {
	"id": string;
	"type": "line";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"line-cap"?: PropertyValueSpecification<"butt" | "round" | "square">;
		"line-join"?: DataDrivenPropertyValueSpecification<"bevel" | "round" | "miter">;
		"line-miter-limit"?: PropertyValueSpecification<number>;
		"line-round-limit"?: PropertyValueSpecification<number>;
		"line-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"line-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"line-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"line-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"line-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"line-width"?: DataDrivenPropertyValueSpecification<number>;
		"line-gap-width"?: DataDrivenPropertyValueSpecification<number>;
		"line-offset"?: DataDrivenPropertyValueSpecification<number>;
		"line-blur"?: DataDrivenPropertyValueSpecification<number>;
		"line-dasharray"?: PropertyValueSpecification<Array<number>>;
		"line-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"line-gradient"?: ExpressionSpecification;
	};
};
export declare type SymbolLayerSpecification = {
	"id": string;
	"type": "symbol";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"symbol-placement"?: PropertyValueSpecification<"point" | "line" | "line-center">;
		"symbol-spacing"?: PropertyValueSpecification<number>;
		"symbol-avoid-edges"?: PropertyValueSpecification<boolean>;
		"symbol-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"symbol-z-order"?: PropertyValueSpecification<"auto" | "viewport-y" | "source">;
		"icon-allow-overlap"?: PropertyValueSpecification<boolean>;
		"icon-overlap"?: PropertyValueSpecification<"never" | "always" | "cooperative">;
		"icon-ignore-placement"?: PropertyValueSpecification<boolean>;
		"icon-optional"?: PropertyValueSpecification<boolean>;
		"icon-rotation-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"icon-size"?: DataDrivenPropertyValueSpecification<number>;
		"icon-text-fit"?: PropertyValueSpecification<"none" | "width" | "height" | "both">;
		"icon-text-fit-padding"?: PropertyValueSpecification<[
			number,
			number,
			number,
			number
		]>;
		"icon-image"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"icon-rotate"?: DataDrivenPropertyValueSpecification<number>;
		"icon-padding"?: DataDrivenPropertyValueSpecification<PaddingSpecification>;
		"icon-keep-upright"?: PropertyValueSpecification<boolean>;
		"icon-offset"?: DataDrivenPropertyValueSpecification<[
			number,
			number
		]>;
		"icon-anchor"?: DataDrivenPropertyValueSpecification<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
		"icon-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"text-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"text-rotation-alignment"?: PropertyValueSpecification<"map" | "viewport" | "viewport-glyph" | "auto">;
		"text-field"?: DataDrivenPropertyValueSpecification<FormattedSpecification>;
		"text-font"?: DataDrivenPropertyValueSpecification<Array<string>>;
		"text-size"?: DataDrivenPropertyValueSpecification<number>;
		"text-max-width"?: DataDrivenPropertyValueSpecification<number>;
		"text-line-height"?: PropertyValueSpecification<number>;
		"text-letter-spacing"?: DataDrivenPropertyValueSpecification<number>;
		"text-justify"?: DataDrivenPropertyValueSpecification<"auto" | "left" | "center" | "right">;
		"text-radial-offset"?: DataDrivenPropertyValueSpecification<number>;
		"text-variable-anchor"?: PropertyValueSpecification<Array<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">>;
		"text-anchor"?: DataDrivenPropertyValueSpecification<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
		"text-max-angle"?: PropertyValueSpecification<number>;
		"text-writing-mode"?: PropertyValueSpecification<Array<"horizontal" | "vertical">>;
		"text-rotate"?: DataDrivenPropertyValueSpecification<number>;
		"text-padding"?: PropertyValueSpecification<number>;
		"text-keep-upright"?: PropertyValueSpecification<boolean>;
		"text-transform"?: DataDrivenPropertyValueSpecification<"none" | "uppercase" | "lowercase">;
		"text-offset"?: DataDrivenPropertyValueSpecification<[
			number,
			number
		]>;
		"text-allow-overlap"?: PropertyValueSpecification<boolean>;
		"text-overlap"?: PropertyValueSpecification<"never" | "always" | "cooperative">;
		"text-ignore-placement"?: PropertyValueSpecification<boolean>;
		"text-optional"?: PropertyValueSpecification<boolean>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"icon-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"icon-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"icon-halo-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"icon-halo-width"?: DataDrivenPropertyValueSpecification<number>;
		"icon-halo-blur"?: DataDrivenPropertyValueSpecification<number>;
		"icon-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"icon-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"text-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"text-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"text-halo-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"text-halo-width"?: DataDrivenPropertyValueSpecification<number>;
		"text-halo-blur"?: DataDrivenPropertyValueSpecification<number>;
		"text-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"text-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
	};
};
export declare type CircleLayerSpecification = {
	"id": string;
	"type": "circle";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"circle-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"circle-radius"?: DataDrivenPropertyValueSpecification<number>;
		"circle-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"circle-blur"?: DataDrivenPropertyValueSpecification<number>;
		"circle-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"circle-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"circle-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-pitch-scale"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-stroke-width"?: DataDrivenPropertyValueSpecification<number>;
		"circle-stroke-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"circle-stroke-opacity"?: DataDrivenPropertyValueSpecification<number>;
	};
};
export declare type HeatmapLayerSpecification = {
	"id": string;
	"type": "heatmap";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"heatmap-radius"?: DataDrivenPropertyValueSpecification<number>;
		"heatmap-weight"?: DataDrivenPropertyValueSpecification<number>;
		"heatmap-intensity"?: PropertyValueSpecification<number>;
		"heatmap-color"?: ExpressionSpecification;
		"heatmap-opacity"?: PropertyValueSpecification<number>;
	};
};
export declare type FillExtrusionLayerSpecification = {
	"id": string;
	"type": "fill-extrusion";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"fill-extrusion-opacity"?: PropertyValueSpecification<number>;
		"fill-extrusion-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-extrusion-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"fill-extrusion-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"fill-extrusion-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"fill-extrusion-height"?: DataDrivenPropertyValueSpecification<number>;
		"fill-extrusion-base"?: DataDrivenPropertyValueSpecification<number>;
		"fill-extrusion-vertical-gradient"?: PropertyValueSpecification<boolean>;
	};
};
export declare type RasterLayerSpecification = {
	"id": string;
	"type": "raster";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"raster-opacity"?: PropertyValueSpecification<number>;
		"raster-hue-rotate"?: PropertyValueSpecification<number>;
		"raster-brightness-min"?: PropertyValueSpecification<number>;
		"raster-brightness-max"?: PropertyValueSpecification<number>;
		"raster-saturation"?: PropertyValueSpecification<number>;
		"raster-contrast"?: PropertyValueSpecification<number>;
		"raster-resampling"?: PropertyValueSpecification<"linear" | "nearest">;
		"raster-fade-duration"?: PropertyValueSpecification<number>;
	};
};
export declare type HillshadeLayerSpecification = {
	"id": string;
	"type": "hillshade";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"hillshade-illumination-direction"?: PropertyValueSpecification<number>;
		"hillshade-illumination-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"hillshade-exaggeration"?: PropertyValueSpecification<number>;
		"hillshade-shadow-color"?: PropertyValueSpecification<ColorSpecification>;
		"hillshade-highlight-color"?: PropertyValueSpecification<ColorSpecification>;
		"hillshade-accent-color"?: PropertyValueSpecification<ColorSpecification>;
	};
};
export declare type BackgroundLayerSpecification = {
	"id": string;
	"type": "background";
	"metadata"?: unknown;
	"minzoom"?: number;
	"maxzoom"?: number;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"background-color"?: PropertyValueSpecification<ColorSpecification>;
		"background-pattern"?: PropertyValueSpecification<ResolvedImageSpecification>;
		"background-opacity"?: PropertyValueSpecification<number>;
	};
};
export declare type LayerSpecification = FillLayerSpecification | LineLayerSpecification | SymbolLayerSpecification | CircleLayerSpecification | HeatmapLayerSpecification | FillExtrusionLayerSpecification | RasterLayerSpecification | HillshadeLayerSpecification | BackgroundLayerSpecification;
/**
 * Migrate a Mapbox GL Style to the latest version.
 *
 * @private
 * @alias migrate
 * @param {StyleSpecification} style a MapLibre GL Style
 * @returns {StyleSpecification} a migrated style
 * @example
 * var fs = require('fs');
 * var migrate = require('maplibre-gl-style-spec').migrate;
 * var style = fs.readFileSync('./style.json', 'utf8');
 * fs.writeFileSync('./style.json', JSON.stringify(migrate(style)));
 */
export function migrate(style: StyleSpecification): StyleSpecification;
export function composite(style: StyleSpecification): StyleSpecification;
/**
 * Given an array of layers, some of which may contain `ref` properties
 * whose value is the `id` of another property, return a new array where
 * such layers have been augmented with the 'type', 'source', etc. properties
 * from the parent layer, and the `ref` property has been removed.
 *
 * The input is not modified. The output may contain references to portions
 * of the input.
 *
 * @private
 * @param {Array<Layer>} layers
 * @returns {Array<Layer>}
 */
export declare function derefLayers(layers: any): any;
declare function diffStyles(before: any, after: any): any[];
export declare class ValidationError {
	message: string;
	identifier: string;
	line: number;
	constructor(key: string, value: any & {
		__line__: number;
	}, message: string, identifier?: string | null);
}
export declare class ParsingError {
	message: string;
	error: Error;
	line: number;
	constructor(error: Error);
}
declare class ExpressionParsingError extends Error {
	key: string;
	message: string;
	constructor(key: string, message: string);
}
/**
 * An RGBA color value. Create instances from color strings using the static
 * method `Color.parse`. The constructor accepts RGB channel values in the range
 * `[0, 1]`, premultiplied by A.
 *
 * @param {number} r The red channel.
 * @param {number} g The green channel.
 * @param {number} b The blue channel.
 * @param {number} a The alpha channel.
 * @private
 */
export declare class Color {
	r: number;
	g: number;
	b: number;
	a: number;
	constructor(r: number, g: number, b: number, a?: number);
	static black: Color;
	static white: Color;
	static transparent: Color;
	static red: Color;
	/**
	 * Parses valid CSS color strings and returns a `Color` instance.
	 * @returns A `Color` instance, or `undefined` if the input is not a valid color string.
	 */
	static parse(input?: string | Color | null): Color | void;
	/**
	 * Returns an RGBA string representing the color value.
	 *
	 * @returns An RGBA string.
	 * @example
	 * var purple = new Color.parse('purple');
	 * purple.toString; // = "rgba(128,0,128,1)"
	 * var translucentGreen = new Color.parse('rgba(26, 207, 26, .73)');
	 * translucentGreen.toString(); // = "rgba(26,207,26,0.73)"
	 */
	toString(): string;
	toArray(): [
		number,
		number,
		number,
		number
	];
}
declare class Intl$Collator {
	constructor(locales?: string | string[], options?: CollatorOptions);
	compare(a: string, b: string): number;
	resolvedOptions(): any;
}
export declare type CollatorOptions = {
	localeMatcher?: "lookup" | "best fit";
	usage?: "sort" | "search";
	sensitivity?: "base" | "accent" | "case" | "variant";
	ignorePunctuation?: boolean;
	numeric?: boolean;
	caseFirst?: "upper" | "lower" | "false";
};
declare class Collator {
	locale: string | null;
	sensitivity: "base" | "accent" | "case" | "variant";
	collator: Intl$Collator;
	constructor(caseSensitive: boolean, diacriticSensitive: boolean, locale: string | null);
	compare(lhs: string, rhs: string): number;
	resolvedLocale(): string;
}
export declare type ResolvedImageOptions = {
	name: string;
	available: boolean;
};
declare class ResolvedImage {
	name: string;
	available: boolean;
	constructor(options: ResolvedImageOptions);
	toString(): string;
	static fromString(name: string): ResolvedImage | null;
}
declare class FormattedSection {
	text: string;
	image: ResolvedImage | null;
	scale: number | null;
	fontStack: string | null;
	textColor: Color | null;
	constructor(text: string, image: ResolvedImage | null, scale: number | null, fontStack: string | null, textColor: Color | null);
}
declare class Formatted {
	sections: Array<FormattedSection>;
	constructor(sections: Array<FormattedSection>);
	static fromString(unformatted: string): Formatted;
	isEmpty(): boolean;
	static factory(text: Formatted | string): Formatted;
	toString(): string;
}
/**
 * A set of four numbers representing padding around a box. Create instances from
 * bare arrays or numeric values using the static method `Padding.parse`.
 * @private
 */
export declare class Padding {
	/** Padding values are in CSS order: top, right, bottom, left */
	values: [
		number,
		number,
		number,
		number
	];
	constructor(values: [
		number,
		number,
		number,
		number
	]);
	/**
	 * Numeric padding values
	 * @returns A `Padding` instance, or `undefined` if the input is not a valid padding value.
	 */
	static parse(input?: number | number[] | Padding | null): Padding | void;
	toString(): string;
}
export declare type NullTypeT = {
	kind: "null";
};
export declare type NumberTypeT = {
	kind: "number";
};
export declare type StringTypeT = {
	kind: "string";
};
export declare type BooleanTypeT = {
	kind: "boolean";
};
export declare type ColorTypeT = {
	kind: "color";
};
export declare type ObjectTypeT = {
	kind: "object";
};
export declare type ValueTypeT = {
	kind: "value";
};
export declare type ErrorTypeT = {
	kind: "error";
};
export declare type CollatorTypeT = {
	kind: "collator";
};
export declare type FormattedTypeT = {
	kind: "formatted";
};
export declare type PaddingTypeT = {
	kind: "padding";
};
export declare type ResolvedImageTypeT = {
	kind: "resolvedImage";
};
export declare type EvaluationKind = "constant" | "source" | "camera" | "composite";
export declare type Type = NullTypeT | NumberTypeT | StringTypeT | BooleanTypeT | ColorTypeT | ObjectTypeT | ValueTypeT | // eslint-disable-line no-use-before-define
ArrayType | ErrorTypeT | CollatorTypeT | FormattedTypeT | PaddingTypeT | ResolvedImageTypeT;
export declare type ArrayType = {
	kind: "array";
	itemType: Type;
	N: number;
};
export declare type Value = null | string | boolean | number | Color | Collator | Formatted | Padding | ResolvedImage | ReadonlyArray<Value> | {
	readonly [x: string]: Value;
};
declare class LngLatBounds {
	_ne: LngLat;
	_sw: LngLat;
	constructor(sw?: any, ne?: any);
	/**
	 * Set the northeast corner of the bounding box
	 *
	 * @param {LngLatLike} ne a {@link LngLatLike} object describing the northeast corner of the bounding box.
	 * @returns {LngLatBounds} `this`
	 */
	setNorthEast(ne: LngLatLike): this;
	/**
	 * Set the southwest corner of the bounding box
	 *
	 * @param {LngLatLike} sw a {@link LngLatLike} object describing the southwest corner of the bounding box.
	 * @returns {LngLatBounds} `this`
	 */
	setSouthWest(sw: LngLatLike): this;
	/**
	 * Extend the bounds to include a given LngLatLike or LngLatBoundsLike.
	 *
	 * @param {LngLatLike|LngLatBoundsLike} obj object to extend to
	 * @returns {LngLatBounds} `this`
	 */
	extend(obj: LngLatLike | LngLatBoundsLike): any;
	/**
	 * Returns the geographical coordinate equidistant from the bounding box's corners.
	 *
	 * @returns {LngLat} The bounding box's center.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.getCenter(); // = LngLat {lng: -73.96365, lat: 40.78315}
	 */
	getCenter(): LngLat;
	/**
	 * Returns the southwest corner of the bounding box.
	 *
	 * @returns {LngLat} The southwest corner of the bounding box.
	 */
	getSouthWest(): LngLat;
	/**
	 * Returns the northeast corner of the bounding box.
	 *
	 * @returns {LngLat} The northeast corner of the bounding box.
	 */
	getNorthEast(): LngLat;
	/**
	 * Returns the northwest corner of the bounding box.
	 *
	 * @returns {LngLat} The northwest corner of the bounding box.
	 */
	getNorthWest(): LngLat;
	/**
	 * Returns the southeast corner of the bounding box.
	 *
	 * @returns {LngLat} The southeast corner of the bounding box.
	 */
	getSouthEast(): LngLat;
	/**
	 * Returns the west edge of the bounding box.
	 *
	 * @returns {number} The west edge of the bounding box.
	 */
	getWest(): number;
	/**
	 * Returns the south edge of the bounding box.
	 *
	 * @returns {number} The south edge of the bounding box.
	 */
	getSouth(): number;
	/**
	 * Returns the east edge of the bounding box.
	 *
	 * @returns {number} The east edge of the bounding box.
	 */
	getEast(): number;
	/**
	 * Returns the north edge of the bounding box.
	 *
	 * @returns {number} The north edge of the bounding box.
	 */
	getNorth(): number;
	/**
	 * Returns the bounding box represented as an array.
	 *
	 * @returns {Array<Array<number>>} The bounding box represented as an array, consisting of the
	 *   southwest and northeast coordinates of the bounding represented as arrays of numbers.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.toArray(); // = [[-73.9876, 40.7661], [-73.9397, 40.8002]]
	 */
	toArray(): number[][];
	/**
	 * Return the bounding box represented as a string.
	 *
	 * @returns {string} The bounding box represents as a string of the format
	 *   `'LngLatBounds(LngLat(lng, lat), LngLat(lng, lat))'`.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.toString(); // = "LngLatBounds(LngLat(-73.9876, 40.7661), LngLat(-73.9397, 40.8002))"
	 */
	toString(): string;
	/**
	 * Check if the bounding box is an empty/`null`-type box.
	 *
	 * @returns {boolean} True if bounds have been defined, otherwise false.
	 */
	isEmpty(): boolean;
	/**
	 * Check if the point is within the bounding box.
	 *
	 * @param {LngLatLike} lnglat geographic point to check against.
	 * @returns {boolean} True if the point is within the bounding box.
	 * @example
	 * var llb = new maplibregl.LngLatBounds(
	 *   new maplibregl.LngLat(-73.9876, 40.7661),
	 *   new maplibregl.LngLat(-73.9397, 40.8002)
	 * );
	 *
	 * var ll = new maplibregl.LngLat(-73.9567, 40.7789);
	 *
	 * console.log(llb.contains(ll)); // = true
	 */
	contains(lnglat: LngLatLike): boolean;
	/**
	 * Converts an array to a `LngLatBounds` object.
	 *
	 * If a `LngLatBounds` object is passed in, the function returns it unchanged.
	 *
	 * Internally, the function calls `LngLat#convert` to convert arrays to `LngLat` values.
	 *
	 * @param {LngLatBoundsLike} input An array of two coordinates to convert, or a `LngLatBounds` object to return.
	 * @returns {LngLatBounds} A new `LngLatBounds` object, if a conversion occurred, or the original `LngLatBounds` object.
	 * @example
	 * var arr = [[-73.9876, 40.7661], [-73.9397, 40.8002]];
	 * var llb = maplibregl.LngLatBounds.convert(arr);
	 * llb;   // = LngLatBounds {_sw: LngLat {lng: -73.9876, lat: 40.7661}, _ne: LngLat {lng: -73.9397, lat: 40.8002}}
	 */
	static convert(input: LngLatBoundsLike | null): LngLatBounds;
}
/**
 * A {@link LngLatBounds} object, an array of {@link LngLatLike} objects in [sw, ne] order,
 * or an array of numbers in [west, south, east, north] order.
 *
 * @typedef {LngLatBounds | [LngLatLike, LngLatLike] | [number, number, number, number]} LngLatBoundsLike
 * @example
 * var v1 = new maplibregl.LngLatBounds(
 *   new maplibregl.LngLat(-73.9876, 40.7661),
 *   new maplibregl.LngLat(-73.9397, 40.8002)
 * );
 * var v2 = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002])
 * var v3 = [[-73.9876, 40.7661], [-73.9397, 40.8002]];
 */
export declare type LngLatBoundsLike = LngLatBounds | [
	LngLatLike,
	LngLatLike
] | [
	number,
	number,
	number,
	number
];
declare class LngLat {
	lng: number;
	lat: number;
	constructor(lng: number, lat: number);
	/**
	 * Returns a new `LngLat` object whose longitude is wrapped to the range (-180, 180).
	 *
	 * @returns {LngLat} The wrapped `LngLat` object.
	 * @example
	 * var ll = new maplibregl.LngLat(286.0251, 40.7736);
	 * var wrapped = ll.wrap();
	 * wrapped.lng; // = -73.9749
	 */
	wrap(): LngLat;
	/**
	 * Returns the coordinates represented as an array of two numbers.
	 *
	 * @returns {Array<number>} The coordinates represeted as an array of longitude and latitude.
	 * @example
	 * var ll = new maplibregl.LngLat(-73.9749, 40.7736);
	 * ll.toArray(); // = [-73.9749, 40.7736]
	 */
	toArray(): number[];
	/**
	 * Returns the coordinates represent as a string.
	 *
	 * @returns {string} The coordinates represented as a string of the format `'LngLat(lng, lat)'`.
	 * @example
	 * var ll = new maplibregl.LngLat(-73.9749, 40.7736);
	 * ll.toString(); // = "LngLat(-73.9749, 40.7736)"
	 */
	toString(): string;
	/**
	 * Returns the approximate distance between a pair of coordinates in meters
	 * Uses the Haversine Formula (from R.W. Sinnott, "Virtues of the Haversine", Sky and Telescope, vol. 68, no. 2, 1984, p. 159)
	 *
	 * @param {LngLat} lngLat coordinates to compute the distance to
	 * @returns {number} Distance in meters between the two coordinates.
	 * @example
	 * var new_york = new maplibregl.LngLat(-74.0060, 40.7128);
	 * var los_angeles = new maplibregl.LngLat(-118.2437, 34.0522);
	 * new_york.distanceTo(los_angeles); // = 3935751.690893987, "true distance" using a non-spherical approximation is ~3966km
	 */
	distanceTo(lngLat: LngLat): number;
	/**
	 * Returns a `LngLatBounds` from the coordinates extended by a given `radius`. The returned `LngLatBounds` completely contains the `radius`.
	 *
	 * @param {number} [radius=0] Distance in meters from the coordinates to extend the bounds.
	 * @returns {LngLatBounds} A new `LngLatBounds` object representing the coordinates extended by the `radius`.
	 * @example
	 * var ll = new maplibregl.LngLat(-73.9749, 40.7736);
	 * ll.toBounds(100).toArray(); // = [[-73.97501862141328, 40.77351016847229], [-73.97478137858673, 40.77368983152771]]
	 */
	toBounds(radius?: number): LngLatBounds;
	/**
	 * Converts an array of two numbers or an object with `lng` and `lat` or `lon` and `lat` properties
	 * to a `LngLat` object.
	 *
	 * If a `LngLat` object is passed in, the function returns it unchanged.
	 *
	 * @param {LngLatLike} input An array of two numbers or object to convert, or a `LngLat` object to return.
	 * @returns {LngLat} A new `LngLat` object, if a conversion occurred, or the original `LngLat` object.
	 * @example
	 * var arr = [-73.9749, 40.7736];
	 * var ll = maplibregl.LngLat.convert(arr);
	 * ll;   // = LngLat {lng: -73.9749, lat: 40.7736}
	 */
	static convert(input: LngLatLike): LngLat;
}
/**
 * A {@link LngLat} object, an array of two numbers representing longitude and latitude,
 * or an object with `lng` and `lat` or `lon` and `lat` properties.
 *
 * @typedef {LngLat | {lng: number, lat: number} | {lon: number, lat: number} | [number, number]} LngLatLike
 * @example
 * var v1 = new maplibregl.LngLat(-122.420679, 37.772537);
 * var v2 = [-122.420679, 37.772537];
 * var v3 = {lon: -122.420679, lat: 37.772537};
 */
export declare type LngLatLike = LngLat | {
	lng: number;
	lat: number;
} | {
	lon: number;
	lat: number;
} | [
	number,
	number
];
declare class MercatorCoordinate {
	x: number;
	y: number;
	z: number;
	constructor(x: number, y: number, z?: number);
	/**
	 * Project a `LngLat` to a `MercatorCoordinate`.
	 *
	 * @param {LngLatLike} lngLatLike The location to project.
	 * @param {number} altitude The altitude in meters of the position.
	 * @returns {MercatorCoordinate} The projected mercator coordinate.
	 * @example
	 * var coord = maplibregl.MercatorCoordinate.fromLngLat({ lng: 0, lat: 0}, 0);
	 * coord; // MercatorCoordinate(0.5, 0.5, 0)
	 */
	static fromLngLat(lngLatLike: LngLatLike, altitude?: number): MercatorCoordinate;
	/**
	 * Returns the `LngLat` for the coordinate.
	 *
	 * @returns {LngLat} The `LngLat` object.
	 * @example
	 * var coord = new maplibregl.MercatorCoordinate(0.5, 0.5, 0);
	 * var lngLat = coord.toLngLat(); // LngLat(0, 0)
	 */
	toLngLat(): LngLat;
	/**
	 * Returns the altitude in meters of the coordinate.
	 *
	 * @returns {number} The altitude in meters.
	 * @example
	 * var coord = new maplibregl.MercatorCoordinate(0, 0, 0.02);
	 * coord.toAltitude(); // 6914.281956295339
	 */
	toAltitude(): number;
	/**
	 * Returns the distance of 1 meter in `MercatorCoordinate` units at this latitude.
	 *
	 * For coordinates in real world units using meters, this naturally provides the scale
	 * to transform into `MercatorCoordinate`s.
	 *
	 * @returns {number} Distance of 1 meter in `MercatorCoordinate` units.
	 */
	meterInMercatorCoordinateUnits(): number;
}
declare class CanonicalTileID {
	z: number;
	x: number;
	y: number;
	key: string;
	constructor(z: number, x: number, y: number);
	equals(id: CanonicalTileID): boolean;
	url(urls: Array<string>, pixelRatio: number, scheme?: string | null): string;
	isChildOf(parent: CanonicalTileID): boolean;
	getTilePoint(coord: MercatorCoordinate): Point;
	toString(): string;
}
declare class EvaluationContext {
	globals: GlobalProperties;
	feature: Feature;
	featureState: FeatureState;
	formattedSection: FormattedSection;
	availableImages: Array<string>;
	canonical: CanonicalTileID;
	_parseColorCache: {
		[_: string]: Color;
	};
	constructor();
	id(): any;
	geometryType(): string;
	geometry(): import("@mapbox/point-geometry")[][];
	canonicalID(): CanonicalTileID;
	properties(): {
		[_: string]: any;
	};
	parseColor(input: string): Color;
}
/**
 * Expression
 */
export interface Expression {
	readonly type: Type;
	evaluate(ctx: EvaluationContext): any;
	eachChild(fn: (a: Expression) => void): void;
	/**
	 * Statically analyze the expression, attempting to enumerate possible outputs. Returns
	 * false if the complete set of outputs is statically undecidable, otherwise true.
	 */
	outputDefined(): boolean;
}
/**
 * A type used for returning and propagating errors. The first element of the union
 * represents success and contains a value, and the second represents an error and
 * contains an error value.
 * @private
 */
export declare type Result<T, E> = {
	result: "success";
	value: T;
} | {
	result: "error";
	value: E;
};
export declare type InterpolationType = {
	name: "linear";
} | {
	name: "exponential";
	base: number;
} | {
	name: "cubic-bezier";
	controlPoints: [
		number,
		number,
		number,
		number
	];
};
export declare type Feature = {
	readonly type: 1 | 2 | 3 | "Unknown" | "Point" | "MultiPoint" | "LineString" | "MultiLineString" | "Polygon" | "MultiPolygon";
	readonly id?: any;
	readonly properties: {
		[_: string]: any;
	};
	readonly patterns?: {
		[_: string]: {
			"min": string;
			"mid": string;
			"max": string;
		};
	};
	readonly geometry?: Array<Array<Point>>;
};
export declare type FeatureState = {
	[_: string]: any;
};
export declare type GlobalProperties = Readonly<{
	zoom: number;
	heatmapDensity?: number;
	lineProgress?: number;
	isSupportedScript?: (_: string) => boolean;
	accumulated?: Value;
}>;
declare class StyleExpression {
	expression: Expression;
	_evaluator: EvaluationContext;
	_defaultValue: Value;
	_warningHistory: {
		[key: string]: boolean;
	};
	_enumValues: {
		[_: string]: any;
	};
	constructor(expression: Expression, propertySpec?: StylePropertySpecification | null);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
}
declare function isExpression(expression: unknown): boolean;
declare function createExpression(expression: unknown, propertySpec?: StylePropertySpecification | null): Result<StyleExpression, Array<ExpressionParsingError>>;
declare class ZoomConstantExpression<Kind extends EvaluationKind> {
	kind: Kind;
	isStateDependent: boolean;
	_styleExpression: StyleExpression;
	constructor(kind: Kind, expression: StyleExpression);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
}
declare class ZoomDependentExpression<Kind extends EvaluationKind> {
	kind: Kind;
	zoomStops: Array<number>;
	isStateDependent: boolean;
	_styleExpression: StyleExpression;
	interpolationType: InterpolationType;
	constructor(kind: Kind, expression: StyleExpression, zoomStops: Array<number>, interpolationType?: InterpolationType);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	interpolationFactor(input: number, lower: number, upper: number): number;
}
export declare type ConstantExpression = {
	kind: "constant";
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>) => any;
};
export declare type SourceExpression = {
	kind: "source";
	isStateDependent: boolean;
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection) => any;
};
export declare type CameraExpression = {
	kind: "camera";
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>) => any;
	readonly interpolationFactor: (input: number, lower: number, upper: number) => number;
	zoomStops: Array<number>;
	interpolationType: InterpolationType;
};
export declare type CompositeExpression = {
	kind: "composite";
	isStateDependent: boolean;
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection) => any;
	readonly interpolationFactor: (input: number, lower: number, upper: number) => number;
	zoomStops: Array<number>;
	interpolationType: InterpolationType;
};
export declare type StylePropertyExpression = ConstantExpression | SourceExpression | CameraExpression | CompositeExpression;
declare function createPropertyExpression(expressionInput: unknown, propertySpec: StylePropertySpecification): Result<StylePropertyExpression, Array<ExpressionParsingError>>;
declare class StylePropertyFunction<T> {
	_parameters: PropertyValueSpecification<T>;
	_specification: StylePropertySpecification;
	kind: EvaluationKind;
	evaluate: (globals: GlobalProperties, feature?: Feature) => any;
	interpolationFactor: ((input: number, lower: number, upper: number) => number);
	zoomStops: Array<number>;
	constructor(parameters: PropertyValueSpecification<T>, specification: StylePropertySpecification);
	static deserialize<T>(serialized: {
		_parameters: PropertyValueSpecification<T>;
		_specification: StylePropertySpecification;
	}): StylePropertyFunction<T>;
	static serialize<T>(input: StylePropertyFunction<T>): {
		_parameters: PropertyValueSpecification<T>;
		_specification: StylePropertySpecification;
	};
}
declare function normalizePropertyExpression<T>(value: PropertyValueSpecification<T>, specification: StylePropertySpecification): StylePropertyExpression;
export declare type FilterExpression = (globalProperties: GlobalProperties, feature: Feature, canonical?: CanonicalTileID) => boolean;
export declare type FeatureFilter = {
	filter: FilterExpression;
	needGeometry: boolean;
};
declare function isExpressionFilter(filter: any): filter is ExpressionFilterSpecification;
declare function createFilter(filter: any): FeatureFilter;
export declare type ExpectedTypes = {
	[_: string]: ExpressionInputType;
};
export function convertFilter(filter: FilterSpecification, expectedTypes?: ExpectedTypes): ExpressionFilterSpecification;
declare function isFunction(value: any): boolean;
declare function createFunction(parameters: any, propertySpec: any): {
	kind: string;
	interpolationType: {
		name: string;
	};
	interpolationFactor: any;
	zoomStops: any[];
	evaluate({ zoom }: {
		zoom: any;
	}, properties: any): any;
} | {
	kind: string;
	interpolationType: {
		name: string;
		base: any;
	};
	interpolationFactor: any;
	zoomStops: any;
	evaluate: ({ zoom }: {
		zoom: any;
	}) => any;
} | {
	kind: string;
	evaluate(_: any, feature: any): any;
	interpolationType?: undefined;
	interpolationFactor?: undefined;
	zoomStops?: undefined;
};
declare function convertFunction(parameters: any, propertySpec: StylePropertySpecification): any;
declare function eachSource(style: StyleSpecification, callback: (_: SourceSpecification) => void): void;
declare function eachLayer(style: StyleSpecification, callback: (_: LayerSpecification) => void): void;
export declare type PropertyCallback = (a: {
	path: [
		string,
		"paint" | "layout",
		string
	];
	key: string;
	value: PropertyValueSpecification<unknown> | DataDrivenPropertyValueSpecification<unknown>;
	reference: StylePropertySpecification;
	set: (a: PropertyValueSpecification<unknown> | DataDrivenPropertyValueSpecification<unknown>) => void;
}) => void;
declare function eachProperty(style: StyleSpecification, options: {
	paint?: boolean;
	layout?: boolean;
}, callback: PropertyCallback): void;
declare function validateStyle(style: StyleSpecification | string | Buffer, styleSpec?: any): Array<ValidationError>;
export declare type ExpressionType = "data-driven" | "cross-faded" | "cross-faded-data-driven" | "color-ramp" | "data-constant" | "constant";
export declare type ExpressionParameters = Array<"zoom" | "feature" | "feature-state" | "heatmap-density" | "line-progress">;
export declare type ExpressionSpecificationDefinition = {
	interpolated: boolean;
	parameters: ExpressionParameters;
};
export declare type StylePropertySpecification = {
	type: "number";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: number;
} | {
	type: "string";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: string;
	tokens?: boolean;
} | {
	type: "boolean";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: boolean;
} | {
	type: "enum";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	values: {
		[_: string]: {};
	};
	transition: boolean;
	default?: string;
} | {
	type: "color";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: string;
	overridable: boolean;
} | {
	type: "array";
	value: "number";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	length?: number;
	transition: boolean;
	default?: Array<number>;
} | {
	type: "array";
	value: "string";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	length?: number;
	transition: boolean;
	default?: Array<string>;
} | {
	type: "padding";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: number | Array<number>;
};
export declare const v8: any;
export declare const expression: {
	StyleExpression: typeof StyleExpression;
	isExpression: typeof isExpression;
	isExpressionFilter: typeof isExpressionFilter;
	createExpression: typeof createExpression;
	createPropertyExpression: typeof createPropertyExpression;
	normalizePropertyExpression: typeof normalizePropertyExpression;
	ZoomConstantExpression: typeof ZoomConstantExpression;
	ZoomDependentExpression: typeof ZoomDependentExpression;
	StylePropertyFunction: typeof StylePropertyFunction;
};
declare const styleFunction: {
	convertFunction: typeof convertFunction;
	createFunction: typeof createFunction;
	isFunction: typeof isFunction;
};
export declare const visit: {
	eachSource: typeof eachSource;
	eachLayer: typeof eachLayer;
	eachProperty: typeof eachProperty;
};

export {
	_default as latest,
	createFilter as featureFilter,
	diffStyles as diff,
	styleFunction as function,
	validateStyle as validate,
};

export {};
