"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addAlertsMethods = addAlertsMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addAlertsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_ALERTS] = createAction({
    url: {
      fmt: `${_constants.API.GET_ALERTS}?detector_id=<%=detector_id%>`,
      req: {
        detector_id: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.ACKNOWLEDGE_ALERTS] = createAction({
    url: {
      fmt: `${_constants.BASE_API_PATH}/detectors/<%=detector_id%>/_acknowledge/alerts`,
      req: {
        detector_id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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